/* REXX OS/2 - PrfrmSD.CMD  perform a Save Desktop function         */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a SaveDesktop function.                            
        The DRC file specified will be used to save the objects     
        located on the desktop.                                     
                                                                    
        Note: no REXX generation is performed.                      
              The current Update/Replace settings for the DRC       
              file, icon directory, data directory and              
              the save options, as specified for the DeskMan/2      
              object are used.                                      
              They can be overriden by adding the corresponding     
              setup strings to the SysSetObjectData call -          
              see comments below.                                   
                                                                    
        The format is:                                              
        PerformSaveDesktop=x:\path\file.drc;                        
                                                                    
*/

/* Execute as: PERFSD x:\deskman\test.drc                           */

Arg DRCfile . ;  /* accept the DRC file name as parameter           */

If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(DRCfile, 1) <> ';'
   Then DRCfile=DRCfile||';';     /* remember! SEMICOLON */

setupString='PerformSaveDesktop='||DRCfile;

   /* this is the default setup string, which accepts the current
    | DeskMan/2 settings.
    | If you would like to change any of the settings before executing
    | the Save, add corresponding KEYWORD=value pairs to the setupString.
    | Example:
    | . to change the Save icons setting:
    |   setupString='SAVEICONS=NO;' || setupString;
    | . to change the Save icon position setting:
    |   setupString='SAVEICONPOSITION=YES;' || setupString;
    | . to change the icons directory:
    |   setupString='ICONDIRECTORY=x:\path;' || setupString;
    | . to change the Save data files setting:
    |   setupString='SAVEDATAFILES=YES;' || setupString;
    | . etc. all keywords listed in the DeskMan.CFG file can be used.
    |   Any logical combination is allowed.
    | Note: the values will change the current DeskMan/2 object settings!
    */

rc=SysSetObjectData('<DeskMan1>', setupString);
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Save Desktop!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Save desktop initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/
