/* REXX OS/2 - PerfRD.CMD  perform a Restore Desktop function       */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a RestoreDesktop function.                         
        The DRC file specified will be used to restore the objects  
        located on the desktop. The presence of a Desktop object    
        in the DRC file is REQUIRED. If you have used a desktop     
        replacement object (Extended Desktop, etc.), you will       
        have to install it before executing the Restore desktop     
        function, either manually or by using PERFRO.CMD.           
                                                                    
        The format is:                                              
        PerformRestoreDesktop=x:\path\file.drc,OPTION;              
                                                                    
        OPTION can be: SKIP, UPDATE, REPLACE, BYPASS                
                         NOTE: BYPASS (like REPLACE, limited class  
                               replacement and private classes      
                               support, no searching for duplicate  
                               objects, no icon optimization,       
                               no data files restoration but        
                               2-10 times faster than REPLACE)      
                                                                    
        If not specified, the current DeskMan/2 restore option      
        willl be used (except for BYPASS).                          
                                                                    
        Note: The current Search everywhere setting and the         
              Skip/Update/Replace option for the Desktop            
              restore operation, as specified for the DeskMan/2     
              object, is used.                                      
              They can be overriden by adding the corresponding     
              setup strings to the SysSetObjectData call -          
              see comments below.                                   
                                                                    
*/

/* Execute as: PERFRD x:\deskman\test.drc SKIP                      */

              /* accept the DRC file name and option as parameters  */
Arg DRCfile option .;
option=Translate(option);                              /* upperCASE */

If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(option, 1) <> ';'
   Then semicolon=';';                        /* remember! SEMICOLON */
   Else semicolon='';

If option = ''
   Then
     setupString = 'PerformRestoreDesktop='DRCfile||semicolon;
   Else
     setupString = 'PerformRestoreDesktop='DRCfile||','||option||semicolon;

   /* this is the default setup string, which accepts the current
    | DeskMan/2 settings.
    | If you would like to change any of the settings before executing
    | the Save, add corresponding KEYWORD=value pairs to the setupString.
    | Example:
    | . to change the Restore option:
    |   setupString='RESTORESKIP=YES;' || setupString;
    |
    | . to change the Search everywhere setting:
    |   setupString='RESTORESEARCH=YES;' || setupString;
    |
    | . to change the Prompt setting:
    |   setupString='RESTOREPROMPT=YES;' || setupString;
    |
    | . etc. all keywords listed in the DeskMan.CFG file can be used.
    |   Any logical combination is allowed.
    | Note: the values will change the current DeskMan/2 object settings!
    */

rc=SysSetObjectData('<DeskMan1>', setupString);

If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Restore Desktop!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Restore desktop initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/

