/* REXX OS/2 - PerfMO.CMD  perform a Move object function           */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Moves the object of the name-object located in the          
        FolderName-folder to the ToFolderName-folder.               
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformMoveObject=name,FolderName,ToFolderName;             
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . fully qualified path                 
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used.                                               
        ToFolderName can be: . folder title                         
                             . object ID                            
                             . fully qualified path                 
                                                                    
*/

/* Execute as: PERFMO Name Folder ToFolder                          */

Parse Arg args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' args;
   Else Parse Var args    folder    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'ToFolder'"' .;
   Else Parse Var args    ToFolder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If ToFolder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the target folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformMoveObject='object','folder','ToFolder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Move object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Move object initiated successfully!';
Exit 0;                

