/* REXX OS/2 - PerfCls.CMD Close a view of an object                */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a Close function on the specified object           
        located in the FolderName-folder                            
        Note: a variation of the PerfSET.CMD                        
                                                                    
        Note: Uses DeskMan/2 WPS Extensions setup strings           
              and can be used only on systems having the            
              Extensions installed!                                 
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformSetup=objectName,FolderName,CLOSE=View               
                                                                    
        objectName can be:   . object title                         
                             . object ID                            
                             . fully qualified path                 
                                                                    
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
                                                                    
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used.                                               
                                                                    
        View can be:         . DEFAULT - the default view of an     
                               object will be closed, generally     
                               the one opened with a double-click   
                             . DETAILS (folder only) - the Details  
                               view will be closed,                 
                             . ICON (folder only) - the Icon view   
                               will be closed,                      
                             . TREE (folder only) - the Tree view   
                               will be closed,                      
                             . SETTINGS - the Settings will be      
                               closed,                              
                             . ALL - all views of the object,       
                               including those of menu items added  
                               to the popup menu, will be closed.   
                                                                    
*/

/* Execute as: PERFCLS Name Folder View                             */

Parse Arg args;
args = Strip(args);

If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;

args = Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' view;
   Else Parse Var args    folder    view;

setupString = Strip(view);
setupString = Strip(view, 'B', '"');
setupString = Strip(view);
setupString = Strip(view, 'T', ';');

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If view  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: CLOSE=DEFAULT assumed.';
     view = "DEFAULT";
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc = SysSetObjectData('<DeskMan1>',,
                      'PerformSetup='object','folder',CLOSE='view';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing CLOSE on the "object" object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: CLOSE performed successfully!';
Exit 0;                

