/* REXX OS/2 - DM2ExtS.CMD configures DeskMan/2 WPS Extensions      */
/*             use DM2Ext.CF1 file                                  */
/*             see DM2Ext.CF1 for values required                   */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                    September 1994    
      RC returned:                                                  
                                                                    
      0 = run successful                                            
      99= ERROR                                                     
*/

Arg CFGfile . ;  /* accept the CFG file name as parameter             */

If CFGfile = ''
   Then Do;
     Say 'DM/2 WPS Extensions: the CFG file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

ini.='';

If \ ParseCFG(CFGfile)
   Then Exit 99;               /* error while parsing - exit with error */

Settings='DMExtMinimize DMExtAddOpen DMExtAddClose DMExtRestartWPS',
         'DMExtProtection DMExtProtect',
         'DMExtRemoveArrange DMExtRemoveSort DMExtRemoveFind',
         'DMExtRemoveShutdown DMExtRemoveSystemSetup DMExtRemoveLockUp',
         'DMExtRemoveSettings DMExtAllowDelete DMExtAllowMove DMExtAllowCopy',
         'DMExtAllowRename DMExtAllowNew DMExtAllowShadow',
         'DMExtAllowDrag DMExtDragDrop',
         'DMExtObjectOverride DMExtFolderOverride',
         'DMExtAllowDrop DMExtRemoveSelect DMExtAllowVisible DMExtSaveWinPos' ,
         /* GLOBAL Extensions settings up to here! */                         ,
         'DMExtArmed DMExtPassword';  /* object specific values here!   */
         
error = 0;
setup= '';
Do i = 1 to Words(Settings);
   word = Translate(Word(Settings, i));
   x = Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DM/2 WPS Extensions:' word 'value will be left UNCHANGED!';
        Iterate;
        End;

   If Right(ini.word, 1) <>';'
      Then ini.word = ini.word||';';

   setup = setup || Word(Settings, i)'='ini.word;

End;

rc = SysSetObjectData("<WP_SYSTEM>", setup);

If rc <> 1 
   Then Do;
     Say 'Setup: DeskMan/2 WPS Extensions ERROR while performing setup';
     Exit 99;                  /* run in error    -   Exit!             */
     End;
   Else Do;
     Say 'Setup: DeskMan/2 WPS Extensions were configured successfully!';
     Exit 0;                   /* successfull run -   Exit!             */
     End;



/* ----------------------------------------------------------------*/
ParseCFG: Procedure Expose ini.

CFGfile=Arg(1);           /* the CFG file name */

linenum=0;
Do While Lines(CFGfile);
   line=Linein(CFGfile);
   linenum=linenum + 1;
   If Left(line,1) = '*'
      Then Iterate;       /* skip comment lines */

   Parse Var line keyword '=' value ;
   keyword = Translate(Strip(keyword));
   value = Translate(Strip(value));
   If ini.keyword <> ''
      Then Do;
        Say 'DM/2 WPS Extensions: duplicate keyword in line' linenum 'ignored.';
        Iterate;
        End;
   If value = ''
      Then Do;
        Say 'DM/2 WPS Extensions: invalid value for the' keyword 'keyword in line' linenum;
        Return 0;
        End;
   ini.keyword=value;
End;
Call Stream CFGfile, 'C', 'CLOSE';

Return 1;


