/*REXXOS/2Ŀ
  CleanUp.CMD - part of DeskMan/2                                     1.51    
                Removes unused *.ICO files for a specified directory.         
  Mar. 25, 93   Handle root directories properly                              
  Jun. 09, 93   Remove DataFiles                                              
  Aug. 23, 93   Remove read-only and hidden files                             
  Copyright:    Development Technologies, Inc. & Gregory Czaja 1993-1994      
*/

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           
                                    /* directory can be specified on call     */
Parse Arg args;

If Left(args,1) ='"'                /* LongNames will be enclosed in ""       */
   Then
     Parse Var args '"'_dir'"' args;
   Else
     Parse Var args _dir args;
If Left(args,1) ='"'
   Then
     Parse Var args '"'_ico_dir'"' args;
   Else
     Parse Var args _ico_dir args;
If Left(args,1) ='"'
   Then
     Parse Var args '"'_data_dir'"' args;
   Else
     Parse Var args _data_dir args;

If _dir='/?' | _dir='-?' | _dir='?' /* Help requested?                        */
   Then Do;
     Say '';
     Say 'Cleanup.CMD (part of DeskMan/2) can be used to remove obsolete';
     Say 'icons and data files which are no longer referenced by stored';
     Say 'object descriptions contained in the .DRC or .CMD files.'
     Say '';
     Say 'Use: ';
     Say '';
     Say '   CLEANUP [<directory> [<icon_directory> [<data_directory>]]]';
     Say '';
     Say 'to remove all non-referenced icons from <icon_directory> and all';
     Say 'non-referenced data files from <data_directory>.  Items referenced'; 
     Say 'in either .DRC or .CMD files located in <directory> will not be';
     Say 'removed.  If either <icon_directory> or <data_directory> is not';
     Say 'specified, it will default to <directory>\ICO and <directory>\DATA.';
     Say '';
     Say 'Note: Enclose directory names in "" if using HPFS long names!';
     Say '';
     Exit;
     End;

If _dir='' Then _dir=Directory();    /* was the directory specified on call?   */
                                     /* if not, use the current one            */
If _ico_dir='' Then _ico_dir=_dir||'\ICO';

If _data_dir='' Then _data_dir=_dir||'\DATA';;

Say 'DeskMan/2 - CleanUp program';
Say 'Caution: Review the following information carefully.  Stored Backup data';
Say 'is about to be removed.  Please note the directories specified, and be';
Say 'sure that they are the ones desired.';
Say '';
Say 'The' _dir 
Say 'directory will be searched for the .DRC and .CMD files to be scanned!';
Say 'Is this the correct directory? Enter Y(es) to confirm, anything else to cancel!';
Say '';
If Translate(SysGetKey()) <> 'Y'
   Then Exit;
Say '';
Say '';
Say 'The' _ico_dir
Say 'directory will be searched for the icon files to be deleted!';
Say 'Is this the correct directory? Enter Y(es) to confirm, anything else to cancel!';
Say '';
If Translate(SysGetKey()) <> 'Y'
   Then Exit;
Say '';
Say '';
Say 'The' _data_dir
Say 'directory will be searched for the Data files to be deleted!';
Say 'Is this the correct directory? Enter Y(es) to confirm, anything else to cancel!';
Say '';
If Translate(SysGetKey()) <> 'Y'
   Then Exit;
Say '';
Say '';

If Right(_dir, 1) \= '\'
   Then _dir=_dir||'\';
If Right(_ico_dir, 1) \= '\'
   Then _ico_dir=_ico_dir||'\';
If Right(_data_dir, 1) \= '\'
   Then _data_dir=_data_dir||'\';
                                     /* up it up                              */
_dir=Translate(_dir); _ico_dir=Translate(_ico_dir); _data_dir=Translate(_data_dir);

rc=SysFileTree(_dir||'*.CMD', 'files.', 'FO');
If rc <> 0                          /* look for all the CMD files             */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;

icons.=0;
Call FindIcons;                     /* grab all icons used                    */

rc=SysFileTree(_dir||'*.DRC', 'files.', 'FO');
If rc <> 0                          /* look for all the DRC files             */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;
Call FindIcons;                     /* grab the icons used                    */

rc=SysFileTree(_ico_dir||'*.ICO', 'files.', 'FO');
If rc <> 0                          /* get all the ICO files now...           */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;

Say '';
Say 'Erasing icon files not referenced by .DRC and .CMD files:';

Do i=1 to files.0;                  /* do the checking now                    */
   icon=Translate(files.i);
   If icons.icon Then Iterate;      /* it is referenced somewhere             */
   '@ERASE 'icon;                   /* it's not - delete...                   */
   Say icon 'was erased!';
End;
Say 'End processing ICO files -----------------------------';
Say '';
                                    /* now do the same for data files         */
rc=SysFileTree(_dir||'*.CMD', 'files.', 'FO');
If rc <> 0                          /* look for all the CMD files             */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;

datas.=0;
Call FindFiles;                     /* grab all files used                    */

rc=SysFileTree(_dir||'*.DRC', 'files.', 'FO');
If rc <> 0                          /* look for all the DRC files             */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;
Call FindFiles;                     /* grab the files used                    */

rc=SysFileTree(_data_dir||'*.*', 'files.', 'FO');
If rc <> 0                          /* get all the files now...              */
   Then Do;
     Say 'CleanUp.CMD - Unexpected error!';
     Exit 99;
     End;

Say '';
Say 'Erasing data files not referenced by .DRC and .CMD files:';

'ATTRIB '_data_dir||'*.* -h -r';    /* reset hidden and read-only attributes  */

Do i=1 to files.0;                  /* do the checking now                    */
   data=Translate(files.i);
   If SysGetEA(data, '.CLASSINFO', 'classInfo') <> 0
      Then Iterate;                 /* it has no classinfo EA! ignore         */
   If classInfo = ''                /* no .CLASSINFO                          */
      Then Iterate;
                       /* we don't touch files NOT created by DeskMan/2 (WPS) */
   /* WPDataFile class name not searched - it may be replaced by private class*/
   If datas.data Then Iterate;      /* it is referenced somewhere             */
   unFullData=FileSpec('Name',data);/* check the unqualified name             */
   /* data files may be located either in a dedicated directory or current one*/
   If datas.unFullData Then Iterate;/* used - by unqualified name             */
 
   '@ERASE "'data'"';               /* it's not - delete...                   */
   Say data 'was erased!';
End;
Say 'End processing data files -----------------------------';

Exit 0;
/*----------------------------------------------------------------------------*/
FindIcons: Procedure Expose icons. files.

Do i=1 to files.0;                  /* scan all the files for ICONFILEs       */
   Say 'Processing:' files.i;
   rc=SysFileSearch('ICONFILE=', files.i, 'lines.');
   If rc = 3                        /* ignore 0 length files                  */
      Then Iterate;
   If rc <> 0
     Then Do;
       Say 'CleanUp.CMD - error reading: 'files.i' - file ignored!';
       Iterate;
       End;
   Do j=1 to lines.0;
      Parse Var lines.j 'ICONFILE=' _ico ';' .
      k=icons.0+1;
      icons.0=k;
      _ico=Translate(_ico);
      icons._ico=1;
   End;
End;

Return;

FindFiles: Procedure Expose datas. files.

Do i=1 to files.0;                  /* scan all the files for DataFiles      */
   Say 'Processing:' files.i;
   rc=SysFileSearch('DeskManDATAFILE=', files.i, 'lines.');
   If rc = 3                        /* ignore 0 length files                 */
      Then Iterate;
   If rc <> 0
     Then Do;
       Say 'CleanUp.CMD - Unexpected error reading: 'files.i' - file ignored!';
       Iterate;
       End;
   Do j=1 to lines.0;
      Parse Var lines.j 'DeskManDATAFILE=' _data ';' .
      k=datas.0+1;
      datas.0=k;
      _data=Translate(_data);
      datas._data=1;
   End;
End;

Return;
