#
# NMAKE include file for Autodesk SQL Interface NT builds
#
# Macro assumptions:
#   LOCINC = list of additional include dirs for local makefile
# LOCCFLAG = additional cflags for compiler command line
#    DEBUG = defined, for full debugging
#

# Turn on debugging switches if DEBUG is set.
# This is located before ntwin32.mak because NODEBUG is used in that file.
!IF "$(DEBUG)" == "NO"
NODEBUG = 1
ADFLAGS = /Mx
!ELSE
DFLAGS  = -DDEBUG=1
ADFLAGS = /Mx /ZI
!ENDIF

!include <ntwin32.mak>

# These should be defined this way in msvcnt's ntwin32.mak, but
# they're set to cl386 and link32 instead, which give us warnings
# and then call cl and link!
cc = cl
link = link
libexe = lib

#   Allow makefile to add its own local include path.
CF0 =
!ifdef LOCINC
!if "$(LOCINC)x" != "x"
CF0 = -I$(LOCINC: = -I)
!endif # LOCINC not empty
!endif # LOCINC defined

#   Allow makefile to add its own local cflags
!ifndef LOCCFLAG
LOCCFLAG =
!endif

#   The following line specifies the C compiler options.
#   The cflags and cvars macros come from ntwin32.mak

!IF "$(SHOWWARNINGS)" == "YES"
CF1 = -nologo $(cflags) $(cvarsmt) $(CF0) -DPROTOTYPES -DWIN -WX -DRADPACK
!ELSE
CF1 = -nologo $(cflags) $(cvarsmt) $(CF0) -DPROTOTYPES -DWIN -DRADPACK
!ENDIF

ASM = $(AC)\tntools\bin\masm386 /Ml /DMSC $(AFLAGS)

.SUFFIXES:
.SUFFIXES: .obj .asm .c .cc .cpp

#   Compile normally
     
CMPL = $(cc) $(cdebug) $(LOCCFLAG) $(CF1) -Fd$(VPATH)\ -Fo$(VPATH)\ $(DFLAGS)

# Normal compile rule
{.}.c{$(VPATH)}.obj:
    @echo Compiling $(@B).c
    @if exist $@ del $@
    @($(CMPL) $(@B).c > $(@B).err && del $(@B).err) || type $(@B).err

# Normal compile rule
{.}.cc{$(VPATH)}.obj:
    @echo Compiling $(@B).cc
    @if exist $@ del $@
    @($(CMPL) -Tp$(@B).cc > $(@B).err && del $(@B).err) || type $(@B).err

# Normal compile rule
{.}.cpp{$(VPATH)}.obj:
    @echo Compiling $(@B).cpp
    @if exist $@ del $@
    @($(CMPL) -Tp$(@B).cpp > $(@B).err && del $(@B).err) || type $(@B).err

# Normal assembly rule
{.}.asm{$(VPATH)}.obj:
    @echo Assembling $(@B).asm
    @if exist $@ del $@
    @($(ASM) $(@B).asm,$(VPATH)\$(@B).obj,NUL, NUL; > $(@B).err && del $(@B).err) || type $(@B).err
