/*****************************************************************************
    Name: asiconf.h

    Description:  Windows initialization file and asi configuration file classes

    Author: Alexander Nikolayev & Oleg Chashin
            Autodesk, Inc.
            Moscow, Russia.

      (C) Copyright 1991-93 by Autodesk, Inc.
   ***************************************************************************
      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1993 by Autodesk, Inc."
   ***************************************************************************

      THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
      WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
      PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.

   ***************************************************************************
                           RESTRICTED RIGHTS LEGEND

      Use, duplication, or disclosure by the U.S. Government is subject
      to restrictions set forth in FAR 52.227-19 (Commerical Computer
      Software - Restricted Rights) and DFAR 252.227-7013 (c) (1) (ii)
      (Rights in Technical Data and Computer Software), as applicable.
   ***************************************************************************


    Entry Points:

    Modification History:
       27 Sep 1993  - ann    -  original written

    Bugs and restriction on use:

    Notes:

*****************************************************************************/
#ifndef ASI_ASICONF_HH
#define ASI_ASICONF_HH asiconfhh

//////////////////////////////////////////////////////////////////////////////
//
// TYPEDEFS */
//
//////////////////////////////////////////////////////////////////////////////
#if defined(__cplusplus)

//class CAsiList;

class CAsiWinIni: public CAsiObject
// This class allows to get access to the windows initialization file
//
//
//  CAsiWinIni (const CAsiUcStr &fname)
//
//  Description
//
//   Constructs a windows initialization file object. Windows initialization
//   file name is passed to constructor. File is located on disk according 
//   to rules used to locate any AutoCAD (ASI) system file.
//   
//
//   int openCfgFile (const CAsiUcStr & section) 
//
//  This function reads data from the Windows initialization file.
//  It allows to read all entries of the specified section.
//  These function stores entry  names and corresponding value into 
//  internal selection set of entries. 
//  Entry name and value can be retrieved from it by means of getEntry 
//  member function.
//
//  Parameters
//
//    section   section name containing an entry
//
//  Return Value
//
//    Number of entried read. 0 if there are no enties.
//
//   EAsiBoolean readCfgString (const CAsiUcStr & section, 
//                              const CAsiUcStr & entry,
//			        CAsiUcStr * )
// 
//  This function reads data from the Windows initialization file.
//  It allows to read value of specified entry. These function stores entry
//  names and corresponding value into internal selection set of entries. 
//
//
//  Parameters
//
//    section   section name containing an entry
//
//    entry     name of entry whose associated string is to be retrieved.
//
//  Return Value
//
//    kAsiTrue if succeded and kAsiFalse otherwise
//
//
//   EAsiBoolean getEntry (int item, 
//                         CAsiUcStr *entry, 
//                         CAsiUcStr *value)
//
//   This functions retieves entry name and its value from the entries 
//   selection set
//
//
//   EAsiBoolean writeCfgString (const CAsiUcStr &section, 
//                               const CAsiUcStr &entry,
//                               const CAsiUcStr &value)
//
//   Description
//
//  This function copies a string into the specified entry of the  
//  Windows Initialization File. 
//  If Windows Initialization file doesn't exist, it is created in the 
//  current directory. If specified section doesn't exist, it is created. 
//  If specified entry doesn't exist in specified section, it is created. 
//  If the value string is void (length of data equal to 0), the specified 
//  entry is deleted.  If the last entry in section was deleted, then container
//  section is also deleted.
//
//
//   Parameters
//
//    section  section name to which the string is to be copied.
// 
//    entry    entry name which have to be modified.
//
//    str      Value to be associated with the entry in file.
//
//
//  Return Value
//
//    kAsiTrue if succeded and kAsiFalse otherwise
//
//
//
{
public:
    // Constrcution/Destrcution
    //
             CAsiWinIni (const CAsiUcStr &cfgname);
             CAsiWinIni (const char *);
    virtual ~CAsiWinIni (void);

    // Read/Write configuration file entry
    //
virtual       int           openCfgFile (const CAsiUcStr &);
virtual       int           openCfgFile (const char *);

virtual       EAsiBoolean readCfgString (const CAsiUcStr &,
                                         const CAsiUcStr &,
                                         CAsiUcStr * ); 
virtual       EAsiBoolean readCfgString (const char *,
                                         const char *,
                                         CAsiUcStr * ); 


virtual       EAsiBoolean getEntry      (int, 
                                        CAsiUcStr *, 
                                        CAsiUcStr *);


virtual      EAsiBoolean writeCfgString (const CAsiUcStr &, 
                                         const CAsiUcStr &,
                                         const CAsiUcStr &);
virtual      EAsiBoolean writeCfgString (const char *, 
                                         const char *,
                                         const char *);

protected:

       CAsiUcStr        FileName;   // Config file object
       ulong            LupTimeL;   // First part of Time of least file modification
       ulong            LupTimeH;   // Second part of Time of least file modification
       CAsiObject       *Sections;  // Sections
       CAsiObject       *Strings;   // Strings of the file
       int              cursect;    // Current section in list of section

};


class CAsiConfig : public CAsiWinIni
//
// This class allows to get access to the ASI configuration file (asi.ini). 
// This class is derived from the CAsiWinIni class.
//
//
// EAsiBoolean createEnv (const CAsiUcStr &env, const CAsiUcStr &drv)
//
// This function creates environment section in the ASI.INI configuration 
// file. Created environment will be driven by the specified DBMS driver, which
// description shall be present in the configuration file. 
//
//  Return value
//
//  kAsiFalse if environment can't be created. kAsiTrue after successful 
//  complition.
//
//
//  EAsiBoolean dropEnv   (const CAsiUcStr &env)
//
// This function drops environment section from the asi.ini file. 
//
// If environment cannot be droped, kAsiFalse is returned.
//
//
{
public:
    // Constrcution/Destrcution
    //

             CAsiConfig (void);
    virtual ~CAsiConfig (void);

    // Read/Write asi.ini configuration file entry
    //
virtual       int           openCfgFile (const CAsiUcStr &);
virtual       int           openCfgFile (const char *);

virtual       EAsiBoolean readCfgString (const CAsiUcStr &,
                                        const CAsiUcStr &,
                                        CAsiUcStr * ); 
virtual       EAsiBoolean readCfgString (const char *,
                                         const char *,
                                         CAsiUcStr * ); 

virtual       EAsiBoolean getEntry      (int, 
                                        CAsiUcStr *, 
                                        CAsiUcStr *);

virtual      EAsiBoolean writeCfgString (const CAsiUcStr &, 
                                         const CAsiUcStr &,
                                         const CAsiUcStr &);
virtual      EAsiBoolean writeCfgString (const char *, 
                                         const char *,
                                         const char *);


    // Create/Drop environment section
    //
             EAsiBoolean createEnv (const CAsiUcStr &env, const CAsiUcStr &drv);
             EAsiBoolean createEnv (const char *, const char *);

             EAsiBoolean dropEnv   (const CAsiUcStr &env);
             EAsiBoolean dropEnv   (const char *);

};

#endif /* __cplusplus */

#endif /* ASI_ASICONF_HH */
/*EOF*/

