/*****************************************************************************
    Name: asi.h                                       ast_asi_inc_appl_asi_h

    Description:  Header file for AutoCAD SQL Interface.
                  "C" call interface

    Author: Grisha Starchenko
            Autodesk, Inc.
            Moscow, Russia.

      (C) Copyright 1991-93 by Autodesk, Inc.
   ***************************************************************************
      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1993 by Autodesk, Inc."
   ***************************************************************************

      THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
      WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
      PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.

   ***************************************************************************
                           RESTRICTED RIGHTS LEGEND

      Use, duplication, or disclosure by the U.S. Government is subject
      to restrictions set forth in FAR 52.227-19 (Commerical Computer
      Software - Restricted Rights) and DFAR 252.227-7013 (c) (1) (ii)
      (Rights in Technical Data and Computer Software), as applicable.
   ***************************************************************************


    Entry Points:

    Modification History:
       27 Sep 1993  - grisha -  original written

    Bugs and restriction on use:

    Notes:

*****************************************************************************/
#ifndef ASI_ASI_H
#define ASI_ASI_H asih

#if defined(__cplusplus)
extern "C" {
#endif  /* __cplusplus */

/***************************************************************************/
/* INCLUDES */
/***************************************************************************/

/***************************************************************************/
/* TYPEDEFS */
/***************************************************************************/
typedef unsigned char  uchar;         // Unsigned char
typedef unsigned short ushort;        // Unsigned short
typedef unsigned int   uint;          // Unsigned int
typedef unsigned long  ulong;         // Unsigned long
typedef double         real;          // Real 
typedef long           integer;       // Integer 
typedef short          smallint;      // Small integer


// Interval data

typedef struct asi_year {
   long        sign;       // kAsiTrue if negative
   ulong       years;      // Years
} ASI_IYEAR;

typedef struct asi_yeartomonth {
   long        sign;       // kAsiTrue if negative
   ulong       years;      // Years
   ulong       months;     // Months (0-11)
} ASI_IYEARTOMONTH;

typedef struct asi_month {
   long        sign;       // kAsiTrue if negative
   ulong       months;     // Months
} ASI_IMONTH;

typedef struct asi_day  {
   long        sign;       // kAsiTrue if negative
   ulong       days;       // Days
} ASI_IDAY;

typedef struct asi_daytohour  {
   long        sign;       // kAsiTrue if negative
   ulong       days;       // Days 
   ulong       hours;      // Hours (0-23)     
} ASI_IDAYTOHOUR;

typedef struct asi_daytominute {
   long        sign;       // kAsiTrue if negative
   ulong       days;       // Days 
   ulong       hours;      // Hours (0-23)    
   ulong       minutes;    // Minutes (0-59)  
} ASI_IDAYTOMINUTE;

typedef struct asi_daytosecond {
   double      seconds;    // Seconds (0-59.99..9)  
   long        sign;       // kAsiTrue if negative
   ulong       days;       // Days 
   ulong       hours;      // Hours (0-23)    
   ulong       minutes;    // Minutes (0-59)  
} ASI_IDAYTOSECOND;

typedef struct asi_hour {
   long        sign;       // kAsiTrue if negative
   ulong       hours;      // Hours
} ASI_IHOUR;

typedef struct asi_hourtominute {
   long        sign;       // kAsiTrue if negative
   ulong       hours;      // Hours
   ulong       minutes;    // Minutes (0-59)  
} ASI_IHOURTOMINUTE;

typedef struct asi_hourtosecond {
   double      seconds;    // Seconds (0-59.99..9)  
   long        sign;       // kAsiTrue if negative
   ulong       hours;      // Hours
   ulong       minutes;    // Minutes (0-59)  
} ASI_IHOURTOSECOND;

typedef struct asi_minute {
   long        sign;       // kAsiTrue if negative
   ulong       minutes;    // Minutes 
} ASI_IMINUTE;

typedef struct asi_minuteitosecond {
   double      seconds;    // Seconds (0-59.99..9)  
   long        sign;       // kAsiTrue if negative
   ulong       minutes;    // Minutes 
} ASI_IMINUTETOSECOND;

typedef struct asi_second {
   double      seconds;    // Seconds 
   long        sign;       // kAsiTrue if negative
} ASI_ISECOND;

// Datetime data
//
typedef struct asi_date {  // Date
  ushort year;             // Year
  ushort month;            // Month (0-11)
  ushort day;              // Day (0-31)
  short  pad;              // pad short
} ASI_DTDATE;

typedef struct asi_time {     // Time with time zone
  double            second;   // Second (0-59.99..9)  
  ASI_IHOURTOMINUTE timezone; // time zone
  ushort            hour;     // Hour (0-23)
  ushort            minute;   // Minute (0-59)
} ASI_DTTIME;

typedef struct asi_timestamp {  // Timestamp with time zone
  ASI_DTTIME   time;        // Time
  ASI_DTDATE   date;        // Date
} ASI_DTTIMESTAMP; 

                             
typedef ulong ASIHANDLE;               /* Generic ASI handle */
typedef ulong ASIENV;                  /* Asi Environment handle */
typedef ulong ASISESSION;              /* Session handle */
typedef ulong ASISTATEMENT;            /* Statement handle */
typedef ulong ASICURSOR;               /* Cursor */
typedef ulong ASIPARDSC;               /* Input parameter handle */
typedef ulong ASICOLDSC;               /* Column descriptor handle */
typedef ulong ASIIDENT;                /* Identifier */
typedef ulong ASIDATADSC;              /* Data descriptor */
typedef ulong ASICONFIG;               /* Configuration file descriptor */

// Cast sesison, statement, or cursor to generic handle
#define ASI_CASTTODIAG(x)     ((ASIHANDLE)(x))

/* Cursor status */
#define ASI_CUPDATABLE     0x00000001      /* updatable cursor */
#define ASI_CINSENSITIVE   0x00000002      /* insensitive cursor */
#define ASI_CSCROLL        0x00000004      /* scrollable cursor */
#define ASI_COPEN          0x00000008      /* open cursor */



/***************************************************************************/
/* FUNCTION PROTOTYPES */
/***************************************************************************/

/* identifier management functions */
EAsiBoolean    asi_constr_ident       (ASIIDENT *);              /* Construct Identifier */
EAsiBoolean    asi_destroy_ident      (ASIIDENT *);              /* Destroy Identifier object */
EAsiBoolean    asi_dupl_ident         (ASIIDENT, ASIIDENT *);    /* Duplicate identifier */
EAsiBoolean    asi_init_regular_ident (ASIIDENT, char *);        /* Initialize regular identifier */
EAsiBoolean    asi_init_delimit_ident (ASIIDENT, char *);        /* Initialize delimited identifier */
char *         asi_get_ident          (ASIIDENT, char *, int); /* Get identifier body */

/* Data descriptor */
EAsiBoolean      asi_destroy_ddsc       (ASIDATADSC *);
EAsiDataType     asi_ddsc_type          (ASIDATADSC);             /* type */
EAsiDTType       asi_ddsc_datetimetype  (ASIDATADSC);             /* datetime type */
EAsiIType        asi_ddsc_intervaltype  (ASIDATADSC);             /* interval type */
uint             asi_ddsc_precision     (ASIDATADSC);             /* Precison */
uint             asi_ddsc_scale         (ASIDATADSC);             /* Scale */
uint             asi_ddsc_length        (ASIDATADSC);             /* Length */
uint             asi_ddsc_timeprec      (ASIDATADSC);             /* Time precision */
uint             asi_ddsc_lfp           (ASIDATADSC);             /* Interval leading field precision */
uint             asi_ddsc_fsp           (ASIDATADSC);             /* Interval fractional second precison */
uint             asi_ddsc_ret_length    (ASIDATADSC);             /* Return length */
char *           asi_ddsc_sqltype       (ASIDATADSC, char *, int); /* Return SQL type as a string */

/* Input parmaeter manipulation */
EAsiBoolean      asi_pdsc_name          (ASIPARDSC, ASIIDENT *);   /* Parameter name */
EAsiBoolean      asi_pdsc_ddsc          (ASIPARDSC, ASIDATADSC *); /* Parameter data descriptor */
EAsiBoolean      asi_pdsc_nullable      (ASIPARDSC);               /* Is nullable */

/* Column descriptor */
EAsiBoolean      asi_cdsc_name          (ASICOLDSC, ASIIDENT *);   /* Parameter name */
EAsiBoolean      asi_cdsc_ddsc          (ASICOLDSC, ASIDATADSC *); /* Parameter data descriptor */
EAsiBoolean      asi_cdsc_nullable      (ASICOLDSC);               /* Is nullable */


/* ASI initialization and termination functions */
EAsiBoolean    asi_initasi         (ASIENV *);
EAsiBoolean    asi_termasi         (ASIENV *);
EAsiBoolean    asi_abortasi        (ASIENV *);

/* ASI connection management functions */
EAsiBoolean    asi_constr_session  (ASISESSION *, ASIENV);
EAsiBoolean    asi_destroy_session (ASISESSION *, ASIENV);
EAsiBoolean    asi_connect         (ASISESSION, char *, char *, char *);
EAsiBoolean    asi_disconnect      (ASISESSION);
EAsiBoolean    asi_disconnectall   (ASIENV);

/* Driver information */
EAsiBoolean    asi_version       (ASIENV, char *, int);
EAsiBoolean    asi_dbms          (ASIHANDLE, char *, int);
EAsiBoolean    asi_sqlobject     (ASIHANDLE, char *, int);
EAsiBoolean    asi_message       (ASIHANDLE, char *, int);
EAsiBoolean    asi_checkop       (ASIHANDLE, ulong);

/* ASI session management functions */
EAsiBoolean    asi_setcatalog      (ASISESSION, char *);
EAsiBoolean    asi_setschema       (ASISESSION, char *);
EAsiBoolean    asi_setnames        (ASISESSION, char *);
EAsiBoolean    asi_settimezone     (ASISESSION, ASI_IHOURTOMINUTE *);
EAsiBoolean    asi_setauthor       (ASISESSION, char *);
EAsiBoolean    asi_settrans        (ASISESSION, EAsiTILevel, EAsiTMode, uint);
EAsiBoolean    asi_setdefconstr    (ASISESSION, ASIIDENT);
EAsiBoolean    asi_setimmconstr    (ASISESSION, ASIIDENT);
EAsiBoolean    asi_commit          (ASISESSION);
EAsiBoolean    asi_rollback        (ASISESSION);
EAsiBoolean    asi_cancel          (ASISESSION);

/* ASI diagnostics functions */
EAsiStatement  asi_opr           (ASIHANDLE);
EAsiStatement  asi_stm           (ASIHANDLE);
long           asi_rowqty        (ASIHANDLE);
EAsiBoolean    asi_getcuropt     (ASICURSOR, ulong *);
int            asi_synerrpos     (ASIHANDLE);
int            asi_condqty       (ASIHANDLE);
EAsiError      asi_err           (ASIHANDLE, int);
char *         asi_errmsg        (ASIHANDLE, char *, int, int);
char*          asi_sqlstate      (ASIHANDLE, int);
EAsiBoolean    asi_getdiagpar    (ASIHANDLE, EAsiDiag, void *, int, int); 

/* Statement descriptors */ 
int            asi_parcount      (ASIHANDLE);
EAsiBoolean    asi_pds           (ASIHANDLE, int, ASIPARDSC *);
EAsiBoolean    asi_bndname       (ASIHANDLE, ASIIDENT, void*, short*, int, EAsiHostType);
EAsiBoolean    asi_bndnum        (ASIHANDLE, int, void*, short*, int, EAsiHostType);
int            asi_colcount      (ASIHANDLE);
EAsiBoolean    asi_cds           (ASIHANDLE, int, ASICOLDSC *);
EAsiBoolean    asi_sob           (ASIHANDLE, int, void*, short*, int, EAsiHostType);
EAsiBoolean    asi_cvl           (ASIHANDLE, int, void*, short*, int, EAsiHostType);


/* Statement processing functions */
EAsiBoolean    asi_constr_stm      (ASISTATEMENT *);
EAsiBoolean    asi_constr_native_stm (ASISTATEMENT *);
EAsiBoolean    asi_destroy_stm     (ASISTATEMENT *);
EAsiBoolean    asi_prepare         (ASISTATEMENT, ASISESSION, char *);
EAsiBoolean    asi_execute         (ASISTATEMENT);
EAsiBoolean    asi_iexecute        (ASISTATEMENT, ASISESSION, char *);
EAsiBoolean    asi_dealloc_stm     (ASISTATEMENT);


/* Cursor Manipulation Functions */
EAsiBoolean    asi_constr_csr      (ASICURSOR *);
EAsiBoolean    asi_destroy_csr     (ASICURSOR *);
EAsiBoolean    asi_alloc_csr       (ASICURSOR, ASISTATEMENT, char *, 
                                    EAsiCurScr, EAsiCurSns);
EAsiBoolean    asi_open            (ASICURSOR);
EAsiBoolean    asi_close           (ASICURSOR);
EAsiBoolean    asi_fetch           (ASICURSOR);
EAsiBoolean    asi_fetchPrior      (ASICURSOR);
EAsiBoolean    asi_fetchFirst      (ASICURSOR);
EAsiBoolean    asi_fetchLast       (ASICURSOR);
EAsiBoolean    asi_fetchAbsolute   (ASICURSOR, long);
EAsiBoolean    asi_fetchRelative   (ASICURSOR, long);
EAsiBoolean    asi_delete          (ASICURSOR);
EAsiBoolean    asi_update          (ASICURSOR, ...);


/* Asi configuration access */
EAsiBoolean asi_constr_cfg   (ASICONFIG *);
EAsiBoolean asi_destroy_cfg  (ASICONFIG *);
int         asi_getcfgstring (ASICONFIG, char *, char *, char *, char *, int);
EAsiBoolean asi_setcfgstring (ASICONFIG, char *, char *, char *);
EAsiBoolean asi_createenv    (ASICONFIG, char *, char *);
EAsiBoolean asi_dropenv      (ASICONFIG, char *);
#if defined(__cplusplus)
}
#endif  /* __cplusplus */

#endif /* ASI_ASI_H */
/*EOF*/
