; Next available MSG number is    93
; MODULE_ID TUTORIAL_LSP_
;;;----------------------------------------------------------------------------
;;;   tutorial.lsp - LISP utilities for Learning AutoCAD Tutorials
;;;
;;;   (C) Copyright 1991-1994 by Autodesk, Inc.
;;;      
;;;   Permission to use, copy, modify, and distribute this software 
;;;   for any purpose and without fee is hereby granted, provided 
;;;   that the above copyright notice appears in all copies and that 
;;;   both that copyright notice and this permission notice appear in 
;;;   all supporting documentation.
;;;      
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;=========================================================================


;;;------------------------------------------------------------------------

(if (not tut_spd)(setq tut_spd 100))

(defun c:tutdemo ( / xxx )
  (ac:erron 
    (list 
      ;|Msg0|;"coords" "snapmode" "blipmode" "limcheck" "globcheck"
      ;|Msg0|;"cmdecho" "orthomode" "lunits" "pickbox"
      ;|Msg0|;"dimasz" "dimexe" "dimexo" "dimtxt" "dimtfac"
    )
  )
  (setvar ;|Msg0|;"globcheck" 0)
  (setvar ;|Msg0|;"cmdecho" 0)
  (initget ;|Msg0|;"01 02 03 04 05 06 07 08 09 10")
  (setq xxx (getkword ;|TUTORIAL_LSP_1|;"\nExercise to run: "))
  (if (and xxx (tutundo 1))
    (progn
      (setq chk nil)
      (setq nnn (strlen (getvar ;|Msg0|;"dwgprefix")))
      (setq nam (strcase (substr (getvar ;|Msg0|;"dwgname") (1+ nnn))))
      (if (tblsearch ;|Msg0|;"block" (strcat ;|Msg0|;"tut" xxx ;|Msg0|;"_do_not_delete_this_block"))
        (if (= nam (strcat ;|Msg0|;"EX" xxx))
          (alert ;|TUTORIAL_LSP_2|;"You must save this drawing\nas another name to use Demo.")
          (progn
            (repeat 3 (princ (nth 0 tut_strs)) )
            (eval (read (strcat ;|Msg0|;"(tut" xxx ;|Msg0|;")" )))
            (alert
              (strcat
                ;|TUTORIAL_LSP_3|;"Demo complete. \n \n"
                ;|TUTORIAL_LSP_4|;"Use the Clear button to return the drawing\n"
                ;|TUTORIAL_LSP_5|;"to its original state. Any changes made to\n"
                ;|TUTORIAL_LSP_6|;"the drawing after this point and before\n"
                ;|TUTORIAL_LSP_7|;"choosing Clear will be lost."
              )
            )
          )
        )
        (progn
          (tutundo 0)
          (alert
            (strcat 
              ;|TUTORIAL_LSP_8|;"You must open the tutorial drawing\n" 
              ;|Msg0|;"EX" xxx 
              ;|TUTORIAL_LSP_9|;", then save it as another name\nto use the Demo feature."
            )
          )
        )
      )
    )
    (alert 
      (strcat 
        ;|TUTORIAL_LSP_10|;"You must choose the Clear\n"
        ;|TUTORIAL_LSP_11|;"button before running the\n"
        ;|TUTORIAL_LSP_12|;"demo again."
      )
    )
  )
  (ac:erroff)
  (princ)
)


(defun c:tutclear ( / )
  (if (tutundo 0)
    (repeat 3 (princ (nth 0 tut_strs)) )
    (alert ;|TUTORIAL_LSP_13|;"\nNothing to clear.")
  )
  (princ)
)

(defun c:tutspd ( / xxx )
  (setq xxx tut_spd)
  (setq xxx (getint (strcat ;|TUTORIAL_LSP_14|;"\nHow fast? (smaller is faster) <" (itoa xxx) ">: ")))
  (if xxx (setq tut_spd xxx))
  (princ)
)

;;;=== Keywords =============================================================
;;;
;;; First string in list is the internal keyword, the second string is the
;;; one that is displayed and passed to AutoCAD as the keyword.

(setq tut_kwds
  (list
    '(;|Msg0|;"tan" ;|TUTORIAL_LSP_15|;"tan")
    '(;|Msg0|;"mid" ;|TUTORIAL_LSP_16|;"mid")
    '(;|Msg0|;"cen" ;|TUTORIAL_LSP_17|;"cen")
    '(;|Msg0|;"per" ;|TUTORIAL_LSP_18|;"per")
    '(;|Msg0|;"endp" ;|TUTORIAL_LSP_19|;"endp")
    '(;|Msg0|;"int" ;|TUTORIAL_LSP_20|;"int")
    '(;|Msg0|;"from" ;|TUTORIAL_LSP_85|;"from")
    '(;|Msg0|;"nea" ;|TUTORIAL_LSP_86|;"nea")
    '(;|Msg0|;"all" ;|TUTORIAL_LSP_21|;"all")         ; ZOOM
    '(;|Msg0|;"attach" ;|TUTORIAL_LSP_54|;"a")        ; XREF Attach
    '(;|Msg0|;"ca" ;|TUTORIAL_LSP_87|;"ca")           ; -MLEDIT CA (CutAll)
    '(;|Msg0|;"crossing" ;|TUTORIAL_LSP_22|;"c")      ; STRETCH
    '(;|Msg0|;"center" ;|TUTORIAL_LSP_23|;"ce")	      ; ARC Center
    '(;|Msg0|;"close" ;|TUTORIAL_LSP_24|;"cl")        ; MLINE, PLINE Close
    '(;|Msg0|;"color" ;|TUTORIAL_LSP_25|;"col")       ; LAYER Color
    '(;|Msg0|;"distances" ;|TUTORIAL_LSP_26|;"d")     ; CHAMFER Distance
    '(;|Msg0|;"freeze" ;|TUTORIAL_LSP_27|;"f")        ; VPLAYER Freeze
    '(;|Msg0|;"height" ;|TUTORIAL_LSP_28|;"h")        ; -MTEXT Height
    '(;|Msg0|;"inscribed" ;|TUTORIAL_LSP_29|;"i")     ; POLYGON Inscribed
    '(;|Msg0|;"invisible" ;|TUTORIAL_LSP_30|;"inv")   ; ATTDEF Invisible
    '(;|Msg0|;"last" ;|TUTORIAL_LSP_31|;"L")          ; MIRROR, ARRAY (Last selection)
    '(;|Msg0|;"layer" ;|TUTORIAL_LSP_32|;"la")        ; CHPROP LAyer
    '(;|Msg0|;"new" ;|TUTORIAL_LSP_84|;"new")         ; LAYER New
    '(;|Msg0|;"off" ;|TUTORIAL_LSP_33|;"off")         ; SNAP Off
    '(;|Msg0|;"on" ;|TUTORIAL_LSP_34|;"on")           ; SNAP, ORTHO On
    '(;|Msg0|;"previous" ;|TUTORIAL_LSP_35|;"p")      ; ZOOM Previous
    '(;|Msg0|;"properties" ;|TUTORIAL_LSP_36|;"prop") ; -BHATCH Properties
    '(;|Msg0|;"polar" ;|TUTORIAL_LSP_37|;"polar")     ; ARRAY Polar
    '(;|Msg0|;"radius" ;|TUTORIAL_LSP_38|;"r")        ; FILLET Radius
    '(;|Msg0|;"set" ;|TUTORIAL_LSP_39|;"set")         ; LAYER Set
    '(;|Msg0|;"scale" ;|TUTORIAL_LSP_40|;"scale")     ; MLINE Scale
    '(;|Msg0|;"window" ;|TUTORIAL_LSP_41|;"w")        ; BLOCK, MIRROR, ZOOM (Window selection)
    '(;|Msg0|;"vpvisdflt" ;|TUTORIAL_LSP_53|;"v")     ; VPLAYER Vpvisdflt
  )
)

;;;=== Misc. strings ========================================================

(setq tut_strs
  (list
    ;|TUTORIAL_LSP_42|;"\nCommand: "                      ; 0
    ;|TUTORIAL_LSP_43|;"\nFirst corner: "                 ; 1
    ;|TUTORIAL_LSP_44|;"\nOther corner: "                 ; 2
    ;|TUTORIAL_LSP_45|;"RECTANG"                          ; 3
    ;|TUTORIAL_LSP_83|;"No demo available for exercise"   ; 4
  )
)

;;;=== Exercises ============================================================
;;;
;;;
;;;--- EXERCISE 01 -----------------------------------------------------------

(defun tut01 ()
  (setvar "blipmode" 1)
  (setvar "limcheck" 0)
  (command "_zoom" "_w" "0,0" "12,9")
  (slo_cmd "circle")
  (slo_typ "3,4")
  (slo_typ "2")
  (slo_cmd "circle")
  (slo_typ "7.5,4")
  (slo_typ "1.2")
  (slo_cmd "offset")
  (slo_typ "1")
  (slo_pik '(5 4))
  (slo_xxx '(4.5 4))
  (slo_typ "")
  (slo_cmd "offset")
  (slo_typ "0.6")
  (slo_pik '(6.3 4))
  (slo_xxx '(7 4))
  (slo_typ "")
  (slo_cmd "line")
  (slo_kwd "tan")
  (slo_xxx '(3 2))
  (slo_kwd "tan")
  (slo_xxx '(7.5 2.8))
  (slo_typ "")
  (slo_cmd "mirror")
  (slo_kwd "last")
  (slo_typ "")
  (slo_kwd "cen")
  (slo_xxx '(3 6))
  (slo_kwd "cen")
  (slo_xxx '(7.5 5.2))
  (slo_typ "")
  (slo_cmd "trim")
  (slo_pik '(5.7989 2.4773))
  (slo_pik '(5.5756 5.5671))
  (slo_typ "")
  (slo_xxx '(6.3 4))
  (slo_typ "")
  (slo_cmd "redraw")
)

;;;--- EXERCISE 02 ----------------------------------------

(defun tut02 ()
  (setvar "blipmode" 1)
  (setvar "lunits" 4)
  (setvar "pickbox" 4)
  (command "_zoom" "_w" "0,0" "12',15'")
  (slo_cmd "layer")
  (slo_kwd "new")
  (slo_typ "WALLS") 
  (slo_kwd "color")
  (slo_typ "5")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "mline")
  (slo_kwd "scale")
  (slo_typ "6")
  (slo_typ "36,12")
  (slo_typ "@96,0")
  (slo_typ "@0,132")
  (slo_typ "@-120,0")
  (slo_typ "@0,-96")
  (slo_kwd "close")
  (slo_cmd "line")
  (slo_kwd "from")
  (slo_kwd "endp")
  (slo_xxx '(132 12))
  (slo_typ "@-6,0")
  (slo_typ "@0,36")
  (slo_typ "")
  (slo_cmd "arc")
  (slo_kwd "center")
  (slo_kwd "endp")
  (slo_xxx '(126 12))
  (slo_kwd "endp")
  (slo_xxx '(126 48))
  (slo_kwd "nea")
  (slo_xxx '(90 12))
  (slo_cmd "-mledit")
  (slo_kwd "ca")
  (slo_kwd "endp")
  (slo_xxx '(90 12))
  (slo_kwd "endp")
  (slo_xxx '(126 12))
  (slo_typ "")
  (slo_cmd "line")
  (slo_kwd "endp")
  (slo_xxx '(90 12))
  (slo_kwd "endp")
  (slo_xxx '(90 6))
  (slo_typ "")
  (slo_cmd "line")
  (slo_kwd "endp")
  (slo_xxx '(126 12))
  (slo_kwd "endp")
  (slo_xxx '(126.5 6))
  (slo_typ "") 
  (slo_cmd "redraw")  
)


;;;--- EXERCISE 03 -----------------------------------------------------------

(defun tut03 ()
  (setvar "blipmode" 1)
  (setvar "limcheck" 0)
  (command "_zoom" "_w" "0,0" "7,5")
  (command "_layer" "_s" "0" "")
  (slo_cmd "line")
  (slo_typ "3,4")
  (slo_typ "@0,-3")
  (slo_typ "@-0.75,0")
  (slo_typ "@0,0.75")
  (slo_typ "@-0.75,0")
  (slo_typ "@0,1.5")
  (slo_typ "")
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_55|;"CENTER")
  (slo_typ "")
  (slo_cmd "line")
  (slo_kwd "mid")
  (slo_xxx '(1.5 2.6))
  (slo_kwd "per")
  (slo_xxx '(3 2.6))
  (slo_typ "")
  (slo_cmd "line")
  (slo_kwd "mid")
  (slo_xxx '(2.26 1.5))
  (slo_kwd "per")
  (slo_xxx '(3 1.5))
  (slo_typ "")
  (slo_cmd "offset")
  (slo_typ "0.125")
  (slo_xxx '(2.64 1.37))
  (slo_xxx '(2.64 1.2))
  (slo_xxx '(2.64 1.37))
  (slo_xxx '(2.64 1.5))
  (slo_typ "")
  (slo_cmd "offset")
  (slo_typ "0.37")
  (slo_xxx '(2.27 2.5))
  (slo_xxx '(2.27 2.3))
  (slo_typ "")
  (slo_cmd "chprop")
  (slo_pik '(2.63 1.25))
  (slo_pik '(2.63 1.5))
  (slo_pik '(2.27 2.13))
  (slo_typ "")
  (slo_kwd "layer")
  (slo_typ ;|TUTORIAL_LSP_56|;"EDGE")
  (slo_typ "")
  (slo_cmd "offset")
  (slo_typ "0.33")
  (slo_xxx '(3 2.32))
  (slo_xxx '(3.2 2.32))
  (slo_xxx '(1.5 2.3))
  (slo_xxx '(1.4 2.3))
  (slo_xxx '(2.26 1.6))
  (slo_xxx '(2.1 1.6))
  (slo_typ "")
  (slo_cmd "extend")
  (slo_pik '(3.33 2.45))
  (slo_pik '(1.17 2.45))
  (slo_pik '(1.92 1.38))
  (slo_typ "")
  (slo_xxx '(1.69 2.5))
  (slo_xxx '(2.86 2.5))
  (slo_xxx '(2.39 1.37))
  (slo_xxx '(2.88 1.37))
  (slo_typ "")
  (slo_cmd "erase")
  (slo_pik '(3.33 2.9))
  (slo_pik '(1.17 2.9))
  (slo_pik '(1.92 1.5)) 
  (slo_typ "")
  (slo_cmd "ortho")
  (slo_kwd "on")
  (slo_cmd "mirror")
  (slo_kwd "window")
  (slo_xxx '(1.2 2.2))
  (slo_xxx '(3.5 0.7))
  (slo_typ "")
  (slo_kwd "endp")
  (slo_xxx '(1.17 2.5))
  (slo_kwd "endp")
  (slo_xxx '(3.33 2.5))
  (slo_typ "")
  (redraw)
  (slo_cmd "fillet")
  (slo_kwd "radius")
  (slo_typ "0.17")
  (slo_cmd "fillet")
  (slo_xxx '(2.41 3.99))
  (slo_xxx '(2.26 3.86))
  (slo_cmd "fillet")
  (slo_xxx '(1.68 3.25))
  (slo_xxx '(1.5 3.11))
  (slo_cmd "fillet")
  (slo_xxx '(1.69 1.74))
  (slo_xxx '(1.5 1.90))
  (slo_cmd "fillet")
  (slo_xxx '(2.41 1))
  (slo_xxx '(2.26 1.14))
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_57|;"HATCH")
  (slo_typ "")
  (slo_cmd "-bhatch")  
  (slo_kwd "properties")
  (slo_typ "ANSI31")
  (slo_typ "1")
  (slo_typ "0")
  (slo_xxx '(2.6 3.9))
  (slo_xxx '(2.6 3.1))
  (slo_xxx '(2.6 1.9))
  (slo_xxx '(2.6 1.1))
  (slo_typ "")
  (slo_cmd "redraw")
)

;;;--- EXERCISE 04 -----------------------------------------------------------

(defun tut04 ()
  (setvar "blipmode" 1)
  (command "_zoom" "_w" "0,-0.25" "2,2.5")
  (command "_layer" "_s" "0" "")
  (slo_cmd "pline")
  (slo_typ "1,2")
  (slo_typ "@1<270")
  (slo_typ "@1<0")
  (slo_typ "@1<270")
  (slo_typ "@.35<0")
  (slo_typ "@1.1<90")
  (slo_typ "@0.1<180")
  (slo_typ "@0.2<90")
  (slo_typ "@0.5<180")
  (slo_typ "@0.7<90")
  (slo_kwd "close")
  (slo_cmd "fillet")
  (slo_kwd "radius")
  (slo_typ "0.125")
  (slo_cmd "fillet")
  (slo_xxx '(2 0.16))
  (slo_xxx '(2.13 0))
  (slo_cmd "chamfer")
  (slo_kwd "distances")
  (slo_typ "0.125")
  (slo_typ "")
  (slo_cmd "chamfer")
  (slo_xxx '(2.35 0.296))
  (slo_xxx '(2.2 0))
  (slo_cmd "revolve")
  (slo_pik '(1.54 1))
  (slo_typ "")
  (slo_typ "1,2.5")
  (slo_typ "2,2.5")
  (slo_typ "225")
  (slo_cmd "vpoint")
  (slo_typ "3,-3,1")
  (slo_cmd "hide")
)

;;;--- LESSON05 -----------------------------------------------------------

(defun tut05 ()
  (setvar "blipmode" 1)
  (setvar "pickbox" 1)
  (command "_zoom" "_w" "-0.5,0" "6,5.25")
  (slo_cmd "osnap")
  (slo_kwd "int")
  (slo_cmd "dimlinear")
  (slo_xxx '(3 2.5))
  (slo_xxx '(3 1.38))
  (slo_xxx '(3.6 2))
  (slo_cmd "dimcontinue")
  (slo_xxx '(3 1))
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "osnap")
  (slo_kwd "endp")
  (slo_cmd "dimlinear")
  (slo_xxx '(3 4))
  (slo_xxx '(2.26 3.83))
  (slo_xxx '(3 4.5))
  (slo_cmd "dimbaseline")
  (slo_xxx '(1.52 3.09))
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "dimlinear")
  (slo_xxx '(2.43 4))
  (slo_xxx '(1.69 3.26))
  (slo_xxx '(0.45 3.6))
  (slo_cmd "dimcontinue")
  (slo_xxx '(1.69 1.74))
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "dimlinear")
  (slo_xxx '(1.52 2.87))
  (slo_xxx '(1.52 2.13))
  (slo_xxx '(1 2.5))
  (slo_cmd "dimradius")
  (slo_xxx '(2.2982 1.0572))
  (slo_xxx '(1.76 0.6))
)

;;;--- EXERCISE 06 -----------------------------------------------------------

(defun tut06 ()
  (setvar "blipmode" 1)
  (setvar "lunits" 2)
  (command "_zoom" "_w" "-3.35,-5.20" "10,8")
  (command "_layer" "_s" ;|TUTORIAL_LSP_58|;"TEXT" "")
  (slo_cmd "style")
  (slo_typ ;|TUTORIAL_LSP_59|;"NOTES")
  (slo_typ "simplex")
  (slo_typ "0")
  (slo_typ "1")
  (slo_typ "0")
  (slo_typ "")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "-mtext")
  (slo_kwd "height")
  (slo_typ "0.25")
  (slo_typ "-2,0")
  (slo_typ "5,-5")
  (slo_typ ;|TUTORIAL_LSP_46|;"{\\C6;NOTE:}")
  (slo_typ ;|TUTORIAL_LSP_47|;"EXTEND CURB TO BOTTOM OF BASE ROCK AT LOCATIONS WHERE PLANTERS MEET PAVEMENT. CHECK CITY CODE.")
  (slo_typ "")
  (slo_cmd "leader")
  (slo_xxx '(0.37 4.91))
  (slo_typ "@2<45")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_48|;"2CM RADIUS")
  (slo_typ "")
  (slo_cmd "leader")
  (slo_xxx '(0.25 3.0))
  (slo_typ "@2<45")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_49|;"CONCRETE")
  (slo_typ "")
  (slo_cmd "leader")
  (slo_xxx '(2.14 2.60))
  (slo_typ "@1<45")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_50|;"A.C.")
  (slo_typ "")
  (slo_cmd "leader")
  (slo_xxx '(2.39 1.19))
  (slo_typ "@1<-45")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_51|;"AGGREGATE BASE")
  (slo_typ "")
  (slo_cmd "text")
  (slo_typ "-0.5,-3")
  (slo_typ "0.4")
  (slo_typ "0")
  (slo_typ ;|TUTORIAL_LSP_52|;"CURB DETAIL")
  (slo_cmd "redraw")
)

;;;--- EXERCISE 07 -----------------------------------------------------------

(defun tut07 ()
  (setvar "blipmode" 1)
  (setvar "lunits" 4)
  (command "_zoom" "_w" "0,0" "198,192")
  (command "_layer" "_s" "0" "")
  (slo_cmd "line")
  (slo_typ "12,186")
  (slo_typ "1',13'")
  (slo_typ "")
  (slo_cmd "arc")
  (slo_kwd "endp")
  (slo_xxx '(12 156))
  (slo_kwd "center")
  (slo_kwd "endp")
  (slo_xxx '(12 186))
  (slo_xxx '(42 186))
  (slo_cmd "ortho")
  (slo_kwd "on")
  (slo_cmd "mirror")
  (slo_xxx '(12 170))
  (slo_xxx '(36 168))
  (slo_typ "")
  (slo_kwd "endp")
  (slo_xxx '(42 186))
  (slo_xxx '(42 156))
  (slo_typ "")
  (slo_cmd "polygon")
  (slo_typ "4")
  (slo_xxx '(42 42))
  (slo_kwd "inscribed")
  (slo_typ "12")
  (slo_cmd "snap")
  (slo_kwd "off")
  (slo_cmd "offset")
  (slo_typ "1")
  (slo_pik '(44 33.5))
  (slo_xxx '(44 42))
  (slo_typ "")
  (slo_cmd "zoom")
  (slo_xxx '(24 24))
  (slo_xxx '(60 60))
  (slo_cmd "fillet")
  (slo_kwd "radius")
  (slo_typ "2")
  (slo_cmd "fillet")
  (slo_xxx '(38.08 50.49))
  (slo_xxx '(33.51 45.53))
  (slo_cmd "fillet")
  (slo_xxx '(33.51 36.53))
  (slo_xxx '(36.65 33.51))
  (slo_cmd "fillet")
  (slo_xxx '(37.06 49.49))
  (slo_xxx '(34.51 46.65))
  (slo_cmd "fillet")
  (slo_xxx '(34.51 37.14))
  (slo_xxx '(37.16 34.51))
  (slo_cmd "zoom")
  (slo_kwd "previous")
  (slo_cmd "block")
  (slo_typ ;|TUTORIAL_LSP_60|;"CHAIR")
  (slo_kwd "mid")
  (slo_xxx '(33.51 42.26))
  (slo_kwd "window")
  (slo_xxx '(24 24))
  (slo_xxx '(60 60))
  (slo_typ "")
  (slo_cmd "snap")
  (slo_kwd "on")
  (slo_cmd "circle")
  (slo_typ "48,48")
  (slo_typ "27")
  (slo_cmd "insert")
  (slo_typ ;|TUTORIAL_LSP_60|;"CHAIR")
  (slo_typ "72,72")
  (slo_typ "")
  (slo_typ "")
  (slo_typ "45")
  (slo_cmd "array")
  (slo_kwd "last")
  (slo_typ "")
  (slo_kwd "polar")
  (slo_kwd "cen")
  (slo_xxx '(74.93 46.10))
  (slo_typ "4")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "redraw")
)

;;;--- EXERCISE 08 -----------------------------------------------------------

(defun tut08 ()
  (setvar "blipmode" 1)
  (setvar "snapmode" 1)
  (command "_zoom" "_w" "-108,-6" "480,810")
  (command "_layer" "_s" ;|TUTORIAL_LSP_61|;"FURNITURE" "")
  (slo_cmd "zoom")
  (slo_kwd "window")
  (slo_xxx '(-18 462))
  (slo_xxx '(190 270))
  (slo_princ (nth 3 tut_strs))
  (princ (nth 1 tut_strs))
  (slo_princ "114,390")
  (princ (nth 2 tut_strs))
  (slo_princ "174,360")
  (setvar "cmdecho" 0)
  (command "_.pline" "114,390" "174,390" "174,360" "114,360" "_c")
  (setvar "cmdecho" 1)
  (slo_cmd "attdef")
  (slo_kwd "invisible")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_62|;"MANUF")
  (slo_typ ;|TUTORIAL_LSP_63|;"Manufacturer")
  (slo_typ "")
  (slo_typ "114,348")
  (slo_typ "6")
  (slo_typ "0")
  (slo_cmd "attdef")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_64|;"MODEL")
  (slo_typ ;|TUTORIAL_LSP_65|;"Model")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "attdef")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_66|;"COST")
  (slo_typ ;|TUTORIAL_LSP_67|;"Cost")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "attdef")
  (slo_typ "")
  (slo_typ ;|TUTORIAL_LSP_68|;"LOCATION")
  (slo_typ ;|TUTORIAL_LSP_69|;"Location")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "block")
  (slo_typ ;|TUTORIAL_LSP_70|;"TABLE60")
  (slo_kwd "mid")
  (slo_xxx '(144 360))
  (slo_kwd "window")
  (slo_xxx '(108 394))
  (slo_xxx '(185 287))
  (slo_typ "")
  (setvar "cmdecho" 0)
  (command "_attdia")
  (command "0")
  (setvar "cmdecho" 1)
  (slo_cmd "insert")
  (slo_typ ;|TUTORIAL_LSP_70|;"TABLE60")
  (slo_typ "144,414")
  (slo_typ "")
  (slo_typ "")
  (slo_typ "0")
  (slo_typ ;|TUTORIAL_LSP_71|;"2227")               ;; Location
  (slo_typ ;|TUTORIAL_LSP_72|;"Tressle")            ;; Model
  (slo_typ ;|TUTORIAL_LSP_73|;"Sierra Furniture")   ;; Manufacturer
  (slo_typ ;|TUTORIAL_LSP_74|;"126.00")             ;; Cost
  (setvar "cmdecho" 0)
  (command "_attdia")
  (command "1")
  (setvar "cmdecho" 1)
  (slo_cmd "zoom")
  (slo_kwd "previous")
  (slo_cmd "zoom")
  (slo_kwd "window")
  (slo_xxx '(-30 264))
  (slo_xxx '(240 804))
  (slo_cmd "erase")
  (slo_xxx '(84 391.16))
  (slo_xxx '(38 390.61))
  (slo_xxx '(22.53 432.05))
  (slo_xxx '(92.57 362))
  (slo_xxx '(25.33 362))
  (slo_typ "")
  (slo_cmd "redraw")
  (slo_cmd "snap")
  (slo_kwd "off")
  (slo_cmd "rotate")
  (slo_xxx '(63.15 429.78))
  (slo_typ "")
  (slo_kwd "int")
  (slo_xxx '(41.44 422.50))
  (slo_typ "270")
  (slo_cmd "move")
  (slo_xxx '(49.14 422.5))
  (slo_typ "")
  (slo_kwd "mid")
  (slo_xxx '(30.94 414.39))
  (slo_xxx '(152.8 745 94))

;; -- DDATTE portion not implemented in this demo since it is all
;;    dialog box access.

  (slo_cmd "zoom")
  (slo_kwd "window")
  (slo_xxx '(-18 264))
  (slo_xxx '(129 466))
  (slo_cmd "area")
  (slo_xxx '(8.98 447.17))
  (slo_xxx '(105.51 447.17))
  (slo_xxx '(106 280))
  (slo_xxx '(8.87 280))
  (slo_typ "")
  (slo_cmd "redraw")
)

;;;--- EXERCISE 09 -----------------------------------------------------------

(defun tut09 ()
  (alert (strcat (nth 4 tut_strs) " 9."))
)

;;;--- EXERCISE 10 -----------------------------------------------------------

(defun tut10 ()
  (if (and (setq elev1 (tutfind "elev1.dwg"))(setq elev2 (tutfind "elev2.dwg")))
      (tut10a)
      (alert (strcat ;|TUTORIAL_LSP_88|;"Error: Unable to locate the file(s) ELEV1.DWG.\n"
                     ;|TUTORIAL_LSP_89|;"and/or ELEV2.DWG.\n\n"
                     ;|TUTORIAL_LSP_90|;"You must add the TUTORIAL directory to the\n"
                     ;|TUTORIAL_LSP_91|;"support path before the demo feature will work\n"
                     ;|TUTORIAL_LSP_92|;"for exercise 10." ))
    )
  
)
  
(defun tut10a ()
  (setvar "blipmode" 1)
  (setvar "lunits" 4)
  (command "_layer" "_s" "0" "")
  (slo_typ "TILEMODE")
  (slo_typ "0")
  (slo_cmd "limits")
  (slo_typ "0,0")
  (slo_typ "42,30")
  (slo_cmd "zoom")
  (slo_kwd "all")
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_75|;"BORDER")
  (slo_typ "")
  (slo_princ (nth 3 tut_strs))
  (princ (nth 1 tut_strs))
  (slo_princ "0,0")
  (princ (nth 2 tut_strs))
  (slo_princ "42,30")
  (setvar "cmdecho" 0)
  (command "_.pline" "0,0" "42,0" "42,30" "0,30" "_c")
  (setvar "cmdecho" 1)
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_76|;"VIEWPORT")
  (slo_typ "")
  (slo_cmd "mview")
  (slo_typ "3,12")
  (slo_typ "23,27")
  (slo_cmd "mspace")
  (setq vp_start (getvar "cvport")) ; get first viewport number
  (slo_princ (getcname "_ZOOM"))
  (slo_princ "1/96xp")
  (setvar "cmdecho" 0)
  (command "._view" "_r" "tut_v01")
  (setvar "cmdecho" 1)
  (slo_cmd "pspace")
  (slo_cmd "stretch")
  (slo_kwd "crossing")
  (slo_xxx '(26 13))
  (slo_xxx '(2 10))
  (slo_typ "")
  (slo_xxx '(26 13))
  (slo_typ "@8.5<270")
  (slo_cmd "mspace")
  (slo_cmd "zoom")
  (slo_typ "2x")
  (slo_princ (getcname "_PAN"))
  (setvar "cmdecho" 0)
  (command "._view" "_r" "tut_v02")
  (setvar "cmdecho" 1)
  (slo_cmd "pspace")
  (slo_cmd "vplayer")
  (slo_kwd "vpvisdflt")
  (slo_typ ;|TUTORIAL_LSP_77|;"Z*")
  (slo_kwd "freeze")
  (slo_typ "")
  (slo_cmd "mview")
  (slo_typ "24,17")
  (slo_typ "40,27")
  (slo_cmd "copy")
  (slo_xxx '(32.35 17))
  (slo_typ "")
  (slo_typ "@")
  (slo_typ "@11<270")
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_78|;"XREF1")
  (slo_typ "")  
  (slo_cmd "mspace")
  (slo_typ "CVPORT")
  (slo_typ (itoa (1+ vp_start)))
  (slo_cmd "xref")
  (slo_kwd "attach") 
  (slo_typ elev1)
  (slo_xxx '(320 240))
  (slo_typ "")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "setvar")
  (slo_typ "CVPORT")
  (slo_typ (itoa vp_start))
  (slo_cmd "vplayer")
  (slo_kwd "freeze")
  (slo_typ ;|TUTORIAL_LSP_78|;"XREF1")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "setvar")
  (slo_typ "CVPORT")
  (slo_typ (itoa (+ 2 vp_start)))
  (slo_cmd "vplayer")
  (slo_kwd "freeze")
  (slo_typ ;|TUTORIAL_LSP_78|;"XREF1")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_79|;"XREF2")
  (slo_typ "")  
  (slo_cmd "xref")
  (slo_kwd "attach")
  (slo_typ elev2)
  (slo_xxx '(320 240))
  (slo_typ "")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "setvar")
  (slo_typ "CVPORT")
  (slo_typ (itoa vp_start))
  (slo_cmd "vplayer")
  (slo_kwd "freeze")
  (slo_typ ;|TUTORIAL_LSP_79|;"XREF2")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "setvar")
  (slo_typ "CVPORT")
  (slo_typ (itoa (1+ vp_start)))
  (slo_cmd "vplayer")
  (slo_kwd "freeze")
  (slo_typ ;|TUTORIAL_LSP_79|;"XREF2")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "pspace")
  (slo_cmd "layer")
  (slo_kwd "set")
  (slo_typ ;|TUTORIAL_LSP_80|;"TITLE")
  (slo_typ "")  
  (slo_cmd "insert")
  (slo_typ ;|TUTORIAL_LSP_82|;"TBLOCK")
  (slo_typ "41,1")
  (slo_typ "")
  (slo_typ "")
  (slo_typ "")
  (slo_cmd "layer")
  (slo_kwd "freeze")
  (slo_typ ;|TUTORIAL_LSP_81|;"VIEWPORT,BORDER")
  (slo_typ "")  
  (slo_cmd "redrawall")
)

;;;=== End of Exercises ======================================================

;;;=== Misc functions ========================================================

(defun tutfind ( fil /  )
  (if (not (setq fff (findfile fil)))
    (progn
      (setq xxx (findfile "acis.dll"))
      (setq pth (substr xxx 1 (- (strlen xxx) 8)))
      (setq fff (findfile (strcat pth "\\tutorial\\" fil)))
    )
  )
  fff
)

(defun tutundo ( typ / xxx )  ;; typ=1 (UNDO mark), typ=0 (UNDO back)
  (if (= typ 1)
    (setq xxx "_mark")
    (setq xxx "_back" typ 0)
  )
  (if (/= tutchk typ)
    (progn
      (setvar "cmdecho" 1)
      (command "_.undo" xxx)
      (setvar "cmdecho" 0)
      (setq tutchk typ)
    )
    nil
  )
)


(defun slo_princ ( str / ct )
  (setq ct 1)
  (repeat (strlen str)
    (princ (substr str ct 1))
    (setq ct (1+ ct))
    (tut_wait tut_spd)
  )
  (princ (nth 0 tut_strs))
)


(defun slo_xxx ( xxx / )
  (setvar "cmdecho" 1)
  (command xxx)
  (setvar "cmdecho" 1)
  (tut_wait tut_spd)
)

(defun slo_pik ( pt / ct ) 
  (setq ename (car (nentselp pt))) 
  (redraw ename 3)
  (setvar "cmdecho" 0)
  (command pt)
  (setvar "cmdecho" 1)
  (tut_wait tut_spd)
)

(defun slo_typ ( str / ct )
  (setq ct 1)
  (repeat (strlen str)
    (princ (substr str ct 1))
    (setq ct (1+ ct))
    (tut_wait tut_spd)
  )
  (repeat (1- ct)(princ "\010"))
  (setvar "cmdecho" 1)
  (command str)
;  (setvar "cmdecho" 0)
)

(defun slo_kwd ( str / ct xxx)
  (setq ct 1) 
  (repeat (strlen str)
    (princ (substr str ct 1))
    (setq ct (1+ ct))
    (tut_wait tut_spd)
  )
  (repeat (1- ct)(princ "\010"))
  (setvar "cmdecho" 1)
  (if (setq xxx (cadr (assoc str tut_kwds)))
    (command xxx)                   ;; if str is in keyword list, use that
    (command (strcat "_" str))      ;; else, keyword gets underscored and used as-is
  )
;  (setvar "cmdecho" 0)
)

(defun slo_cmd ( str / ct )
  (setq ct 1)
  (setq cname (getcname (strcat "_" str)))
  (repeat (strlen cname)
    (princ (substr cname ct 1))
    (setq ct (1+ ct))
    (tut_wait tut_spd)
  )
  (repeat (1- ct)(princ "\010"))
  (setvar "cmdecho" 1)
  (command cname)
;  (setvar "cmdecho" 0)
)

;;; (tut_wait) waits <ttt> milliseconds

(defun tut_wait ( ttt / xxx ) 
  (setq xxx (+ (getvar "cdate") (* ttt 0.000000001 )))
  (while (> xxx (getvar "cdate")) )
)

;;;=========================================================================
;;; Error handling program

(defun ac:erron ( varlst / )
  (setvar "cmdecho" 0)
  (setq acerr *error*)
  (setq ac=mods nil)
  (if varlst 
    (foreach n varlst 
      (setq ac=mods (append ac=mods (list (list n (getvar n)))))
    )
  )
  (defun *error* (msg) 
    (if ac_errprg (ac_errprg))
    (if ac=mods (foreach n ac=mods (setvar (car n) (cadr n))) )
    (setq *error* acerr)
    (princ (strcat "Error: " msg ))
    (if (and ac_errmsg (/= ac_errmsg ""))
      (princ (strcat "\n  >> " ac_errmsg " <<"))
    )
    (setq ac_errmsg nil)
    (princ)
  )
  (defun ac:erroff ()
    (if ac=mods (foreach n ac=mods (setvar (car n) (cadr n))) )
    (setq ac_errprg nil)
    (setq *error* acerr)
    (princ)
  )
)

;;;===========================================================================

(princ)

