/*


                             DdeWin.H

                   Windows Dynamic Data Exchange

                         Data Structures

*/



/* Ensure that C++ modules use the right linking conventions when calling
   functions contained in C. */
#ifdef __cplusplus
    extern /*MSG0*/"C" {
#endif


#if !defined(WINAPI) && !defined(HCWIN)   /* Windows 3.0 windows.h--provide
                                               3.1 defs (for QCWIN) */
typedef unsigned int UINT;
#define WINAPI _far _pascal
#define CALLBACK FAR PASCAL
typedef const char FAR* LPCSTR;
typedef UINT WPARAM;
typedef LONG LPARAM;
typedef LONG LRESULT;
typedef LRESULT (CALLBACK* WNDPROC)(HWND, UINT, WPARAM, LPARAM);
#endif  /* CALLBACK && HCWIN */


#include "ddeml.h"

extern char FldSep[];
extern char *FldSepStr;
extern char FldSepChr;

extern char RecSep[];
extern char *RecSepStr;
extern char RecSepChr1;
extern char RecSepChr2;

extern long DdeSem;
extern char MainClassName[];
extern char DdeClassName[];

extern Tlink *TopicList;
extern Tlink *SysItemList;
extern Tlink *FormatList;

#define FORMATLISTLEN 20
extern int FormatNumList[];


#define SSEXCEL  1                    /* for apptype below */
#define SSLOTUS  2

typedef struct {
    unsigned wildcard : 1;            /* this topic was received or 
                                        created as a result of a NULL 
                                        topic broadcast. */
    unsigned remoteterm : 1;          /* remote terminated this channel */
    unsigned localterm : 1;           /* We sent TERMINATE msg. */
    unsigned advise_on : 1;           /* advise hot link on now? */
} CHNLSTATE;


        /* Structure of DDE objects (requests, states, data, etc.)
        designed for a linked list implementation.
        Changes here should be reflected in DdeClone(), which
        copies data and not pointers to a new clone object. */
struct _DDE {
    struct _DDE *next;                /* next DDE structure in list. */
    PHDATA pData;                     /* pointer to DDE transfer data. */
    long DataSize;                    /* size of data (follows the PM
                                         structure DDESTRUCT and the item
                                         name).  */
    HCONV hConv;                      /* Pointer to the DDE structure
                                         in shared memory, received with
                                         input messages from PM */
    char *app;
    char *topic;
    char *item;                         
    HSZ hAppName;
    HSZ hTopicName;
    int channel;                      /* After a successful initialized 
                                         link with a remote application and 
                                         topic, this is the channel number,
                                         starting with 1 */
    CHNLSTATE ChannelState;
    int apptype;                      /* EXCEL, LOTUS, ?*/      
    int (*AdviseFunc)(struct _DDE *pdde);
                                      /* Call this if advise "hot link"
                                         data comes in */
    char *acadadvise;                 /* command string to send to AutoCAD
                                         if advise warm link message comes
                                         in */
    UINT maxcols;                     /* widest row of last transfer */ 
    HDDEDATA hReqData;
};
typedef struct _DDE DDE;
typedef DDE *PDDE;




typedef int (*ADVISEFUNC)(PDDE padde);

#define MAXNAME      32
#define MAXDATA      92
#define MAXCMD          128
#define MAXSPEC           8


#define HOTLINK  0
#define WARMLINK 1

/* For "flags" below */
typedef struct {
    unsigned advise : 1;              /* want warm links? (instead of manual 
                                         update) */     
    unsigned init : 1;                /* TRUE if idinst is 0 to DdeInit--
                                         DdeUnInitialize needs to be called */  
    unsigned show : 1;                /* Show more error messages */    
} DDEDATAFLAG;


        /* DDE global data.  Used for defaults to dialogs, 
        handles and flags for utility functions, etc. */
struct tagDDEDATA {
    PDDE CurChnl;                     /* current channel */
    HWND hwnd;                        /* current window */      
    HANDLE hInst;                     /* main program anchor block */
    DWORD idInst;                     /* DDE user handle */
    PDDE ChnlList;                    /* list of dde channel objects */
    short ChnlNum;                    /* current channel number */
    char progname[MAXNAME+1];         /* Name of this program */
    char app[MAXNAME+1];              /* remote DDE app name */
    char topic[MAXPATH+1];            /* work file (path name) */
    char path[MAXPATH+120];           /* path of app, if not on PATH */
    short apptype;                    /* 123, Excel */  
    short appIdx;                     /* Excel, 123w, Quatro Pro */     
    DDEDATAFLAG flags;                /* See above */   
    char ProfFile[MAXNAME+5];         /* INI file for saving options */
    short spreadsheet;                /* 0 = English Excel, 1 = Other */
    char rowspec[MAXSPEC+1];          /* row specifier for spreadsheet */
    char colspec[MAXSPEC+1];          /* column specifier for spreadsheet */
    char rangespec[MAXSPEC+1];        /* range specifier for spreadsheet */
    char opencmd[MAXCMD+1];           /* open command for spreadsheet */
    char worksheet[MAXNAME+1];        /* name of default worksheet */
};
typedef struct tagDDEDATA ddeDATA;




extern HWND hwndDde;
extern char DdeError[];
extern char *DdeMsgAry[];

/* Global Function Prototypes for ddewin.c */

ddeDATA *DdeInit(char *ProgName, HANDLE hInst, DWORD idinst); 
void DdeQuit(void);
int DdeSendAcadCmd(char *);
void DdeDefaults(char *app, char *topic, char *appexe);
PDDE DdeChannel(char *app, char *topic);
int StartApp(char *appname, char *commline);
int DdeRemoveAll(int FreeDataFlag);
int DdeCheckConv(HCONV hConv);
PDDE DdeAppInit(char *AppName, char *TopicName, char *AppExe);
int DdeInitSystem(char *AppName, char *TopicName);
PDDE DdeInitiate(char *AppName, char *TopicName);
PDDE DdeGetCurChnl(void);
int SwitchChnlIndex(int ChnlIdx);
int DdeSwitchChnl(int ChnlNum);
PHDATA DdeFormatList(PLINK TextList, int NumCol, ULONG *DataLength);
void DdeRemoveChannel(PDDE pdde, int FreeDataFlag);
void DdeTerminate(PDDE pdde, int FreeDataFlag);
void DdeFree(PDDE pdde);
DWORD DdeRequest(PDDE pdde, char *item, UINT uFmt, ULONG WaitTime);
DWORD DdeReqString(PDDE pdde, char *item);
DWORD DdePokeString(PDDE pdde, char *item, char *pString);
DWORD DdePoke(PDDE pdde, char *item, ULONG DataLen, char *pData, UINT uFmt);
DWORD DdeExec(PDDE pdde, char *pString);
void DdeSetAdvise(PDDE pdde, char *item, char *command, ADVISEFUNC advfunc);
void DdeAdviseCur(PDDE pdde, int yes, int linktype);
DWORD DdeAdvise(PDDE pdde, char *item, UINT uFmt, int NoData);
DWORD DdeUnAdvise(PDDE pdde, char *item, UINT uFmt);
DWORD DdeSendTerm(PDDE pdde);
DWORD DdeSend(PDDE pdde, char *ItemName, int Xtype, ULONG DataLen, 
              char *pData, UINT uFmt, ULONG WaitTime);
int IsValidChannel(int Chnl);
PDDE DdeFindConv(HCONV hConv);
PDDE DdeFindChnl(char *app, char *topic);
PDDE DdeFindChnlNum(int channel);
int IsActiveChnl(PDDE pdde);
int IsValidPdde(PDDE pdde);
BOOL FAR PASCAL DDEDLGMsgProc(HWND hWndDlg, UINT Message, 
        WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL DDESPREADSHDLGMsgProc(HWND hWndDlg, UINT Message, WPARAM wParam,
                    LPARAM lParam);
PDDE DdeDlgStart(HWND hwnd, int forcedlg);
int DdeDialog(HWND hwnd);
int DdeSpreadshDialog(HWND hwnd);
void DdeFreeData(PDDE pdde);
void strhandle_msg(char *name);
void DdeWriteProfile(char *profFile);
int DdeGetProfile(char *profFile);
int DdeSetApp(char *AppName, int pathFlag);
int DdeFindApps(void);
int DdeFindApp(char *classname, char *exePath);
int DdeFindOpenCmd(char *classname, char *openCmd);
int DdeIsDefTopic(char *topic);



#ifdef __cplusplus
    }
#endif

