/*      

    DDECONV.H

    Conversion between AutoCAD data and DDE/Clipboard text format.
*/


/* Ensure that C++ modules use the right linking conventions when calling
   functions contained in C. */
#ifdef __cplusplus
    extern /*MSG0*/"C" {
#endif



#define ENAME_MODE 0
#define HANDLE_MODE 1
#define ATTR_MODE 2
#define ATTR_MODE2 3

#define DSTARTROW 3
#define DSTARTCOL 1


#define SEQ_ATTR     1          /* Insert with following attrs, SEQEND */
#define SEQ_PLINE    2          /* Insert with polyline vertices, SEQEND */

#define TABLEGAP 4
#define COLMAX 80               /* maximum columns for attribute data */


#define MAXARGS 12              /* Put a limit on number of arguments 
                                   for protection from non RTNONE 
                                   terminated list */
#define ENAMOFFS 0
#define ENTTERM -4
#define ALL_ENTS -4
#define FRMTMAX 6

typedef struct resbuf RESBUF;
#define RBSIZE (sizeof (RESBUF))

#define HPREFIX 'x'             /* Prefix put on handle strings, to prevent
                                floating point interpretation of it (hex 
                                strings have E's in them sometimes).  */

extern char AcFldSep[];
extern char AcRecSep[];

                /* cell item to ads_real (double) conversions */
extern char CellFmt[];
extern char CellFmt2[];
extern char PointScan[];                /* DDE text format of point:
                                        real<TAB>real<TAB>real */
extern char LongScan[];
extern char EnameScan[];
extern char HexFmt[];
extern char RealFmt[];

/* For AutoCAD or LISP function arguments. */
typedef struct {
    short argtype;              /* anticipated type */
    RESBUF *rb;                 /* returned pointer to argument */
} ARGLIST;
#define RSTR rb->resval.rstring
#define RINT rb->resval.rint
#define RREAL rb->resval.rreal
#define RLNAME rb->resval.rlname


/* For creating a list of constant block symbol table data */
typedef struct tagBlkAttr {
    struct tagBlkAttr *next;
    char *tag;
    char *value;
    char *handle;
    unsigned col;                     /* spreadsheet column for constant 
                                         data to allow cell reference 
                                         from inserts */
} BlkAttr;


/* For creating a list of constant block symbol table data */
typedef struct tagBlkList {
    struct tagBlkList *next;
    char *block;
    BlkAttr *attrlist;
    unsigned ary_cnt;                 /* could be minsert */            
} BlkList;


/* ConvData->status: scan text stream status bits */
typedef struct {
    unsigned END_BLK : 1;       /* no more data in this block request */
    unsigned END_ALL : 1;       /* found end of all blocks */
    unsigned USR_BRK : 1;       /* user ^C */
    unsigned ATTR_FILTER : 1;   /* Is an attribute filter on? */
    unsigned TABLE_FLAG : 1;
    unsigned FIRST : 1;
    unsigned SEQ : 1;           /* Are we in the middle of a sset sequence 
                                   (attributes, polylines) */
} CONV_STATUS;


struct tagCONVDATA {              /* conversion data, such as number of 
                                entities in transfer, number
                                modified, etc. */
        PHDATA pBuff;           /* start of text buffer for entity
                                text conversion */
        ULONG BuffLen;          /* Length of buffer */
        RESBUF **ppEnt;         /* addr of first entity link */
        ads_name ename;         /* Last entity name retrieved */
        long EntCnt;            /* count of entities--ssname needs the long */
        UINT ModCnt;            /* how many entities modified */
        long BlkLen;            /* length of 1 transfer block */
        UINT TotRows;           /* total rows taken up in spreadsheet */
        UINT BlkRows;           /* rows taken up in spreadsheet, for
                                this transfer */
        UINT EntRows;           /* how many sub-entities so far in this
                                entity */
        UINT row;               /* current row in spreadsheet */
        UINT row1;              /* start row in spreadsheet */
        UINT col1;              /* start col in spreadsheet */
        short first;            /* first call? */
        CONV_STATUS status;     /* done with data?  user break? */
        short etype;            /* entity, selection set, table? */
        char *tblname;          /* table name, like "BLOCK" */
        ads_name sset;          /* selection set starting ename */
        long ssidx;             /* selection set index */
        PDDE pdde;              /* DDE channel object */
        short TableNum;         /* which table? */
        short format;           /* format to write (and read) entities */
        Tlink *textlist;        /* Start node of linked list of strings
                                   converted from AutoCAD entities or
                                   whatever */
        short maxcols;          /* Largest number of col's used by any
                                   row in the spreadsheet transfer */
        short cols;
        };
typedef struct tagCONVDATA CONVDATA;
#define SIZECONV (sizeof (CONVDATA))


#define ET_RB   0               /* result buffer */
#define ET_NORM 1               /* normal entity */
#define ET_SSET 2               /* selection set */
#define ET_TBL  3               /* table (vport, block, etc) */
        /* table numbers, after adding ET_TBL */
#define ET_VPORT  3
#define ET_LTYPE  4
#define ET_LAYER  5
#define ET_STYLE  6
#define ET_VIEW   7
#define ET_UCS    8
#define ET_BLOCK  9
#define ET_DIMSTYLE  10


        /* Attribute Styles */
#define AS_PLAIN -1             /* Styles of formatting attributes */


        /* table numbers, 0 based */
#define VPORT 0 
#define LTYPE 1
#define LAYER 2
#define STYLE 3
#define VIEW  4
#define UCS   5
#define BLOCK 6





#define ENTMARK -1              /* dxf group code of entity name */
#define SEQMARK -2              /* dxf group code for sequence end,
                                block, etc */
#define DDECOMMENT -9           /* arbitrary comment definition for
                                DDE users to put comments in spread-
                                sheet */
#define ANON 1                  /* anonymous block */
#define HAS_ATTR 2              /* dxf 70 bit for block has attribute */

#define RTEXTDS 20
#define RTEXTDG 21

#define ENT_WIDTH 4

                /* string / real (double) conversion format strings */
extern char RealScan[];
extern char RealFmt[];
extern char CellFmt[];
extern char CellFmt2[];

extern char DxfName[];
extern ATOM DxfNum;   

extern double DdeTolerance;


/* Global Function Prototypes for ddeconv.c */

void SetDdeFormat(int format);
int GetDdeFormat(void);
UINT PokeDrawing(PDDE pdde, UINT sRow, UINT sCol);
UINT ModDrawing(PDDE pdde, UINT row, UINT col, UINT NumRows);
UINT PokeAllTables(PDDE pdde, UINT sRow, UINT sCol);
UINT PokeTable(PDDE pdde, int TableNum, char *item, UINT sRow,
                 UINT sCol, int WriteEnd);
UINT PokeSet(PDDE pdde, ads_name ename, char *item, UINT sRow, UINT sCol);
int PokeAttrSet(CONVDATA *ConvData);
int PokeAttr(CONVDATA *ConvData);
int CreateAttrList(CONVDATA *ConvData);
int ConstList(Tlink **ptlist, RESBUF *pEnt);
void CreateConstList(BlkList **blkList);
BlkAttr *CreateConstSubList(BlkAttr **attrList, char *blkname, RESBUF *pBlk, 
                int *col);
BlkList *FindOrCreateBlock(BlkList **blkList, char *blk);
void FreeConstList(BlkList **blkList);
void FreeConstSubList(BlkAttr **attrList);
void PokeConstList(PDDE pdde, BlkList *blkList);
void PokeConstAttrList(PDDE pdde, BlkAttr *attrList);
int AddEntList(CONVDATA *ConvData, RESBUF *pEnt, int grpcode);
int PokeConvList(CONVDATA *ConvData);
UINT PokeEntList(PDDE pdde, UINT Row, UINT Col, ads_name ename, int etype);
UINT EntPokeCell(PDDE pdde, UINT Row, UINT Col, RESBUF *pEnt, int etype);
UINT EntPoke(PDDE pdde, char *ItemStr, RESBUF *pEnt, int etype);
UINT ReqMod(PDDE pdde, char *Item, UINT *RowCnt, int *more);
UINT ModTextStream(PHDATA pData, UINT *RowCnt);
char *EntListFormat(RESBUF *pEnt, int etype);
ULONG EntFormat(RESBUF *pEnt, char *pData, UINT *LinkCnt, int etype);
UINT EntRowFormat(RESBUF *pEnt, UINT *LinkCnt, char *EntTextStrm);
UINT SubEntFormat(RESBUF *pEnt, char *ValStr, int etype);
int dxftype(int grpcode, int etype);
void EntFree(RESBUF **pEntDde);
void ConvPrecision(int precision, ads_real Tolerance);
void ConvSeparators(char *FldSeparator, char *RecSeparator);
short SetFlatLand(void);
BOOL SetHandles(void);
ULONG LenAllTable(void);
UINT LenTable(short TableNum);
PDDE AdsChnl(char *app, char *topic);
short AcPrintChnlList(void);
short BuildChnlList(PLINK *list, char *fldsep);
int AcPrompt(char *prompt, char *DefString, char *result);
void AcPrintList(PLINK TextList, char *Separator);
void AcPrintRb(RESBUF *pEnt, short etype);
short FldCopy(char *dest, char *src);
UINT GetEntLen(RESBUF *pEnt);
void PokeEndStringConv(CONVDATA *ConvData);
int PokeBlankRow(PDDE pdde, int row, int col);
void IncRow(CONVDATA *ConvData, int inc);
RESBUF *assoc(RESBUF *Ent, int type);
int IsEntType(RESBUF *pEnt, char *entstr);
RESBUF *GetEntFromHandle(RESBUF *pEntDde);
long DecimalHandle(char *hexstr, char *result);
int IsSequence(RESBUF *pEnt);
int GetInserts(ads_name ss, int skip_const);
int GetArgList(ARGLIST *arglist, char *funcname);
int InsertArrayCnt(RESBUF *pEnt);
int ShowLife(UINT row);



#ifdef __cplusplus
    }
#endif


/* end of file */

