#
# MFCLIST.MAK
#
#       makefile to make ADS C++ sample MFCLIST.EXE
#
#      (C) Copyright 1988-1994 by Autodesk, Inc.
#
#      This program is copyrighted by Autodesk, Inc. and is  licensed
#      to you under the following conditions.  You may not distribute
#      or  publish the source code of this program in any form.   You
#      may  incorporate this code in object form in derivative  works
#      provided  such  derivative  works  are  (i.) are  designed and
#      intended  to  work  solely  with  Autodesk, Inc. products, and
#      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
#      1988-1994 by Autodesk, Inc."
#
#      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
#      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
#      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
#      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
#      UNINTERRUPTED OR ERROR FREE.
#
#
#
!include <..\..\adsmake.nt>
!include <..\mfcads.inc>
!include <mfclist.inc>

VPATH   = $(MFCLIST_OBJ_DIR)
LOCINC  = $(ADS_CPP)\GENERAL $(ADS_CPP)\mfcads $(ADS_CPP)\DDE $(ADS)

#
# VC2/MFC3.0 requires a standard C RTL that supports "threads"
# so we have to use /MT on the compiler command line.
#
!if "$(ACCOMPILER)" == "VC2" || "$(ACCOMPILER)" == "vc2"
LIBTYPE = /MT
!endif

ADSLIB = $(ACOBJ)\ADS\WINADS.LIB

all: $(ACEXE)\MFCLIST.EXE

MFCLIB=nafxcwd.lib
LINK_LIBS = $(MFCLIB) ADVAPI32.LIB SHELL32.LIB $(ac_guilibs) $(ADSLIB)

#
# Note the sequence of libraries, $(guilibsmt) is placed in front 
# of nafxcwd.lib.  This is done so LIBCMT.LIB in $(guilibsmt) will 
# not pick up WinMain() definition from $(ADSLIB)
# 
!if "$(ACCOMPILER)" == "VC2" || "$(ACCOMPILER)" == "vc2"
LINK_LIBS = $(guilibsmt) $(MFCLIB) SHELL32.LIB $(ADSLIB)
!endif

LINK_OBJS = $(BASEOBJS) $(MFCLISTOBJS) $(DDEOBJS) $(MFCADSOBJS)

$(ACEXE)\MFCLIST.EXE: $(LINK_OBJS) $(VPATH)\$(@B).res $(MAKEFILE) $(DDEOBJ)
    echo Linking $(ac_ldebug_echo) $@
    $(link) @<< $(ERRSTUFF) $(CVDBUG)
    $(VPATH)\$(@B).res $(LINK_OBJS)
    $(ads_lflags) -MACHINE:IX86
    -nodefaultlib
    $(LINK_LIBS)
    $(ac_ldebug_flags)
    -out:$@
<<

# --- default rules for making .exe ---
{.}.cpp{$(VPATH)}.obj:
    echo Compiling $(@B).cpp
    if exist $@ del $@
    $(COMP) -Tp$(@B).cpp $(ERRSTUFF)
    $(POSTERR)

{.}.rc{$(VPATH)}.res:
    echo Compiling Resource $@
    rc -Fo$(VPATH)\$(@B).res $(@B).rc

    
clean:
	echo Cleaning MFCLIST Objects
	if not exist $(VPATH) mkdir $(VPATH)
    if exist $(VPATH)\*.* del /Q $(VPATH)\*.*
    if exist $(MFCLIST_DIR)\*.pdb del /Q $(MFCLIST_DIR)\*.pdb
    if exist $(ACEXE)\mfclist.* del /Q $(ACEXE)\mfclist.*

