/* 
    ENTLIST.CPP -
    
    This file:

        A simple ADS MFC list box demo application.  List out
        all entities in the current drawing, given the entity is
        supported entities in ADS_ENT class, in a list box.  Double 
        clicking in the list box brings up a detail information 
        about the selected entity.

        From ACAD command prompt:

        ( xload "MFCLIST" ) to start the application.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "mfclist.h"

//-----------------------------------------------------------------------------
struct MYADS_APP : ADS_APP
{
    BOOL            InitInstance();
    void            GetSelectedEntity( struct resbuf *rb );
};

//-----------------------------------------------------------------------------
static char temp_buf[ 256 ];

//-----------------------------------------------------------------------------
extern "C" void GetSelectedEntity( struct resbuf* rb)
{
    ( ( MYADS_APP *)main_app )->GetSelectedEntity( rb );
}

//-----------------------------------------------------------------------------
extern "C" void test( struct resbuf* )
{
    wsprintf( temp_buf, "HELLO\n" );
    ads_printf( temp_buf );
}

//-----------------------------------------------------------------------------
ADS_FUNC_INFO       app_funs[] = 
{
/*                                                                    */
/*      Function                       Type            Name           */
/*                                                                    */
    ADS_FUNC_INFO( ADS_FUNC( test ),   ADS_VOID_FUNC,  "c:test", "Use Test\n")
  , ADS_FUNC_INFO( ADS_FUNC( GetSelectedEntity), ADS_VOID_FUNC, "C:GetSelectedEntity", NULL )
};

//-----------------------------------------------------------------------------
// This function has to be called from AutoCAD!!!
//
void MYADS_APP::GetSelectedEntity( struct resbuf * )
{
    ads_name        temp_ent_name;

    ( ( CWINDOW* )m_pMainWnd )->GetEntityName( &temp_ent_name );

    CENTITYDIALOG *ent_dialog = MakeEntityDialog( temp_ent_name );
    if ( ent_dialog )
    {
        ent_dialog->DoModal();
        DeleteEntityDialog( ent_dialog );
    }
}

//-----------------------------------------------------------------------------
BOOL    MYADS_APP::InitInstance()
{
    if ( ADS_APP::InitInstance() != TRUE )
    {
        return FALSE;
    }

    for ( int i = 0; i < ARRAY_SIZE( app_funs ); i++ )
    {
        if ( InsertExternFunc( app_funs[i] ) == -1 )
        {
            return FALSE;
        }
    }
    
    m_pMainWnd = new CWINDOW();
    m_pMainWnd->ShowWindow(m_nCmdShow);
    m_pMainWnd->UpdateWindow();
    return TRUE;
}

//-----------------------------------------------------------------------------
MYADS_APP   myads_app;
