/* 
    MFCBLANK.CPP -
    
    This file:

        Implements a VERY simple MFC ADS program.  

        (xload "MFCBLANK") to load the app.

        (test) To request service from the app.  The app responds by
               print out "HELLO from MFCADS" message in ACAD text window.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include <afxwin.h>
#include "adsinc.h"
#include "mfcads.h"
#include "resource.h"


//-----------------------------------------------------------------------------
struct MYADS_APP : ADS_APP
{
    virtual BOOL    InitInstance();
};

//-----------------------------------------------------------------------------
MYADS_APP   myads_app;

//-----------------------------------------------------------------------------
static char temp_buf[ 256 ];

//-----------------------------------------------------------------------------
extern "C" void test( struct resbuf* )
{
    wsprintf( temp_buf, "HELLO from MFCADS\n" );
    ads_printf( temp_buf );
}

//-----------------------------------------------------------------------------
ADS_FUNC_INFO       app_funs[] = 
{
/*                                                                          */
/*      Function                       Type            Name      Message    */
/*                                                                          */
  ADS_FUNC_INFO( ADS_FUNC( test ),   ADS_VOID_FUNC,  "c:test", "Use Test\n")
};

//-----------------------------------------------------------------------------
class CMainWindow : public CFrameWnd
{
public:
	CMainWindow();

	//{{AFX_MSG( CMainWindow )
	afx_msg void OnPaint();
	afx_msg void OnAbout();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

//-----------------------------------------------------------------------------
CMainWindow::CMainWindow()
{
	LoadFrame(IDR_MAINFRAME);
}

//-----------------------------------------------------------------------------
void CMainWindow::OnPaint()
{
	CRect rect;
	GetClientRect(rect);

	CPaintDC dc(this);
	dc.SetTextAlign(TA_BASELINE | TA_CENTER);
	dc.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
	dc.SetBkMode(TRANSPARENT);
	CString s;
	s.LoadString(IDS_HELLO);
	dc.TextOut((rect.right / 2), (rect.bottom / 2), s);
}

//-----------------------------------------------------------------------------
void CMainWindow::OnAbout()
{
	CDialog about(IDD_ABOUTBOX);
	about.DoModal();
}

BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	//{{AFX_MSG_MAP( CMainWindow )
	ON_WM_PAINT()
	ON_COMMAND(ID_APP_ABOUT, OnAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//-----------------------------------------------------------------------------
BOOL    MYADS_APP::InitInstance()
{
	TRACE0("CTheApp::InitInstance\n");

    if ( ADS_APP::InitInstance() != TRUE )
    {
        return FALSE;
    }
    for ( int i = 0; i < ARRAY_SIZE( app_funs ); i++ )
    {
        if ( InsertExternFunc( app_funs[i] ) == -1 )
        {
            return FALSE;
        }
    }
#if 0   // VC2...
	Enable3dControls(); // use 3d controls in dialogs
#endif
	m_pMainWnd = new CMainWindow;
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();

    return TRUE;
}

