/* 
    MAINWND.CPP -
    
    This file:

        Defines basic WINDOW object and MAINWDOW object.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "HELLOADS.h"

char MAINWINDOW::szClassName[] = APP_NAME;

//-----------------------------------------------------------------------------
MAINWINDOW::MAINWINDOW()
{
    text = szClassName;
    
    if ( Register() )
    {

        hWnd = CreateWindow( szClassName
                            , szClassName
                            , WS_OVERLAPPEDWINDOW
                            , CW_USEDEFAULT
                            , 0
                            , CW_USEDEFAULT
                            , 0
                            , NULL
                            , NULL
                            , AppInstance()
                            , (LPSTR) this ); 
    }
    assert( hWnd );
}

//-----------------------------------------------------------------------------
BOOL MAINWINDOW::Register( void )
{
    WNDCLASS wndclass;

    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = ::WndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = sizeof( MAINWINDOW * );
    wndclass.hInstance     = AppInstance();
    wndclass.hIcon         = NULL;
    wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wndclass.hbrBackground = ( HBRUSH )GetStockObject( WHITE_BRUSH );
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = szClassName;

    if ( ! RegisterClass( &wndclass ) )
    {
        return( FALSE );
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
void MAINWINDOW::Paint( void )
{
    PAINTSTRUCT ps;
    RECT        rect;
    HDC hdc = BeginPaint( hWnd, &ps );
    GetClientRect( hWnd, &rect) ;
    DrawText( hdc
            , text.CString()
            , -1
            , &rect
            , DT_SINGLELINE | DT_CENTER | DT_VCENTER );
    EndPaint( hWnd, &ps );
}

//-----------------------------------------------------------------------------
LRESULT MAINWINDOW::WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam )
{
    switch (iMessage)
    {
        case WM_CREATE:
        {
        }
        break;

        case WM_PAINT:
        {
            Paint();
        }
        break;

        case WM_DESTROY:
        {
            PostQuitMessage( 0 );
        }
        break;

        default:
        {
            return DefWindowProc( hWnd, iMessage, wParam, lParam );
        }
    }
    return 0;
}

//-----------------------------------------------------------------------------
inline WINDOW *GetPointer( HWND hWnd )
{
    return (WINDOW *) GetWindowLong( hWnd, 0 );
}
//-----------------------------------------------------------------------------
inline void SetPointer( HWND hWnd, WINDOW *pWindow )
{
    SetWindowLong( hWnd, 0, (LONG) pWindow );
}

//-----------------------------------------------------------------------------
LRESULT  CALLBACK WndProc( HWND hWnd
                        , UINT iMessage
                        , WPARAM wParam
                        , LPARAM lParam )
{
    WINDOW *pWindow = GetPointer( hWnd );

    if ( pWindow == 0 )
    {
        if ( iMessage == WM_CREATE )
        {
            LPCREATESTRUCT lpcs;

            lpcs = (LPCREATESTRUCT) lParam;
            pWindow = (WINDOW *) lpcs->lpCreateParams;

            SetPointer( hWnd, pWindow );
            return pWindow->WndProc( iMessage, wParam, lParam );
        }
        else
        {
            return DefWindowProc( hWnd, iMessage, wParam, lParam );
        }
    }
    else
    {
        return pWindow->WndProc( iMessage, wParam, lParam );
    }
}
