/* 
    CPPSTUFF.H -
    
    This file:

        Declares some basic ADS C++ macros, enums and 
        function structures.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef CPPSTUFF_H
#define CPPSTUFF_H

//-----------------------------------------------------------------------------
#define     MAX_ADS_FUNC        20
#define     ARRAY_SIZE(x)       sizeof(x)/sizeof(x[0])

//-----------------------------------------------------------------------------
#define     BASIC_CPP_STUFF( class_x )                              \
            class_x&    operator=( const class_x& );                \
                        class_x(const class_x&);                    \
            public:                                                 \
            virtual void WhoAmI( char *buf )                        \
            {                                                       \
                if ( buf )                                          \
                    strcpy( buf, #class_x );                        \
            }                                                       \
            private:                                                \

//-----------------------------------------------------------------------------
enum ADS_FUNC_TYPE
{
    ADS_INT_FUNC
    , ADS_VOID_FUNC
    , ADS_REAL_FUNC
    , ADS_UNKNOWN_FUNC
};

//-----------------------------------------------------------------------------
enum ADS_APP_STATE
{
    APP_OK  = 1
    , APP_DONE
};

//-----------------------------------------------------------------------------
extern "C"
{
typedef int         (*ADS_int_FUNC)(struct resbuf*);
typedef void        (*ADS_void_FUNC)(struct resbuf*);
typedef ads_real    (*ADS_real_FUNC)(struct resbuf*);
}

//-----------------------------------------------------------------------------
struct ADS_FUNC
{
    union _ADS_FUNC
    {
        ADS_int_FUNC        AdsIntFunc;
        ADS_void_FUNC       AdsVoidFunc;
        ADS_real_FUNC       AdsRealFunc;
    }calling_fun;
    ADS_FUNC( ADS_int_FUNC aintfun ){ calling_fun.AdsIntFunc = aintfun; }
    ADS_FUNC( ADS_void_FUNC avoidfun ){ calling_fun.AdsVoidFunc = avoidfun; }
    ADS_FUNC( ADS_real_FUNC arealfun ){ calling_fun.AdsRealFunc = arealfun; }
    ADS_FUNC(){ calling_fun .AdsIntFunc = NULL; }
};

//-----------------------------------------------------------------------------
class   ADS_APP;
extern  ADS_APP     *main_app;

//-----------------------------------------------------------------------------
ADS_APP* GetAdsApp();

//-----------------------------------------------------------------------------
struct  ADS_FUNC_INFO
{
    ADS_FUNC        extern_func;
    ADS_FUNC_TYPE   func_type;
    char            extern_name[256];
    int             func_code;
    char            message[256];
                    ADS_FUNC_INFO(){}
                    ADS_FUNC_INFO(ADS_FUNC _extern_func
                            , ADS_FUNC_TYPE _ads_func_type
                            , char *_extern_name
                            , char *message = NULL);
};

//-----------------------------------------------------------------------------
#ifndef ASSERT
inline void ASSERT ( int exp )
{
    if ( exp == 0 )
    {
        ::MessageBox( GetFocus(), "Assert  occuried! " , "INFO", MB_OK );
        _asm int 3;
    }
//    assert ( exp );
}
#endif

#endif
