/* 
    ADSENT.H -
    
    This file:

        Declares basic ADS entity objects.  Only a few objects,
        ADS_POINT, ADS_LINE and ADS_CIRCLE are declared.  This 
        should be expanded to cover wider range of ACAD objects 
        by the users.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef ADSENT_H
#define ADSENT_H

//-----------------------------------------------------------------------------
struct ADS_ENT_OBJ;
struct ADS_GENERIC_ENTITY;
struct ADS_LINE;
struct ADS_CIRCLE;
struct ADS_SHAPE;
struct ADS_POINT;

//-----------------------------------------------------------------------------
ADS_ENT_OBJ*    MakeAdsEntity( struct resbuf *rb );
void            DeleteAdsEntity( ADS_ENT_OBJ* ent_obj );

//-----------------------------------------------------------------------------
struct ADS_ENT_OBJ : ADS_OBJ
{
    struct resbuf   *rb;
    BOOL            Valid(){ return ( rb != NULL ); }
                    ADS_ENT_OBJ( struct resbuf *_rb )
                    {
                        rb = _rb;
                    }
    virtual         ~ADS_ENT_OBJ(){}
	ADS_STRING      formatstring;
                    operator ADS_STRING&();

    virtual ADS_STRING& 
                    FormatEntityString();
    char            *GetEntityName( char *buf, int buf_size );

private:
    BASIC_CPP_STUFF( ADS_ENT_OBJ )
};

//-----------------------------------------------------------------------------
struct ADS_GENERIC_ENTITY : ADS_ENT_OBJ
{
                ADS_GENERIC_ENTITY( struct resbuf *_rb ) : ADS_ENT_OBJ( _rb ){}
private:
    BASIC_CPP_STUFF( ADS_GENERIC_ENTITY )
};

//-----------------------------------------------------------------------------
struct ADS_LINE : ADS_ENT_OBJ
{
                    ADS_LINE( struct resbuf *_rb ) : ADS_ENT_OBJ( _rb ){}
    ads_point&      GetPrimary( ads_point& dst ) const;
    ads_point&      GetSecondary( ads_point& dst ) const;
private:
    BASIC_CPP_STUFF( ADS_LINE )
};

//-----------------------------------------------------------------------------
struct ADS_CIRCLE : ADS_ENT_OBJ
{
                    ADS_CIRCLE( struct resbuf *_rb ) : ADS_ENT_OBJ( _rb ){}
    ads_point&      GetRadius( ads_point& dst );
    ads_point&      GetCenter( ads_point& dst );

private:
    BASIC_CPP_STUFF( ADS_CIRCLE )
};

//-----------------------------------------------------------------------------
struct ADS_SHAPE : ADS_ENT_OBJ
{
                    ADS_SHAPE( struct resbuf *_rb ) : ADS_ENT_OBJ( _rb ){}
private:
    BASIC_CPP_STUFF( ADS_SHAPE )
};

//-----------------------------------------------------------------------------
struct ADS_POINT : ADS_ENT_OBJ
{
                    ADS_POINT( struct resbuf *_rb ) : ADS_ENT_OBJ( _rb ){}
private:
    BASIC_CPP_STUFF( ADS_POINT )
};

#endif
