/* 
    ADSENT.CPP -
    
    This file:

        Defines basic ADS entity objects.  Only a few objects,
        ADS_POINT, ADS_LINE and ADS_CIRCLE are declared.  This 
        should be expanded to cover wider range of ACAD objects 
        by the users.
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "adsinc.h"

//-----------------------------------------------------------------------------
//static ADS_STRING       entity_end_string( "\n\tEnd of Entity" );
//static ADS_STRING       entity_begin_string( "\tBegin of Entity\n" );
static ADS_STRING       entity_record_seperator("\n");

static ADS_STRING       entity_end_string( "\n" );
static ADS_STRING       entity_begin_string( " " );
//static ADS_STRING     entity_record_seperator( " " );

static ADS_STRING       entity_name_mark( "Entity Name:\t" );


//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsLine( struct resbuf *rb );
ADS_ENT_OBJ* MakeAdsCircle( struct resbuf *rb );
ADS_ENT_OBJ* MakeAdsPoint( struct resbuf *rb );
ADS_ENT_OBJ* MakeAdsShape( struct resbuf *rb );
ADS_ENT_OBJ* MakeAdsGenericEntity( struct resbuf *rb );

//-----------------------------------------------------------------------------
struct _ADS_ENT_TYPES
{
    ADS_ENT_OBJ* ( *MakeEntFun )( struct resbuf *rb );
    char            *typename;
}ADS_ENT_TYPES[] =
{
    { MakeAdsLine,          "LINE" }
    , { MakeAdsPoint,       "POINT" }
    , { MakeAdsCircle,      "CIRCLE" }
    , { MakeAdsShape,       "SHAPE" }
};

//-----------------------------------------------------------------------------
void DeleteAdsEntity( ADS_ENT_OBJ* ent_obj )
{
    delete ent_obj;
}

//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsEntity( struct resbuf *rb )
{
    int     i;
    for ( i = 0; i < ARRAY_SIZE( ADS_ENT_TYPES  ) ; i++ )
    {
        if ( _stricmp( rb->rbnext->resval.rstring
                    , ADS_ENT_TYPES[ i ].typename ) == 0 )
        {
            return ( * ( ADS_ENT_TYPES[ i ].MakeEntFun ) )( rb );
        }
    }
    if ( i == ARRAY_SIZE ( ADS_ENT_TYPES ) )
    {
        return MakeAdsGenericEntity( rb );
    }
    return NULL;
}


//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsLine( struct resbuf *rb )
{
    return new ADS_LINE( rb );
}

//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsCircle( struct resbuf *rb )
{
    return new ADS_CIRCLE( rb );
}

//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsPoint( struct resbuf *rb )
{
    return new ADS_POINT( rb );
}

//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsShape( struct resbuf *rb )
{
    return new ADS_SHAPE( rb );
}

//-----------------------------------------------------------------------------
ADS_ENT_OBJ* MakeAdsGenericEntity( struct resbuf *rb )
{
    return new ADS_GENERIC_ENTITY( rb );
}

/******************************************************************************
*                                                                             *
*                       ADS_ENT_OBJ member functions                          *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
char* ADS_ENT_OBJ::GetEntityName( char *buf, int buf_size )
{
    AdsName2Str( buf, rb );

    if ( rb->rbnext 
        && rb->rbnext->restype == 0 
        && rb->rbnext->resval.rstring != NULL )
    {
        strcat( buf, ", " );
        strcat( buf, rb->rbnext->resval.rstring );
    }
    return buf;
}

//-----------------------------------------------------------------------------
ADS_STRING& ADS_ENT_OBJ::FormatEntityString()
{
    if ( rb == NULL || rb->restype != -1 )
    {
        formatstring = "";
		return formatstring;
    }

    char    *record_buffer = new char[ GENERAL_BUFFER_SIZE ];
    //
    // Terrible way to do this, what if rb has more info GENERAL_BUFFER_SIZE
    // can handle?  I need a string library!
    //
    // Set the entity name first, which should be the rb->resval.rlname
    formatstring = entity_name_mark;

    if ( AdsName2Str( record_buffer, rb ) )
    {
        formatstring += record_buffer;
    }
    
    //
    // treeing down the resbuf for the list
    //
    struct resbuf* current_resbuf = rb->rbnext;
    while ( current_resbuf )
    {
        if ( DXFGroupCode2Str( current_resbuf, record_buffer ) != NULL )
        {
            formatstring += entity_record_seperator 
                            + record_buffer;
        }
        current_resbuf = current_resbuf->rbnext;
    }
    formatstring += entity_end_string;

    delete record_buffer;
    return formatstring;
}

//-----------------------------------------------------------------------------
// No checking for this function, used to retrieve the information pointed
// by rb. 
static inline void _JustDoIt_GetAdsPoint( ads_point& dst, struct resbuf* rb )
{
    // how about memcopy? nah...
    if ( rb == NULL )
    {
        dst[ 0 ] = 0;
        dst[ 1 ] = 0;
        dst[ 2 ] = 0;
    }
    else
    {
        dst[ 0 ] = rb->resval.rpoint[ 0 ];
        dst[ 1 ] = rb->resval.rpoint[ 1 ];
        dst[ 2 ] = rb->resval.rpoint[ 2 ];
    }
}
/******************************************************************************
*                                                                             *
*                         ADS_LINE member functions                           *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
ads_point&
ADS_LINE::GetPrimary( ads_point& dst ) const
{
    // go to the DXF_PRIM_X
    struct resbuf *temp_rb = rb;

    while( temp_rb != NULL 
        && DXFGroupCode( temp_rb->restype ) != DXF_PRIM_X )
    {
        temp_rb = temp_rb->rbnext;
    }
    ASSERT ( temp_rb != NULL );

    _JustDoIt_GetAdsPoint( dst, temp_rb );

	return dst;
}

//-----------------------------------------------------------------------------
ads_point&
ADS_LINE::GetSecondary( ads_point& dst ) const
{
    // go to the DXF_OTHER_X
    struct resbuf *temp_rb = rb;

    while( temp_rb != NULL 
        && DXFGroupCode( temp_rb->restype ) != DXF_OTHER_X )
    {
        temp_rb = temp_rb->rbnext;
    }
    ASSERT ( temp_rb != NULL );

    _JustDoIt_GetAdsPoint( dst, temp_rb );

    return dst;
}

/******************************************************************************
*                                                                             *
*                         ADS_CIRCLE member functions                           *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
ads_point&
ADS_CIRCLE::GetRadius( ads_point& dst )
{
    // go to the DXF_FLOAT_FACT which is the radius
    struct resbuf *temp_rb = rb;

    while( temp_rb != NULL 
        && DXFGroupCode( temp_rb->restype ) != DXF_FLOAT_FACT )
    {
        temp_rb = temp_rb->rbnext;
    }
    ASSERT ( temp_rb != NULL );

    _JustDoIt_GetAdsPoint( dst, temp_rb );

    return dst;
}

//-----------------------------------------------------------------------------
ads_point&
ADS_CIRCLE::GetCenter( ads_point& dst )
{
    // go to the DXF_PRIM_X which is the center
    struct resbuf *temp_rb = rb;

    while( temp_rb != NULL 
        && DXFGroupCode( temp_rb->restype ) != DXF_PRIM_X )
    {
        temp_rb = temp_rb->rbnext;
    }
    ASSERT ( temp_rb != NULL );

    _JustDoIt_GetAdsPoint( dst, temp_rb );

    return dst;
}

