/* 
    ADSDXF.CPP
    
    This file:

    Defines DXF group conversion functions and enums in converting
    DXF group code.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.
*/
#include "adsinc.h"

//-----------------------------------------------------------------------------
static      int     real_precision      =  6;
static      int     int_radix           = 10;
static      int     long_radix          = 10;
static      char    *adsname_seperator  = ":";

//-----------------------------------------------------------------------------
// Use these buffers carefully, make sure no recursive usages of these
// buffers in this file. Like :
//
// void foo()
// {
//      bar( temp_buffer );
// }
//
// void bar( char* buf )
// {
//      strcpy( temp_buffer, "hello" );     // oops
//      strcat( temp_buffer, buf );
//
// }
//
static char temp_buffer[ 256 ];
static char temp_buffer1[ 256 ];

//-----------------------------------------------------------------------------
DXF_GROUP_INFO dxf_group_info[] =
{
    { DXF_PRIM_ENT_TEXT,    DXF_PRIM_ENT_TEXT_LOWER_1,  DXF_PRIM_ENT_TEXT_UPPER_1
        , Str2Str,      Str2Str,    "Primary Entity Text" }
    , { DXF_STRING1,        DXF_STRING_LOWER_1,         DXF_STRING_UPPER_1
        , Str2Str,      Str2Str,    "String" }
    , { DXF_PRIM_X,         DXF_PRIM_X_LOWER,           DXF_PRIM_X_UPPER
//        , ThreeD2Str,   Str2ThreeD,     "Primary X Coordinates" }
        , ThreeD2Str,   Str2ThreeD,     "Primary Coordinate" }
    , { DXF_OTHER_X,        DXF_OTHER_X_LOWER,          DXF_OTHER_X_UPPER
//        , ThreeD2Str,   Str2ThreeD,     "Coordinates" }
        , ThreeD2Str,   Str2ThreeD,     "Secondary Coordinate" }
    , { DXF_PRIM_Y,         DXF_PRIM_Y_LOWER,           DXF_PRIM_Y_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Primary Y Coordinates" }
    , { DXF_OTHER_Y,        DXF_OTHER_Y_LOWER,          DXF_OTHER_Y_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Y Coordinates" }
    , { DXF_PRIM_Z,         DXF_PRIM_Z_LOWER,           DXF_PRIM_Z_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Primary Z Coordinates" }
    , { DXF_OTHER_Z,        DXF_OTHER_Z_LOWER,          DXF_OTHER_Z_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Z Coordinates" }
    , { DXF_FLOAT_FACT,     DXF_FLOAT_FACT_LOWER_1,     DXF_FLOAT_FACT_UPPER_1
        , Double2Str,   Str2Double, "Scale Factor" }
    , { DXF_ANGLE,          DXF_ANGLE_LOWER,            DXF_ANGLE_UPPER
        , Double2Str,   Str2Double, "Angle" }
    , { DXF_FLOAT1,         DXF_FLOAT_LOWER_1,          DXF_FLOAT_UPPER_1
        , Double2Str,   Str2Double, "Floating Point" }
    , { DXF_COLOR_NUMBER,   DXF_COLOR_NUMBER_LOWER,     DXF_COLOR_NUMBER_UPPER
        , Int2Str,      Str2Int,    "Color Number" }
    , { DXF_INTEGER1,       DXF_INTEGER_LOWER_1,        DXF_INTEGER_UPPER_1
        , Int2Str,      Str2Int,    "Integer" }
    , { DXF_LONG,           DXF_LONG_LOWER,             DXF_LONG_UPPER
        , Long2Str,      Str2Long,    "Long Integer" }
    , { DXF_STRING2,       DXF_STRING_LOWER_2,        DXF_STRING_UPPER_2
        , Str2Str,      Str2Str,    "String" }
    , { DXF_FLOAT2,         DXF_FLOAT_LOWER_2,          DXF_FLOAT_UPPER_2
        , Double2Str,   Str2Double, "Floating Point" }
    , { DXF_INTEGER2,       DXF_INTEGER_LOWER_2,        DXF_INTEGER_UPPER_2
        , Int2Str,      Str2Int,    "Integer" }
    , { DXF_EXTRUSION_X,    DXF_EXTRUSION_X_LOWER,      DXF_EXTRUSION_X_UPPER
//        , ThreeD2Str,   Str2ThreeD,     "X Extrusion" }
        , ThreeD2Str,   Str2ThreeD,     "Extrusions" }
    , { DXF_EXTRUSION_Y,    DXF_EXTRUSION_Y_LOWER,      DXF_EXTRUSION_Y_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Y Extrusion" }
    , { DXF_EXTRUSION_Z,    DXF_EXTRUSION_Z_LOWER,      DXF_EXTRUSION_Z_UPPER
        , ThreeD2Str,   Str2ThreeD,     "Z Extrusion" }
    , { DXF_FLOAT3,         DXF_FLOAT_LOWER_3,          DXF_FLOAT_UPPER_3
        , Double2Str,   Str2Double, "Floating Point" }
    , { DXF_INTEGER3,       DXF_INTEGER_LOWER_3,        DXF_INTEGER_UPPER_3
        , Int2Str,      Str2Int,    "Integer" }
    , { DXF_STRING3,        DXF_STRING_LOWER_3,         DXF_STRING_UPPER_3
        , Str2Str,      Str2Str,    "String" }
    , { DXF_COMMENT_STRING, DXF_COMMENT_LOWER,          DXF_COMMENT_UPPER
        , Str2Str,      Str2Str,    "Comment" }
    , { DXF_STRING4,        DXF_STRING_LOWER_4,         DXF_STRING_UPPER_4
        , Str2Str,      Str2Str,    "String" }
    , { DXF_FLOAT4,         DXF_FLOAT_LOWER_4,          DXF_FLOAT_UPPER_4
        , Double2Str,   Str2Double, "Floating Point" }
    , { DXF_INTEGER4,       DXF_INTEGER_LOWER_4,        DXF_INTEGER_UPPER_4
        , Int2Str,      Str2Int,    "Integer" }
    , { DXF_UNKNOWN_GROUP,  DXF_UNKNOWN_LOWER,          DXF_UNKNOWN_UPPER
        , NULL,         NULL,       "Unknow" }
};

//-----------------------------------------------------------------------------
DXFGROUPCODE DXFGroupCode(int dxfcode)
{
    int group_index;

    for ( group_index = 0
        ; group_index < ARRAY_SIZE( dxf_group_info )
        ; group_index++ )
    {
        if ( dxfcode >= dxf_group_info[ group_index ].lower
            && dxfcode <= dxf_group_info[ group_index ].upper )
        {
            return dxf_group_info[ group_index ].dxfgroup;
        }
    }
    return DXF_UNKNOWN_GROUP;
}

//-----------------------------------------------------------------------------
char *DXFGroupCode2Str( struct resbuf* src, char *buffer )
{
    ASSERT( src != NULL && buffer != NULL );
    int dxfcode = src->restype;

    int group_index;

    for ( group_index = 0
        ; group_index < ARRAY_SIZE( dxf_group_info )
        ; group_index++ )
    {
        if ( dxfcode >= ( dxf_group_info[ group_index ] ).lower
            && dxfcode <= ( dxf_group_info[ group_index ] ).upper )
        {
            if ( ( *dxf_group_info[ group_index ].dxf2strfunc )( temp_buffer1, src ) )
            {
                wsprintf( buffer
                        , "%d( %s )\t%s"
                        , dxfcode
                        , dxf_group_info[ group_index ].string
                        , temp_buffer1 );
                return buffer;
            }
        }
    }
    return NULL;
}

//-----------------------------------------------------------------------------
char *ThreeD2Str( char* dst, struct resbuf* src )
{
    ASSERT( dst != NULL && src != NULL );

    dst[ 0 ] = '\0';
    for ( int i = 0; i < 3; i++ )
    {
        if ( _gcvt( src->resval.rpoint[ i ], real_precision, temp_buffer ) )
        {
            strcat( dst, temp_buffer );
            strcat( dst, "\t" );
        }
        else
        {
            ASSERT( 0 );
        }
    }
    return dst;
}

//-----------------------------------------------------------------------------
struct resbuf       *Str2ThreeD( struct resbuf* dst, char* src )
{
    ASSERT( 0 );    //shit...
    return NULL;
}

//-----------------------------------------------------------------------------
char*   Double2Str( char* dst, struct resbuf* src )
{
    ASSERT( dst != NULL && src != NULL );
    return _gcvt( src->resval.rreal, real_precision, dst );
}

//-----------------------------------------------------------------------------
struct resbuf*   Str2Double( struct resbuf* dst, char* src )
{
    ASSERT( dst != NULL && src != NULL );
    dst->resval.rreal = atof( src );

    return dst;
}

//-----------------------------------------------------------------------------
char*   Double2Str( char* dst, double src )
{
    ASSERT( dst != NULL );
    return _gcvt( src, real_precision, dst );
}

//-----------------------------------------------------------------------------
double*   Str2Double( double* dst, char* src )
{
    ASSERT( dst != NULL && src != NULL );
    *dst = atof( src );

    return dst;
}

//-----------------------------------------------------------------------------
char*   Int2Str( char* dst, struct resbuf* src )
{
    ASSERT( dst != NULL && src != NULL );

    _itoa( src->resval.rint, dst, int_radix );
    return dst;
}

//-----------------------------------------------------------------------------
struct resbuf*   Str2Int( struct resbuf* dst, char* src )
{
    ASSERT( dst != NULL && src != NULL );

    dst->resval.rint = atoi( src );
    return dst;
}

//-----------------------------------------------------------------------------
char*   Long2Str( char* dst, struct resbuf* src )
{
    ASSERT( dst != NULL && src != NULL );

    _ltoa( src->resval.rlong, dst, long_radix );
    return dst;
}

//-----------------------------------------------------------------------------
struct resbuf*   Str2Long( struct resbuf* dst, char* src )
{
    ASSERT( dst != NULL && src != NULL );

    dst->resval.rlong = atol( src );
    return dst;
}

//-----------------------------------------------------------------------------
char*   Str2Str( char* dst, struct resbuf* src )
{
    ASSERT( dst != NULL && src != NULL && src->resval.rstring != NULL );

    strcpy( dst, src->resval.rstring );
    return dst;
}

//-----------------------------------------------------------------------------
struct resbuf*   Str2Str( struct resbuf* dst, char* src )
{
    ASSERT( dst != NULL && src != NULL && dst->resval.rstring != NULL );

    strcpy( dst->resval.rstring, src );
    return dst;
}

//-----------------------------------------------------------------------------
char* AdsName2Str( char* dst, struct resbuf *src )
{
    ASSERT( dst != NULL 
            && src != NULL 
            && src->resval.rstring != NULL );

    _ltoa( src->resval.rlname[ 0 ], dst, long_radix );
    _ltoa( src->resval.rlname[ 1 ], temp_buffer, long_radix );
    strcat( dst, adsname_seperator );
    strcat ( dst, temp_buffer );
    return dst;
}

//-----------------------------------------------------------------------------
struct resbuf* Str2AdsName( struct resbuf* dst, char *src)
{
    char first_long[ 256 ];

    ASSERT( dst != NULL 
            && src != NULL 
            && dst->resval.rstring != NULL );

    char *second_long = strstr( src, adsname_seperator );
    strncpy( first_long, src, second_long - src );
    ASSERT ( second_long != NULL );
    second_long++;
    ASSERT ( second_long != NULL );

    dst->resval.rlname[ 0 ] = atol( first_long );
    dst->resval.rlname[ 1 ] = atol( second_long );
    return dst;
}

//-----------------------------------------------------------------------------
char* AdsName2Str( char* dst, ads_name& src )
{
    ASSERT( dst != NULL 
            && src != NULL
            && src[ 0 ] != NULL 
            && src[ 1 ] != NULL );

    _ltoa( src[ 0 ], dst, long_radix );
    _ltoa( src[ 1 ], temp_buffer, long_radix );
    strcat( dst, adsname_seperator );
    strcat ( dst, temp_buffer );
    return dst;
}

//-----------------------------------------------------------------------------
ads_name& Str2AdsName( ads_name& dst, char *src)
{
    char first_long[ 256 ];

    ASSERT( dst != NULL 
            && src != NULL );

    char *second_long = strstr( src, adsname_seperator );
    ASSERT ( second_long != NULL );
    strncpy( first_long, src, second_long - src );
    second_long++;
    ASSERT ( second_long != NULL );

    dst[ 0 ] = atol( first_long );
    dst[ 1 ] = atol( second_long );
    return dst;
}

