/* 
    SSCLNT.H -
    
    This file:

        Declares spread sheet client connection class in a ADS
        application.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef SSCLNT_H
#define SSCLNT_H

#include "ddeinc.h"
//-----------------------------------------------------------------------------

#define         POKE_BUF_SIZE       4*1024

//-----------------------------------------------------------------------------
// Watch out!
// The server now is SS_SERVER_INFO instead of SERVER_INFO
//
class SS_CLIENT_CONNECTION : public DDE_CLIENT_CONNECTION
{
public:
    virtual BOOL                EndSend();

                                SS_CLIENT_CONNECTION( SS_SERVER_INFO& );
                                ~SS_CLIENT_CONNECTION();

private:
    BASIC_CPP_STUFF(SS_CLIENT_CONNECTION)
};

//-----------------------------------------------------------------------------
class EXCEL_CLIENT_CONNECTION : public SS_CLIENT_CONNECTION
{
public:
                                EXCEL_CLIENT_CONNECTION( SS_SERVER_INFO& server)
                                :SS_CLIENT_CONNECTION( server ){}
    virtual BOOL                InitItem( ADS_STRING& item_name );
private:
    BASIC_CPP_STUFF(EXCEL_CLIENT_CONNECTION)
};
#endif
