/* 
    DDEINFO.CPP -
    
    This file:

        Defines specific DDE server information.  Only ACAD and
        Microsoft EXCEL server info is defined.


    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

/******************************************************************************
*                                                                             *
*                    SERVER_INFO member functions                             *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
void SERVER_INFO::Start()
{
    if ( exepath[0]== '\0' || WinExec( exepath.CString(), SW_SHOW ) <= 32 )
    {
        ::MessageBox( GetFocus()
                    , "Can not start the DDE server"
                    , "Warning", MB_OK );
    }
}

//-----------------------------------------------------------------------------
BOOL SERVER_INFO::Ready( HSZ service, HSZ topic, HSZ item )
{
    return TRUE;
}

//-----------------------------------------------------------------------------
SERVER_INFO::SERVER_INFO( char *regkey, DDESERVER id )
{
    server_id = id;

    exepath = "";
    
    HKEY    hKey;
    LONG    cb = 256;

    if ( RegOpenKey( HKEY_CLASSES_ROOT
        , regkey
        , &hKey ) == ERROR_SUCCESS )
    {
        if ( RegQueryValue( hKey, "server", ( char * )exepath.CString(), &cb ) != ERROR_SUCCESS )
        {
            exepath = "";
        }
        RegCloseKey( hKey );
    }
}

//-----------------------------------------------------------------------------
SERVER_INFO::~SERVER_INFO()
{
}

/******************************************************************************
*                                                                             *
*                   SS_SERVER_INFO member functions                           *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
SS_SERVER_INFO::SS_SERVER_INFO( char *regkey 
                                , int _max_row
                                , int _max_col 
                                , int _cur_row
                                , int _cur_col 
                                , char *_ssrow
                                , char *_sscol
                                , char *_ssdelim
                                , char *_row_sep
                                , char *_col_sep 
                                , DDESERVER id ) : SERVER_INFO( regkey, id )
{
    cur_row = _cur_row;
    cur_col = _cur_col;
    max_row = _max_row;
    max_col = _max_col;

    ssrow =  _ssrow;
    sscol = _sscol;
    ssdelim = _ssdelim;
    row_seperator = _row_sep;
    col_seperator = _col_sep;
    seperators = row_seperator + col_seperator;
}

//-----------------------------------------------------------------------------
SS_SERVER_INFO::~SS_SERVER_INFO()
{
}

//-----------------------------------------------------------------------------
SS_SERVER_INFO::SS_SERVER_INFO( const SS_SERVER_INFO& src )
                                : SERVER_INFO( src )
{
    cur_row = src.cur_row;
    cur_col = src.cur_col;
    max_row = src.max_row;
    max_col = src.max_col;

    ssrow = src.ssrow;
    sscol = src.sscol;
    ssdelim = src.ssdelim;
    row_seperator = src.row_seperator;
    col_seperator = src.col_seperator;
    seperators = row_seperator + col_seperator;
}

//-----------------------------------------------------------------------------
SS_SERVER_INFO& SS_SERVER_INFO::operator=( const SS_SERVER_INFO& src )
{
    SERVER_INFO::operator=( src );
    cur_row = src.cur_row;
    cur_col = src.cur_col;
    max_row = src.max_row;
    max_col = src.max_col;

    ssrow = src.ssrow;
    sscol = src.sscol;
	ssdelim = src.ssdelim;

    row_seperator = src.row_seperator;
    col_seperator = src.col_seperator;
    seperators = row_seperator + col_seperator;

    return *this;
}                            
