/* 
    DDECONX.H -
    
    This file:

        Declares pure virtual DDE connection object, DDE_CONNECTION. 

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef DDECONX_H
#define DDECONX_H

#include "ddeinc.h"

//-----------------------------------------------------------------------------
class DDE_CONNECTION;

//-----------------------------------------------------------------------------
enum LINK_TYPE
{
    HOT_LINK
    , WARM_LINK
    , COLD_LINK
};

//-----------------------------------------------------------------------------
class DDE_CONNECTION : public ADS_OBJ
{
    friend                      DDE_HCONV;
    friend                      DDE_ITEM;
    friend                      DDE_TOPIC;
    friend                      DDE_SERVICE;
    friend                      DDE_STRING_HANDLE;

protected:
    DWORD                       transfer_result;
    UINT                        cur_format;

    LINK_TYPE                   linkage;
    BOOL                        linking;

    BOOL                        connecting;

    DDE_HCONV                   *cur_conv;

    DDE_SERVICE                 *dde_service;
    DDE_TOPIC                   *dde_topic;
    DDE_ITEM                    *dde_item;

    LPBYTE                      cur_item_data;
    int                         item_len;

public:
                                DDE_CONNECTION();

                                // to initialize dde_service etc.
    virtual BOOL                Init( ADS_STRING& default_service_name 
                                    , ADS_STRING& default_topic_name
                                    , ADS_STRING& default_item_name );
    virtual BOOL                InitService( ADS_STRING& service_name );
    virtual BOOL                InitTopic( ADS_STRING& topic_name );
    virtual BOOL                InitItem( ADS_STRING& item_name );

                                ~DDE_CONNECTION();

    virtual BOOL                Valid();
    virtual BOOL                SetupConnection() = 0;
    virtual BOOL                RemoveConnection();

    virtual BOOL                Link() = 0;
    virtual BOOL                Unlink() = 0;

    HSZ                         DDEItem() { return dde_item->Handle(); }
    HSZ                         DDETopic(){ return dde_topic->Handle(); }
    HSZ                         DDEService(){ return dde_service->Handle(); }

private:
    BASIC_CPP_STUFF(DDE_CONNECTION)
};

//
//  inline functions
//

#endif
