/* 
    DDECONX.CPP -
    
    This file:

        Defines pure virtual DDE connection object, DDE_CONNECTION. 

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

//-----------------------------------------------------------------------------
DDE_CONNECTION::DDE_CONNECTION()
{
    dde_service         = NULL;
    dde_topic           = NULL;
    dde_item            = NULL;
    linkage             = HOT_LINK;
    cur_conv            = new DDE_HCONV();
    linking             = FALSE;
    cur_format          = CF_TEXT;
    connecting          = FALSE;
}

//-----------------------------------------------------------------------------
DDE_CONNECTION::~DDE_CONNECTION()
{
    if ( dde_service ) delete dde_service; dde_service = NULL;
    if ( dde_topic ) delete dde_topic; dde_topic = NULL;
    if ( dde_item ) delete dde_item; dde_item = NULL;
    delete cur_conv;
}

//-----------------------------------------------------------------------------
BOOL DDE_CONNECTION::Valid()
{
    return ( cur_conv && cur_conv->Valid()
            && dde_service && dde_service->Valid()
            && dde_topic && dde_topic->Valid()
            && dde_item && dde_item->Valid() );
}

//-----------------------------------------------------------------------------
BOOL DDE_CONNECTION::RemoveConnection()
{
    if ( linking )
    {
        Unlink();
    }
    return cur_conv->DisConnect();
}

//-----------------------------------------------------------------------------
//
// This is used to initialize all variables in the class that are
// depending on the construction of the class, like this pointer.
//
BOOL DDE_CONNECTION::Init( ADS_STRING& default_service_name 
                                    , ADS_STRING& default_topic_name
                                    , ADS_STRING& default_item_name )
{
    return ( InitService( default_service_name ) 
            && InitTopic( default_topic_name )
            && InitItem( default_item_name ) );
}

//-----------------------------------------------------------------------------
BOOL DDE_CONNECTION::InitService( ADS_STRING& service_name )
{
    ASSERT( dde_service == NULL );
    dde_service = new DDE_SERVICE( this );
    ASSERT( dde_service );
    return ( dde_service->NewHandle( service_name ) != NULL );
}

//-----------------------------------------------------------------------------
BOOL DDE_CONNECTION::InitTopic( ADS_STRING& topic_name )
{
    ASSERT( dde_topic == NULL );
    dde_topic = new DDE_TOPIC( this );
    ASSERT( dde_topic );
    return ( dde_topic->NewHandle( topic_name ) != NULL );
}
//-----------------------------------------------------------------------------
BOOL DDE_CONNECTION::InitItem( ADS_STRING& item_name )
{
    ASSERT( dde_item == NULL );
    dde_item = new DDE_ITEM( this );
    ASSERT( dde_item );
    return ( dde_item->NewHandle( item_name ) != NULL );
}

