/* 
    CONXCLNT.H -
    
    This file:

        Declares DDE_CLIENT_CONNECTION object which is used to
        support DDE client connection to talk to the servers.

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#ifndef CONXCLNT_H
#define CONXCLNT_H

#include "ddeinc.h"

//-----------------------------------------------------------------------------
class DDE_CLIENT_CONNECTION : public DDE_CONNECTION
{
protected:
    SERVER_INFO                 *server;

    ADS_STRING                  sending_string;
    virtual BOOL                Flushsendingstring();

public:
    virtual BOOL                BeginSend();
    virtual BOOL                EndSend();
    virtual BOOL                SendString( ADS_STRING& string );
    virtual BOOL                SendString( LPBYTE string )
                                { 
                                    return SendString( ADS_STRING( (char*)string ) );
                                }

    virtual WORD                ExcuteCommand( char* cmd );

                                DDE_CLIENT_CONNECTION();
    virtual                     ~DDE_CLIENT_CONNECTION();

                                DDE_CLIENT_CONNECTION( const DDE_CLIENT_CONNECTION &);
                                DDE_CLIENT_CONNECTION( SERVER_INFO& server );

    static HDDEDATA CALLBACK    ClientCallBack(WORD wType
                                                , WORD wFmt
                                                , HCONV hConv
                                                , HSZ hsz1
                                                , HSZ hsz2
                                                , HDDEDATA hData
                                                , DWORD lData1
                                                , DWORD lData2);
    virtual HDDEDATA            XAdvdata( WORD wFmt
                                            , HSZ hsz1
                                            , HSZ hsz2
                                            , HDDEDATA hData );
    virtual HDDEDATA            XDisconnect( HSZ hsz1
                                            , DWORD lData2);
    virtual HDDEDATA            XError( DWORD lData1 );
    virtual HDDEDATA            XRegister(  HSZ hsz1
                                            , HSZ hsz2 );
    virtual HDDEDATA            XUnregister(  HSZ hsz1
                                            , HSZ hsz2 );
    virtual HDDEDATA            XXactComplete( WORD wFmt
                                            , HSZ hsz1
                                            , HSZ hsz2
                                            , HDDEDATA hData
                                            , DWORD lData1
                                            , DWORD lData2);

    virtual BOOL                Valid()
                                {
                                    return ( DDE_CONNECTION::Valid() 
                                            && server->Valid() );
                                }

    virtual BOOL                SetupConnection();
    BOOL                        RemoveConnection();

    virtual BOOL                Link();
    virtual BOOL                Unlink();

    virtual BOOL                CreateDDEData( HDDEDATA hdata );
    virtual BOOL                CreateDDEData( const LPBYTE src_ddedata
                                , DWORD src_data_len );
    virtual void                ReleaseDDEData();
    LPBYTE                      ddedata;
    DWORD                       data_len;
    BOOL                        ModifyDDEEntity( struct resbuf *rb );

    virtual int                 SendAdsAllEntities();
    virtual int                 SendAdsEntity( struct resbuf* );
    virtual int                 SendAdsTable( char *tbl_name );
    virtual int                 SendAdsAllTables();
    virtual void                RequestADSUpdate()
                                {
               ( DDE_GLOBAL::acad_connection )->ExcuteCommand( "(ACADDDEFUN)\n" );
                                }
};

#endif
