/* 
    CONXCLNT.CPP -
    
    This file:

        Defines DDE_CLIENT_CONNECTION object which is used to
        support DDE client connection to talk to the servers.
        

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include "ddeinc.h"

//-----------------------------------------------------------------------------
ADS_INSTANCE    client_this;
#ifdef DDEADS_DBG
static char     dbg_string[256];
#endif


//-----------------------------------------------------------------------------
DDE_CLIENT_CONNECTION::DDE_CLIENT_CONNECTION()
{
    SetUserBrk( FALSE );
    transfer_result = 0;
    ddedata = NULL;
}


//-----------------------------------------------------------------------------
DDE_CLIENT_CONNECTION::DDE_CLIENT_CONNECTION( SERVER_INFO& _server )
{
    server = new SERVER_INFO( _server );
    ddedata = NULL;
}

//-----------------------------------------------------------------------------
DDE_CLIENT_CONNECTION::~DDE_CLIENT_CONNECTION()
{
    if ( server ) 
    { 
        delete server; 
    }
    sending_string = "";

    //
    // Before InstId becomes invalid RemoveConnection has to be
    // called first.  Same applys to the DDEData
    //
    RemoveConnection();
}

//-----------------------------------------------------------------------------
WORD DDE_CLIENT_CONNECTION::ExcuteCommand( char* cmd )
{
    ASSERT ( cmd != NULL );
    DdeClientTransaction( (LPBYTE)cmd
                        , strlen ( cmd )
                        , *cur_conv
                        , NULL      // ignored
                        , 0
                        , XTYP_EXECUTE
                        , TIMEOUT_ASYNC
                        , &transfer_result);
    transfer_result = DdeGetLastError( DDE_GLOBAL::GetInstId() );
    if ( transfer_result != DMLERR_NO_ERROR )
    {
        return 0;
    }
    return 1;                        
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::RemoveConnection()
{
    if ( client_this.RemoveInstance( this ) )
    {
        if ( DDE_CONNECTION::RemoveConnection() )
        {
            ReleaseDDEData();
            connecting = FALSE;
            return TRUE;
        }
    }
    return FALSE;
}

//-----------------------------------------------------------------------------
//
// Used to set up the cur_conv variable, the conversation handle variable
//
BOOL DDE_CLIENT_CONNECTION::SetupConnection()
{
    RemoveConnection();
    CONVCONTEXT     tempCCFilter = 
                    { 
                        sizeof(CONVCONTEXT)
                        , 0
                        , 0
                        , 0
                        , 0L
                        , 0L
                        , {
                            sizeof(SECURITY_QUALITY_OF_SERVICE)
                            , SecurityImpersonation
                            , SECURITY_STATIC_TRACKING
                            , TRUE
                          }
                    };
    if ( cur_conv->NewConv( this, server, &tempCCFilter ) )
    {
        client_this.AddInstanceIndex( this, *cur_conv );
        connecting = TRUE;
        return TRUE;
    }
    
    return FALSE;
}

//-----------------------------------------------------------------------------
//
// Flushsendingstring() uses the old service and topic handle, only
// item has been changed.
//
BOOL DDE_CLIENT_CONNECTION::Flushsendingstring()
{
    if ( sending_string.Valid() && sending_string.Length() != 0 )
    {
        //
        // To be used by DDEItem()
        //
        dde_item->ConstructDDEString( sending_string );
        ASSERT( DDEItem() != NULL && (HCONV)*cur_conv );

        DdeClientTransaction( ( LPBYTE )sending_string.CString()
                        , sending_string.Length()
                        , *cur_conv
                        , DDEItem()
                        , cur_format
                        , XTYP_POKE
                        , TIMEOUT_ASYNC
                        , &transfer_result);
        transfer_result = DdeGetLastError( DDE_GLOBAL::GetInstId() );
        if ( transfer_result != DMLERR_NO_ERROR )
        {
            return FALSE;
        }
        /*
            According to the documentation, result should have DDE_FACK set
            if operations success'd but, hell!
    
        if ( !( transfer_result & (DWORD)DDE_FACK ) )
        {
            MessageBox( GetFocus(), "POKE operation failed!", "INFO", MB_OK);
            return FALSE;
        }
        else
        {
            return TRUE;
        }
        */
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::SendString( ADS_STRING& new_string )
{
    if ( ( new_string.Length() + sending_string.Length() ) < POKE_BUF_SIZE )
    {
        sending_string += new_string;
        return TRUE;
    }
    else
    {
        Flushsendingstring();
        sending_string = new_string;
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::BeginSend()
{
    if ( !connecting )
    {
        SetupConnection();
    }

    sending_string = "";
    ASSERT ( sending_string.Valid() != NULL );
    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::EndSend()
{
    //
    // If there are information left in the buffer, send it!
    //
    if ( sending_string.Valid() && sending_string.Length() == 0 )
    {
        return TRUE;
    }
    Flushsendingstring();
    sending_string = "";

    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::Unlink()
{
    if ( !linking )
    {
        return TRUE;
    }

    if ( !cur_conv->Valid() )
    {
        return FALSE;
    }
    
    DdeClientTransaction( NULL
                        , 0
                        , *cur_conv
                        , dde_item->Range()
                        , cur_format
                        , XTYP_ADVSTOP
                        , TIMEOUT_ASYNC
                        , &transfer_result  );
    
    linking = FALSE;
    transfer_result = DdeGetLastError( DDE_GLOBAL::GetInstId() );
    if ( transfer_result != DMLERR_NO_ERROR )
    {
        return FALSE;
    }
    return TRUE;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::Link()
{
    // Only supports hot link for now. ?????
    ASSERT ( linkage == HOT_LINK );

    if ( linking )
    {
        Unlink();
    }

    if ( !cur_conv->Valid() )
    {
        //
        // Use the default service and topic name
        //
        SetupConnection();
        return FALSE;
    }

    if ( DdeClientTransaction( NULL
                                , 0
                                , *cur_conv
                                , dde_item->Range()
                                , CF_TEXT
                                , XTYP_ADVSTART
                                , TIMEOUT_ASYNC
                                , &transfer_result  ) == TRUE )
    {
        linking = TRUE;
    }                                
    transfer_result = DdeGetLastError( DDE_GLOBAL::GetInstId() );

    ASSERT( transfer_result == DMLERR_NO_ERROR );

    return linking;
}

//-----------------------------------------------------------------------------
HDDEDATA CALLBACK DDE_CLIENT_CONNECTION::ClientCallBack(WORD wType
                                                        , WORD wFmt
                                                        , HCONV hConv
                                                        , HSZ hsz1
                                                        , HSZ hsz2
                                                        , HDDEDATA hData
                                                        , DWORD lData1
                                                        , DWORD lData2)
{
    if ( hConv == NULL )
    {
        return NULL;
    }

    DDE_CLIENT_CONNECTION* This;
    This = ( DDE_CLIENT_CONNECTION* )( client_this.This( hConv ) );

    if ( This == NULL )
    {
        return NULL;
    }
    
#ifdef DDEADS_DBG
    wsprintf( dbg_string
            , " DDE_CLIENT_CONNECTION callback: this = %lx"
            , This );
    OutputDebugString( dbg_string );
#endif
    switch (wType) 
    {
        /*
            As a client:
        */
        case XTYP_ADVDATA:      // hsz1 = topic, hsz2 = item
        {
            return This->XAdvdata( wFmt, hsz1, hsz2, hData );
        }
        break;
        
        case XTYP_DISCONNECT:   // hsz1 = not used, hsz2 not used
        {
            return This->XDisconnect( hsz1, lData2 );
        }
        break;
        
        case XTYP_ERROR:        // hsz1 = not used, hsz2 not used
        {
            return This->XError( lData1 );
        }
        break;
        
        case XTYP_REGISTER:     // hsz1 = base service name
                                // hsz2 = instance-specific service name
        {
            return This->XRegister( hsz1, hsz2 );
        }
        break;
        
        case XTYP_UNREGISTER:       // hsz1 = base service name
                                    // hsz2 = instance-specific service name
        {
            return This->XUnregister( hsz1, hsz2 );
        }
        break;
        
        case XTYP_XACT_COMPLETE:    // hsz1 = topic, hsz2 = item
        {
            return This->XXactComplete( wFmt, hsz1, hsz2, hData, lData1, lData2 );
        }
        break;
    }
    return TRUE;
}                                

//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XAdvdata( WORD wFmt
                                        , HSZ hsz1
                                        , HSZ hsz2
                                        , HDDEDATA hData )
{
    if ( linking 
        && hsz1 == DDETopic()
        && hsz2 == DDEItem()
        && wFmt == cur_format )
    {
        CreateDDEData( hData );
        RequestADSUpdate();
        // MessageBox( GetFocus(), "XAdvdata called", "INFO", MB_OK );
        return DDE_FACK;
    }
    return DDE_FNOTPROCESSED;
}

//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XDisconnect( HSZ hsz1
                                        , DWORD lData2)
{
    RemoveConnection();
    return 1;
}
                                        
//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XError( DWORD lData1 )
{
    return 1;
}

//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XRegister(  HSZ hsz1
                                        , HSZ hsz2 )
{
    return 1;
}
                                        
//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XUnregister(  HSZ hsz1
                                        , HSZ hsz2 )
{
    return 1;
}
                                        
//-----------------------------------------------------------------------------
HDDEDATA DDE_CLIENT_CONNECTION::XXactComplete( WORD wFmt
                                        , HSZ hsz1
                                        , HSZ hsz2
                                        , HDDEDATA hData
                                        , DWORD lData1
                                        , DWORD lData2)
{
    return 0;
}                                        

//-----------------------------------------------------------------------------
void DDE_CLIENT_CONNECTION::ReleaseDDEData()
{
    if ( ddedata )
    {
        delete ddedata;
        data_len = 0;
        ddedata = NULL;
    }
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::CreateDDEData( const LPBYTE src_ddedata
                                        , DWORD src_data_len )
{
    ReleaseDDEData();
    if ( !src_ddedata || src_data_len <= 0 )
    {
        return FALSE;
    }
    ddedata = new BYTE [ src_data_len ];
    data_len = src_data_len;
    if ( ddedata )
    {
        if ( memcpy( ddedata, src_ddedata, data_len ) != ddedata )
        {
            delete ddedata;
            data_len = 0;
            return FALSE;
        }
        else
        {
            return TRUE;
        }
    }    
    return FALSE;
}

//-----------------------------------------------------------------------------
//
// This function should be called from DDEClientCallBack() to save the
// hData which then can be used for ADS purposes.
//
BOOL DDE_CLIENT_CONNECTION::CreateDDEData( HDDEDATA hdata )
{
    LPBYTE  tempptr;
    DWORD   len;
    BOOL    ret_val;
    
    tempptr = DdeAccessData( hdata, &len );
    
    if ( tempptr && len )
    {
        ret_val = CreateDDEData( tempptr, len );
        DdeUnaccessData( hdata );
        return ret_val;
    }
    else
    {
        return FALSE;
    }
}

//-----------------------------------------------------------------------------
int DDE_CLIENT_CONNECTION::SendAdsTable( char *tbl_name )
{
    char            *temp_buf;
    struct resbuf   *rb = NULL;
    ADS_TABLE_OBJ   *temp_obj;
    BOOL            rewind = TRUE;
    int             subtotal = 0;
    
    temp_buf = new char[ GENERAL_BUFFER_SIZE ];
    wsprintf( temp_buf, "\nSending table %s, table #: ", tbl_name );
    ads_printf( temp_buf );
    ShowLife();
    ShowLife( 0 );

    for ( rewind = TRUE
        ; UserBrk() != TRUE && ( rb = ads_tblnext( tbl_name, rewind ) ) != NULL
        ; rewind = FALSE )
    {
        subtotal++;
        ShowLife( subtotal );
        temp_obj = MakeAdsTable( rb );
        if ( temp_obj )
        {
            if ( SendString( temp_obj->FormatTableString() ) != TRUE )
            {
                subtotal = -1;
                break;
            }
            DeleteAdsTable( temp_obj );
        }
        ads_relrb( rb );
        rb = NULL;
    }
    if ( rb != NULL )
    {
        ads_relrb( rb );
    }
    return subtotal;
}

//-----------------------------------------------------------------------------
int DDE_CLIENT_CONNECTION::SendAdsAllTables()
{
    int total = 0;

    total =   SendAdsTable( "LAYER" )
            + SendAdsTable( "LTYPE" )
            + SendAdsTable( "VIEW" )
            + SendAdsTable( "STYLE" )
            + SendAdsTable( "BLOCK" )
            + SendAdsTable( "UCS" )
            + SendAdsTable( "DIMSTYLE" )
            + SendAdsTable( "VPORT" )
            + SendAdsTable( "APPID" );
    return total;
}

//-----------------------------------------------------------------------------
int DDE_CLIENT_CONNECTION::SendAdsAllEntities()
{
    int         total_ent = 0;
    ads_name    ename;

    if ( ads_entnext( NULL, ename ) != RTERROR )
    {
        ads_printf("\nSending Ads entity #: ");
        ShowLife();
        do
        {
            total_ent++;
            struct resbuf *rb;
            rb = ads_entget( ename );
            if ( ShowLife( total_ent ) )
            {
                if ( SendAdsEntity( rb ) < 0 )
                {
                    // Send entity failed
                    return total_ent;
                }
            }
            ads_relrb( rb );
        }
        while ( UserBrk() == FALSE && ads_entnext( ename, ename ) != RTERROR );
    }
    return total_ent;
}

//-----------------------------------------------------------------------------
// Given the head of a resbuf of an entity, this function sends out the 
// entity to the spread sheet and returns the number of entity sent out
//
int DDE_CLIENT_CONNECTION::SendAdsEntity( struct resbuf *rb )
{
    static  entity = 0;

    if ( rb == NULL 
        || rb->restype != -1 
        || rb->rbnext == NULL 
        || rb->rbnext->restype != 0 )
    {
        return -1;
    }

    ADS_ENT_OBJ* temp_obj = MakeAdsEntity( rb );
    if ( temp_obj )
    {
        if ( SendString( temp_obj->FormatEntityString() ) != TRUE )
        {
            entity = -1;
        }
        DeleteAdsEntity( temp_obj );
    }
    else
    {
        SendString( (ADS_STRING)"\n\n\t!!!!! Entiity not supported !!!!!\n\n" );
        entity = -1;
    }

    return entity;
}

//-----------------------------------------------------------------------------
BOOL DDE_CLIENT_CONNECTION::ModifyDDEEntity( struct resbuf *rb )
{
    BOOL entity_modified = FALSE;

    if ( rb != NULL && ddedata != NULL )
    {
        ADS_ENT_OBJ* temp_obj = MakeAdsEntity( rb );
        if ( temp_obj )
        {
            char *temp_buf = new char[ 256 ];
            temp_obj->GetEntityName( temp_buf, 256 );
            temp_obj->FormatEntityString();
            char *temp_ptr = strstr( (char*)ddedata
                                   , temp_obj->formatstring.CString() );
            //
            // temp_ptr is pointing at the data from DDE importing
            // entity if it is not NULL, otherwise some weird
            // format in the DDE data has encounter'd
            //
            delete temp_buf;
        }
    }

    return entity_modified;
}


