/* 
    DDEADS.CPP -
    
    This file:

        Declares DDE functions to simulate the DDEADS functions
        in R12.  These functions are not fully implemented, they
        are only used to show the usage of DDE classes.

        A fully implemented C version of DDEADS is provided.
        This file is compiled as DDEADSPP.EXE.

    Function:

    (xload "ddeadspp")  
    (ddedrawing) Poke current tables and entities to EXCEL.


    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.

*/
#include    "ddeads.h"

//-----------------------------------------------------------------------------
ADS_FUNC_INFO       app_funs[] = 
{
/*                                                                    */
/*      Function                               Type            Name   */
/*                                                                    */
  ADS_FUNC_INFO( ADS_FUNC( fddedlgstart ),   ADS_VOID_FUNC,  "DDEDLGSTART"   )
, ADS_FUNC_INFO( ADS_FUNC( fddedialog ),     ADS_VOID_FUNC,  "DDEDIALOG"     )
, ADS_FUNC_INFO( ADS_FUNC( fddedrawing ),    ADS_INT_FUNC,   "DDEDRAWING"    )
, ADS_FUNC_INFO( ADS_FUNC( fddeblocks ),     ADS_INT_FUNC,   "DDEBLOCKS"     )
, ADS_FUNC_INFO( ADS_FUNC( fddesset ),       ADS_INT_FUNC,   "DDESSET"       )
, ADS_FUNC_INFO( ADS_FUNC( fddeupdate ),     ADS_INT_FUNC,   "DDEUPDATE"     )
, ADS_FUNC_INFO( ADS_FUNC( fddeformat ),     ADS_INT_FUNC,   "DDEFORMAT"     )
, ADS_FUNC_INFO( ADS_FUNC( fddedefaults ),   ADS_INT_FUNC,   "DDEDEFAULTS"   )
, ADS_FUNC_INFO( ADS_FUNC( doddetransfer ),  ADS_INT_FUNC,   "ACADDDEFUN"    )
};

/******************************************************************************
*                                                                             *
*                        DDEADS_APP member functions                          *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
//
// return TRUE if any of the entities changed
//
BOOL DDEADS_APP::ImportDrawing()
{
    ads_name    ename;
    int         total_ent = 0;
    BOOL        ret_val = FALSE;

    if ( !CurChannel() )
    {
        return FALSE;
    }
    //
    // Entities
    //
    if ( ads_entnext( NULL, ename ) != RTERROR )
    {
        ads_printf( "\nCheck Ads entity #: " );
        ShowLife();
        do
        {
            total_ent++;
            struct resbuf *rb;
            rb = ads_entget( ename );
            if ( ShowLife( total_ent ) )
            {
                if ( CurChannel()->ModifyDDEEntity( rb ) > 0 )
                {
                    ret_val = TRUE;
                }
            }
            ads_relrb( rb );
        }
        while ( UserBrk() == FALSE && ads_entnext( ename, ename ) != RTERROR );
    }
    ads_printf( "\nDone!\n");
    return ret_val;
}

//-----------------------------------------------------------------------------
BOOL DDEADS_APP::StartHotLink()
{
    return CurChannel()->Link();
}

//-----------------------------------------------------------------------------
int DDEADS_APP::ExportDrawing()
{
    if ( !CurChannel() )
    {
        DDE_CLIENT_CONNECTION *conx;// = DDE_GLOBAL::excel_connection;
        conx = new EXCEL_CLIENT_CONNECTION ( *( DDE_GLOBAL::excel_server_info ) );
        AddChannel( conx );

        DDE_CLIENT_CONNECTION *cur = CurChannel();

        cur->Init( ADS_STRING( "Excel" )
                    , ADS_STRING( "Sheet1" )
                    , ADS_STRING( "R1C1" ) );
        cur->SetupConnection();
    }
    if ( CurChannel()->BeginSend() == TRUE )
    {
        int  total_ent = 0;
        char temp_buf[ 256 ];

        ads_printf( "\nSend Ads tables to spread sheet\n" );
        int total_table = CurChannel()->SendAdsAllTables();
        wsprintf( temp_buf, "\nDone, number of tables sent: %d", total_table );
        ads_printf( temp_buf );
    
        ads_printf( "\nSend Ads entities to Spread sheet\n" );
        total_ent = CurChannel()->SendAdsAllEntities();
        ads_printf( "\nDone, number of entities sent: " );
    
        CurChannel()->EndSend();
        return total_ent;
    }
    else
    {
        return -1;
    }
}

//-----------------------------------------------------------------------------
DDEADS_APP::DDEADS_APP( int argc, char **argv ) 
                    : ADS_APP( argc, argv )
{
    for ( int i = 0; i < ARRAY_SIZE( app_funs ); i++ )
    {
        if ( InsertExternFunc( app_funs[i] ) == -1 )
        {
            return;
        }
    }
}


/******************************************************************************
*                                                                             *
*                        DDEADS exported "C" functions                        *
*                                                                             *
******************************************************************************/
//----------------------------------------------------------------------------
int     doddetransfer( struct resbuf * )
{
    ads_printf( "doddetranfer called\n" );
    DDEADS_APP  *app = ( DDEADS_APP* )GetAdsApp();

    app->ImportDrawing();

    return 0;
}

//-----------------------------------------------------------------------------
void fddedlgstart( struct resbuf * )
{
    ads_printf( "fddedlgstart called" );
}

//-----------------------------------------------------------------------------
void fddedialog( struct resbuf * )
{
    ads_printf( "fddedialog called" );
}

//-----------------------------------------------------------------------------
int fddeblocks( struct resbuf * )
{
    ads_printf( "fddeblocks called" );
    return 1;
}

//-----------------------------------------------------------------------------
int fddesset( struct resbuf * )
{
    ads_printf( "fddesset called" );
    return 1;
}

//-----------------------------------------------------------------------------
int fddeupdate( struct resbuf * )
{
    ads_printf( "fddeupdate called" );
    return 1;
}

//-----------------------------------------------------------------------------
int fddeformat( struct resbuf * )
{
    ads_printf( "fddeformat called" );
    return 1;
}

//-----------------------------------------------------------------------------
int fddedefaults( struct resbuf * )
{
    ads_printf( "fddedefaults called" );
    return 1;
}

//-----------------------------------------------------------------------------
int fddedrawing( struct resbuf * )
{
    int total_ent = 0;

    DDEADS_APP  *app = ( DDEADS_APP* )GetAdsApp();
    if ( total_ent = app->ExportDrawing() )
    {
        app->StartHotLink();
    }
    return total_ent;
}

/******************************************************************************
*                                                                             *
*                                 CHANNELS                                    *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
int CHANNELS::Add( DDE_CLIENT_CONNECTION* new_connx )
{
    CLIENT_CHANNEL* new_chnl = new CLIENT_CHANNEL( new_connx );
    
    if ( tail )
    {
        tail->next = new_chnl;
        tail = new_chnl;
        new_chnl = NULL;
    }
    else// first one
    {
        tail = new_chnl;
        head = tail;
        current = head;
    }
    return ++count;
}

//-----------------------------------------------------------------------------
int CHANNELS::Remove( int chnl )
{
    ASSERT( head != NULL );

    if ( count == 1 )
    {
        delete head;
        head = tail = current = NULL;
        return 1;
    }

    CLIENT_CHANNEL *chnl_before= head;
    for ( int i = 0; i < chnl - 1; i++ ) // go to the one before
    {
        ASSERT( i < count );
        chnl_before = chnl_before->next;
    }
    CLIENT_CHANNEL *target_chnl = chnl_before->next;
    if ( target_chnl == current )
    {
        current = head;
    }
    chnl_before->next = chnl_before->next->next;
    delete target_chnl;
    return --count;
}

/******************************************************************************
*                                                                             *
*                        ADS main entry point                                 *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
void main( int argc, char **argv )
{
    main_app = new DDEADS_APP( argc, argv );
    if ( main_app->Valid() )
    {
        main_app->Run();
    }
    delete main_app;
    main_app = NULL;
}
