/* 
    ADSCPP.H
        
    This file:

    Declares general ADS application object, ADS_APP.  This 
    application object is to be used when ads_main() is employed 
    instead of WinMain().

    (C) Copyright 1988-1994 by Autodesk, Inc.

    This program is copyrighted by Autodesk, Inc. and is  licensed
    to you under the following conditions.  You may not distribute
    or  publish the source code of this program in any form.   You
    may  incorporate this code in object form in derivative  works
    provided  such  derivative  works  are  (i.) are  designed and
    intended  to  work  solely  with  Autodesk, Inc. products, and
    (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
    1988-1994 by Autodesk, Inc."

    AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
    AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
    CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
    DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
    UNINTERRUPTED OR ERROR FREE.


*/
#ifndef __ADSCPP_H_
#define __ADSCPP_H_

#include "adsinc.h"

//-----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" void ads_main(int, char**);
#endif

/******************************************************************************
*                                                                             *
*                       class: ADS_APP                                        *
*                                                                             *
******************************************************************************/
//-----------------------------------------------------------------------------
class ADS_APP : ADS_OBJ
{
public:
                    ADS_APP(int argc, char **argv);
    virtual         ~ADS_APP(){}
    int             InsertExternFunc(ADS_FUNC_INFO&);
    virtual int     Run();
    virtual BOOL    Valid() { return app_state = APP_OK ; }

    //
    // CY - 10-31-94
    // The declaration is done here strangely because of a VC bug
    //
typedef int ( ADS_APP::*ADS_RUN_RSP_FUN )( void );

typedef void ( ADS_APP::*ADS_APP_RUN_FUNC )( void );
    ADS_APP_RUN_FUNC    run_funs[10];
    int             num_run_funs;

protected:

    virtual int     LOADFun( void );
    virtual int     SUBRFun( void );
    virtual int     UNLDFun( void );
    virtual int     ENDFun( void ){ return RSRSLT; }
    virtual int     QUITFun( void ){ return RSRSLT; }
    virtual int     SAVEFun( void ){ return RSRSLT; }
    virtual int     HUPFun( void ){ return RSRSLT; }
    virtual int     CFGFun( void ){ return RSRSLT; }

    int             LOAD_status;
    int             UNLD_status;
    int             SUBR_status;

    struct DISPATCHER
    {
        int command;
        ADS_RUN_RSP_FUN rsp_fun;
    };

private:
    static DISPATCHER 
                    dispatcher[];
    ADS_FUNC_INFO   exfuns[MAX_ADS_FUNC];
    int             num_funs;
    ADS_APP_STATE   app_state;

    BASIC_CPP_STUFF( ADS_APP )
};

#endif //__ADSCPP_H_

