/*****************************************************************************
    Name: asiucode.h                           ast_asi_inc_appl_asiucode_h

    Description:  This file contains definitions of classes and
                  function prototypes, that support a UniCode
                  facility in ASI. These definitions are used by
                  all ASI components to meet the goals of
                  globalization.

    Author: Grisha Starchenko
            Autodesk, Inc.
            Moscow, Russia.

      (C) Copyright 1991-93 by Autodesk, Inc.
   ***************************************************************************
      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1993 by Autodesk, Inc."
   ***************************************************************************

      THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
      WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
      PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.

   ***************************************************************************
                           RESTRICTED RIGHTS LEGEND

      Use, duplication, or disclosure by the U.S. Government is subject
      to restrictions set forth in FAR 52.227-19 (Commerical Computer
      Software - Restricted Rights) and DFAR 252.227-7013 (c) (1) (ii)
      (Rights in Technical Data and Computer Software), as applicable.
   ***************************************************************************


    Entry Points:

    Modification History:
       27 Sep 1993  - grisha -  original written

    Bugs and restriction on use:

    Notes:

*****************************************************************************/
#ifndef ASI_ASIUCODE_H
#define ASI_ASIUCODE_H asiucodeh

/***************************************************************************/
/* INCLUDES */
/***************************************************************************/

/***************************************************************************/
/* DEFINES */
/***************************************************************************/

/****************************************************************************/
/* FORWARD DEFINITIONS */
/****************************************************************************/
#if defined(__cplusplus)
class CAsiUcStr;
class CAsiUcChar;
#endif /* __cplusplus */

/***************************************************************************/
/* TYPEDEFS */
/***************************************************************************/
typedef unsigned short AsiUcChar;
typedef AsiUcChar*     AsiUcStr;
typedef unsigned long  AsiUcIdCCT;    // Id of the CodePage
typedef const char*    AsiUcNmCCT;    // Name of the CodePage
typedef unsigned long  AsiUcIdCLT;    // Id of the Collation
typedef const char*    AsiUcNmCLT;    // Name of the Collation

/***************************************************************************/
/* Class definitions */
/***************************************************************************/
#if defined(__cplusplus)

class CAsiUcStr
{
public:
    // Construction/descriptor
    //
    CAsiUcStr();                          // CAsiUcStr x;
    CAsiUcStr(const char*,AsiUcNmCCT);
    CAsiUcStr(const char*,AsiUcIdCCT);    // CAsiUcStr x = (char)"abc"+CCT;
    CAsiUcStr(const char*);               // CAsiUcStr x = (char)"abc";
    CAsiUcStr(const AsiUcStr);            // CAsiUcStr x = (AsiUcStr) y;
    CAsiUcStr(const CAsiUcStr&);          // CAsiUcStr x = (CAsiUcStr) y;
    CAsiUcStr(const CAsiUcStr*);          // CAsiUcStr x = (CAsiUcStr*) y;
    ~CAsiUcStr();

    //////////////////////////////////////////////////////////////////
    // Member functions
    //

    // Utility functions
    //
    void           Clear(void);           // Clear object data
    const AsiUcStr UcStr(void) const;     // Return pointer to Unicode string

    int            Size(void) const;      // Size of string in memory
    int            Length(void) const;    // Size of string in symbols
    int            Chlen(void) const;
    int            Chlen(AsiUcNmCCT) const;
    int            Chlen(AsiUcIdCCT) const;
    int            ChlenChk(void) const;
    int            ChlenChk(AsiUcNmCCT) const;
    int            ChlenChk(AsiUcIdCCT) const;
    void           Update(int,int);
    void           Update(int,int,AsiUcNmCCT);
    void           Update(int,int,AsiUcIdCCT);
    void           Update(int,AsiUcChar);
    void           Update(int,const CAsiUcChar&);
    void           Update(int,const CAsiUcChar*);
    void           toLower(void);         // Convert to upper case
    void           toUpper(void);         // Convert to lower case

    double         Atof(void) const;
    int            Atoi(void) const;
    long           Atol(void) const;
    double         Strtod(int*) const;
    long           Strtol(int*,int) const;
    int            Sprintf(const AsiUcStr,...);

    // Getting string into user buffer
    //
    char*          getToChar(char*,int) const;
    char*          getToChar(char*,int,AsiUcNmCCT) const;
    char*          getToChar(char*,int,AsiUcIdCCT) const;
    char*          getToCharChk(char*,int) const;
    char*          getToCharChk(char*,int,AsiUcNmCCT) const;
    char*          getToCharChk(char*,int,AsiUcIdCCT) const;
    AsiUcStr       getToUcChar(AsiUcStr,int) const;

    // Append string or character to another string
    // strcat(), strncat()
    void           Append(const char*);
    void           Append(const char*,AsiUcNmCCT);
    void           Append(const char*,AsiUcIdCCT);
    void           Append(const AsiUcStr);
    void           Append(const CAsiUcStr&);
    void           Append(const CAsiUcStr*);
    void           Append(const char*,int);
    void           Append(const char*,int,AsiUcNmCCT);
    void           Append(const char*,int,AsiUcIdCCT);
    void           Append(const AsiUcStr,int);
    void           Append(const CAsiUcStr&,int);
    void           Append(const CAsiUcStr*,int);
    void           Append(int);
    void           Append(int,AsiUcNmCCT);
    void           Append(int,AsiUcIdCCT);
    void           Append(AsiUcChar);
    void           Append(const CAsiUcChar&);
    void           Append(const CAsiUcChar*);

    // Find first occurrence of a given string in a string
    // strstr()
    int            FindFirst(const char*) const;
    int            FindFirst(const char*,AsiUcNmCCT) const;
    int            FindFirst(const char*,AsiUcIdCCT) const;
    int            FindFirst(const AsiUcStr) const;
    int            FindFirst(const CAsiUcStr&) const;
    int            FindFirst(const CAsiUcStr*) const;

    // Find last occurrence of a given character or string in a string
    // strrstr()
    int            FindLast(const char*) const;
    int            FindLast(const char*,AsiUcNmCCT) const;
    int            FindLast(const char*,AsiUcIdCCT) const;
    int            FindLast(const AsiUcStr) const;
    int            FindLast(const CAsiUcStr&) const;
    int            FindLast(const CAsiUcStr*) const;

    // Find first occurrence of a given character or string in a string
    // strchr(), strrchr()
    int            FindFirst(int) const;
    int            FindFirst(int,AsiUcNmCCT) const;
    int            FindFirst(int,AsiUcIdCCT) const;
    int            FindFirst(AsiUcChar) const;
    int            FindFirst(const CAsiUcChar&) const;
    int            FindFirst(const CAsiUcChar*) const;

    // Find last occurrence of a given character in a string
    // strrchr()
    int            FindLast(int) const;
    int            FindLast(int,AsiUcNmCCT) const;
    int            FindLast(int,AsiUcIdCCT) const;
    int            FindLast(AsiUcChar) const;
    int            FindLast(const CAsiUcChar&) const;
    int            FindLast(const CAsiUcChar*) const;

    // Compare two strings
    // strcmp(), strncmp(), stricmp(), strincmp()
    int            Comp(const char*) const;
    int            Comp(const char*,AsiUcNmCCT) const;
    int            Comp(const char*,AsiUcIdCCT) const;
    int            Comp(const AsiUcStr) const;
    int            Comp(const CAsiUcStr&) const;
    int            Comp(const CAsiUcStr*) const;

    int            Comp(const char*,int) const;
    int            Comp(const char*,int,AsiUcNmCCT) const;
    int            Comp(const char*,int,AsiUcIdCCT) const;
    int            Comp(const AsiUcStr,int) const;
    int            Comp(const CAsiUcStr&,int) const;
    int            Comp(const CAsiUcStr*,int) const;

    int            Compi(const char*) const;
    int            Compi(const char*,AsiUcNmCCT) const;
    int            Compi(const char*,AsiUcIdCCT) const;
    int            Compi(const AsiUcStr) const;
    int            Compi(const CAsiUcStr&) const;
    int            Compi(const CAsiUcStr*) const;

    int            Compi(const char*,int) const;
    int            Compi(const char*,int,AsiUcNmCCT) const;
    int            Compi(const char*,int,AsiUcIdCCT) const;
    int            Compi(const AsiUcStr,int) const;
    int            Compi(const CAsiUcStr&,int) const;
    int            Compi(const CAsiUcStr*,int) const;

    // Copy string
    // strcpy(), strncpy()
    void           Copy(const char*);
    void           Copy(const char*,AsiUcNmCCT);
    void           Copy(const char*,AsiUcIdCCT);
    void           Copy(const AsiUcStr);
    void           Copy(const CAsiUcStr&);
    void           Copy(const CAsiUcStr*);

    void           Copy(const char*,int);
    void           Copy(const char*,int,AsiUcNmCCT);
    void           Copy(const char*,int,AsiUcIdCCT);
    void           Copy(const AsiUcStr,int);
    void           Copy(const CAsiUcStr&,int);
    void           Copy(const CAsiUcStr*,int);

    ////////////////////////////////////////////////////
    // Operators
    //

    const CAsiUcChar & operator [] (int) const;

    // Assigned
    //
    CAsiUcStr&  operator =  (const char*);
    CAsiUcStr&  operator =  (const AsiUcStr);
    CAsiUcStr&  operator =  (const CAsiUcStr &);
    CAsiUcStr&  operator =  (const CAsiUcStr *);

    // Compare
    //
    friend int operator == (const CAsiUcStr&, const char*);
    friend int operator == (const char*, const CAsiUcStr&);
    friend int operator == (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator == (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator == (const AsiUcStr, const CAsiUcStr&);
    friend int operator == (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator == (const CAsiUcStr&, const AsiUcStr);

    friend int operator != (const CAsiUcStr&, const char*);
    friend int operator != (const char*, const CAsiUcStr&);
    friend int operator != (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator != (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator != (const AsiUcStr, const CAsiUcStr&);
    friend int operator != (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator != (const CAsiUcStr&, const AsiUcStr);

    friend int operator >  (const CAsiUcStr&, const char*);
    friend int operator >  (const char*, const CAsiUcStr&);
    friend int operator >  (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator >  (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator >  (const AsiUcStr, const CAsiUcStr&);
    friend int operator >  (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator >  (const CAsiUcStr&, const AsiUcStr);

    friend int operator <  (const CAsiUcStr&, const char*);
    friend int operator <  (const char*, const CAsiUcStr&);
    friend int operator <  (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator <  (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator <  (const AsiUcStr, const CAsiUcStr&);
    friend int operator <  (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator <  (const CAsiUcStr&, const AsiUcStr);

    friend int operator >= (const CAsiUcStr&, const char*);
    friend int operator >= (const char*, const CAsiUcStr&);
    friend int operator >= (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator >= (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator >= (const AsiUcStr, const CAsiUcStr&);
    friend int operator >= (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator >= (const CAsiUcStr&, const AsiUcStr);

    friend int operator <= (const CAsiUcStr&, const char*);
    friend int operator <= (const char*, const CAsiUcStr&);
    friend int operator <= (const CAsiUcStr&, const CAsiUcStr&);
    friend int operator <= (const CAsiUcStr*, const CAsiUcStr&);
    friend int operator <= (const AsiUcStr, const CAsiUcStr&);
    friend int operator <= (const CAsiUcStr&, const CAsiUcStr*);
    friend int operator <= (const CAsiUcStr&, const AsiUcStr);

    // New/Delete
    //
    void* operator new(unsigned int);
    void operator delete(void*);

private:
    void *pUcStrData;
};

class CAsiUcChar
{
public:
    // Unicode character
    //
    AsiUcChar Symbol;

    //////////////////////////////////////////////////////////////////
    // Member functions
    //

    // is functions
    //
    int       isUpper(void) const;
    int       isLower(void) const;
    int       isAlpha(void) const;
    int       isDigit(void) const;
    int       isXdigit(void) const;
    int       isSpace(void) const;
    int       isPunct(void) const;
    int       isAlnum(void) const;
    int       isGraph(void) const;
    int       isPrint(void) const;
    int       isCntrl(void) const;

    // set functions
    //
    void      setUpper(void);
    void      setLower(void);
    void      setChar(int,AsiUcIdCCT);
    void      setChar(int,AsiUcNmCCT);
    void      setChar(AsiUcChar);

    // get functions
    int       getChar(void) const;
    int       getChar(AsiUcIdCCT) const;
    int       getChar(AsiUcNmCCT) const;
    AsiUcChar getUcChar(void) const;

    // return character in upper/lower form
    //
    CAsiUcChar Upper(void) const;
    CAsiUcChar Lower(void) const;

    // Compare functions
    //
    int  Comp(int) const;
    int  Comp(int,AsiUcIdCCT) const;
    int  Comp(int,AsiUcNmCCT) const;
    int  Comp(AsiUcChar) const;
    int  Comp(CAsiUcChar*) const;
    int  Comp(const CAsiUcChar&) const;
    int  Compi(int) const;
    int  Compi(int,AsiUcIdCCT) const;
    int  Compi(int,AsiUcNmCCT) const;
    int  Compi(AsiUcChar) const;
    int  Compi(CAsiUcChar*) const;
    int  Compi(const CAsiUcChar&) const;

    ////////////////////////////////////////////////////
    // Operators
    //

    // Assigned
    //
    CAsiUcChar&  operator =  (const char);
    CAsiUcChar&  operator =  (const AsiUcChar);
    CAsiUcChar&  operator =  (const CAsiUcChar&);

    // Compare
    //
    friend int operator == (const CAsiUcChar&, const char);
    friend int operator == (const char, const CAsiUcChar&);
    friend int operator == (const CAsiUcChar&, const AsiUcChar);
    friend int operator == (const AsiUcChar, const CAsiUcChar&);
    friend int operator == (const CAsiUcChar&, const CAsiUcChar&);

    friend int operator != (const CAsiUcChar&, const char);
    friend int operator != (const char, const CAsiUcChar&);
    friend int operator != (const CAsiUcChar&, const AsiUcChar);
    friend int operator != (const AsiUcChar, const CAsiUcChar&);
    friend int operator != (const CAsiUcChar&, const CAsiUcChar&);

    friend int operator >  (const CAsiUcChar&, const char);
    friend int operator >  (const char, const CAsiUcChar&);
    friend int operator >  (const CAsiUcChar&, const AsiUcChar);
    friend int operator >  (const AsiUcChar, const CAsiUcChar&);
    friend int operator >  (const CAsiUcChar&, const CAsiUcChar&);

    friend int operator <  (const CAsiUcChar&, const char);
    friend int operator <  (const char, const CAsiUcChar&);
    friend int operator <  (const CAsiUcChar&, const AsiUcChar);
    friend int operator <  (const AsiUcChar, const CAsiUcChar&);
    friend int operator <  (const CAsiUcChar&, const CAsiUcChar&);

    friend int operator >= (const CAsiUcChar&, const char);
    friend int operator >= (const char, const CAsiUcChar&);
    friend int operator >= (const CAsiUcChar&, const AsiUcChar);
    friend int operator >= (const AsiUcChar, const CAsiUcChar&);
    friend int operator >= (const CAsiUcChar&, const CAsiUcChar&);

    friend int operator <= (const CAsiUcChar&, const char);
    friend int operator <= (const char, const CAsiUcChar&);
    friend int operator <= (const CAsiUcChar&, const AsiUcChar);
    friend int operator <= (const AsiUcChar, const CAsiUcChar&);
    friend int operator <= (const CAsiUcChar&, const CAsiUcChar&);

    // New/Delete
    //
    void* operator new(unsigned int);
    void operator delete(void*);
};

#endif /* __cplusplus */

/***************************************************************************/
/* FUNCTION PROTOTYPES */
/***************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

int          AsiUcIsAlnum      (AsiUcChar);
int          AsiUcIsAlpha      (AsiUcChar);
int          AsiUcIsCntrl      (AsiUcChar);
int          AsiUcIsDigit      (AsiUcChar);
int          AsiUcIsGraph      (AsiUcChar);
int          AsiUcIsLower      (AsiUcChar);
int          AsiUcIsPrint      (AsiUcChar);
int          AsiUcIsPunct      (AsiUcChar);
int          AsiUcIsSpace      (AsiUcChar);
int          AsiUcIsUpper      (AsiUcChar);
int          AsiUcIsXdigit     (AsiUcChar);

AsiUcChar    AsiUcToLower      (AsiUcChar);
AsiUcChar    AsiUcToUpper      (AsiUcChar);

AsiUcChar    AsiUcPrecompose   (const AsiUcStr);
AsiUcStr     AsiUcDecompose    (AsiUcStr,AsiUcChar);
AsiUcChar    AsiUcNormdigit    (AsiUcChar);

int          AsiUcSprintf      (AsiUcStr,const AsiUcStr, ...);

double       AsiUcAtof         (const AsiUcStr);
int          AsiUcAtoi         (const AsiUcStr);
long         AsiUcAtol         (const AsiUcStr);
double       AsiUcStrtod       (const AsiUcStr,AsiUcStr*);
long         AsiUcStrtol       (const AsiUcStr,AsiUcStr*,int);

AsiUcStr     AsiUcStrcpy       (AsiUcStr,const AsiUcStr);
AsiUcStr     AsiUcStrncpy      (AsiUcStr,const AsiUcStr,int);
AsiUcStr     AsiUcStrcat       (AsiUcStr,const AsiUcStr);
AsiUcStr     AsiUcStrncat      (AsiUcStr,const AsiUcStr,int);

int          AsiUcCmpUCandUC   (const AsiUcStr,const AsiUcStr);
int          AsiUcStrcmp       (const AsiUcStr,const AsiUcStr);
int          AsiUcStrncmp      (const AsiUcStr,const AsiUcStr,int);
int          AsiUcStricmp      (const AsiUcStr,const AsiUcStr);
int          AsiUcStrnicmp     (const AsiUcStr,const AsiUcStr,int);

AsiUcStr     AsiUcStrstr       (const AsiUcStr,const AsiUcStr);
AsiUcStr     AsiUcStrrstr      (const AsiUcStr,const AsiUcStr);
AsiUcStr     AsiUcStrchr       (const AsiUcStr,AsiUcChar);
AsiUcStr     AsiUcStrrchr      (const AsiUcStr,AsiUcChar);

AsiUcStr     AsiUcStrLower     (AsiUcStr);
AsiUcStr     AsiUcStrUpper     (AsiUcStr);

char*        AsiUcStrUc2Ch     (char*,int,const AsiUcStr,int,AsiUcNmCCT);
AsiUcStr     AsiUcStrCh2Uc     (AsiUcStr,int,const char*,int,AsiUcNmCCT);

int          AsiUc2Ch          (AsiUcChar,AsiUcNmCCT);
AsiUcChar    AsiCh2Uc          (int,AsiUcNmCCT);

int          AsiUcStrlen       (const AsiUcStr);
int          AsiUcStrsize      (const AsiUcStr);
int          AsiUcStrchln      (const AsiUcStr,AsiUcNmCCT);

AsiUcIdCCT   AsiUcGetIdCCT     (AsiUcNmCCT);
AsiUcNmCCT   AsiUcGetNmCCT     (AsiUcIdCCT);
AsiUcNmCCT   AsiUcDefaultCCT   (void);

AsiUcIdCLT   AsiUcGetIdCLT     (AsiUcNmCLT);
AsiUcNmCLT   AsiUcGetNmCLT     (AsiUcIdCLT);
AsiUcNmCLT   AsiUcDefaultCLT   (void);

int          AsiUcCnChcmp      (AsiUcNmCLT,AsiUcChar,AsiUcChar);
int          AsiUcCnStrcmp     (AsiUcNmCLT,const AsiUcStr,const AsiUcStr);
int          AsiUcCnStrncmp    (AsiUcNmCLT,const AsiUcStr,const AsiUcStr,int);

EAsiBoolean  AsiUcCiStrweight  (AsiUcIdCLT,const AsiUcStr,AsiUcStr);
int          AsiUcCiChcmp      (AsiUcIdCLT,AsiUcChar,AsiUcChar);
int          AsiUcCiStrcmp     (AsiUcIdCLT,const AsiUcStr,const AsiUcStr);
int          AsiUcCiStrncmp    (AsiUcIdCLT,const AsiUcStr,const AsiUcStr,int);
int          AsiUcCiUcChStrcmp (AsiUcIdCLT,AsiUcIdCCT,const AsiUcStr,const char *);

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* ASI_ASIUCODE_H */
/*EOF*/
