; Next available MSG number is     10 
;
; MODULE_ID R13NEW_LSP_
;;;
;;;    r13new.lsp
;;;
;;;    Copyright (C) 1994 by Autodesk, Inc.
;;;    
;;;    Permission to use, copy, modify, and distribute this software 
;;;    for any purpose and without fee is hereby granted, provided
;;;    that the above copyright notice appears in all copies and 
;;;    that both that copyright notice and the limited warranty and 
;;;    restricted rights notice below appear in all supporting 
;;;    documentation.
;;;    
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
;;;    UNINTERRUPTED OR ERROR FREE.
;;;    
;;;    Use, duplication, or disclosure by the U.S. Government is subject  
;;;    to restrictions set forth in FAR 52.227-19 (Commercial Computer 
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;;    (Rights in Technical Data and Computer Software), as applicable. 
;;;
;;;=========================================================================
;
; Requires the files: R13NEW.DCL, R13NEW.DAT, R13NEW.SLB, and R13NEW.AHP. 
;
;;;=========================================================================
;;; Info file format (R13NEW.DAT is the info file .. can be any name)
;;;
;;; There are 2 sections in this file:
;;;   TOPICS  - lists the topics in the file
;;;   TOPIC   - contains the text (PAGEs) for each topic, there should be
;;;             one TOPIC section for each topic listed in TOPICS
;|

#define MODULE_ID R13NEW_LSP_

TOPICS{             .. starts the TOPICS section
@"First Topic"      .. all topics are enclosed in curly braces, no blank lines her
@"Second Topic"     
@"and so on .."
}TOPICS             .. ends the TOPICS section
                    .. blank line(s) OK here
TOPIC{              .. starts the first TOPIC section
TITLE"First Topic"  .. topic name, text in braces must exactly match one in TOPICS
PAGE{page name}     .. page name, required but not seen by users (do not translate)
SLD{slide name}     .. slide associated with page {sld_lib(sldnam)} is valid
TXT{                .. starts text of the page
@"Lots of text here".. the text, must not be more than 34 characters per line,
@"and more "           blank lines OK 
@"yes...   "
@" "
}TXT                .. ends the text of the page
PAGE{ }             .. see above, these groups repeat for each page of text
SLD{ }
TXT{
@" ..."
}TXT
}TOPIC              .. ends the topic, more topics can follow

|;
;;;=============================================================================

(defun C:WHATSNEW ( / vvv dcl_id )
  (ac:erron nil)
  (defun ac_errprg ()  ;; executes on error to close file
    (if vvv (progn (close vvv)(setq vvv nil) ))
  )
  (setq dcl_id (load_dialog ;|MSG0|;"r13new.dcl"))
  (if (not (new_dialog ;|MSG0|;"infomain" dcl_id))(exit))  
  (action_tile ;|MSG0|;"group_1" ;|MSG0|;"(help \"r13new.ahp\")")
  (action_tile ;|MSG0|;"group_2" ;|MSG0|;"(wn:topicbox \"r13new.dat\" \"New Features\")")
  (action_tile ;|MSG0|;"group_3" ;|MSG0|;"(help \"r13new.ahp\" \"command_summary\")")
  (start_dialog)
  (unload_dialog dcl_id)  
  (ac:erroff)
  (princ)
)


(defun wn:topicbox ( fil secnam / fff t_lst xxx t_num )
  (setq fff (findfile fil) t_lst nil)
  (setq errmsg1 "" errmsg2 ;|R13NEW_LSP_1|;"Loading topic, please wait ...") 
  (if (not fff)
    (progn
      (alert (strcat ;|R13NEW_LSP_2|;"File <" fil 
        ;|R13NEW_LSP_3|;"> not found in support path."))
      (exit)
    )
  )
  (setq vvv (open fff ;|MSG0|;"r"))
  (setq xxx (read-line vvv))
  (while xxx
    (if (= xxx ;|MSG0|;"TOPICS{")
      (progn
        (setq xxx (read-line vvv))
        (while (and xxx (not (wcmatch xxx ;|MSG0|;"}TOPICS*")))
          (setq t_lst (append t_lst (list (x_str xxx "\"" "\"")))) ;!!
          (setq xxx (read-line vvv))
        )
      )
    )
    (if (= xxx ;|MSG0|;"}TOPICS")
      (setq xxx nil)
      (setq xxx (read-line vvv))
    )
  )
  (close vvv)
  (setq vvv nil)  
  (setq dcl_id (load_dialog ;|MSG0|;"r13new.dcl"))
  (if (not (new_dialog ;|MSG0|;"infotopic" dcl_id))(exit))
  (setq t_num "0")
  (set_tile ;|MSG0|;"grp_title1" secnam)
  (start_list ;|MSG0|;"topiclist1")
  (mapcar 'add_list t_lst) 
  (end_list)
  (mode_tile ;|MSG0|;"topiclist1" 2)
  (action_tile ;|MSG0|;"topiclist1" 
    ;|MSG0|;"(setq t_num $value)(if (= $reason 4)(wn:pagebox fff (nth (atoi t_num) t_lst)))")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(wn:pagebox fff (nth (atoi t_num) t_lst))")
  (action_tile ;|MSG0|;"help" ;|MSG0|;"(help \"r13new.ahp\")")
  (setq ddd (start_dialog))
  (unload_dialog dcl_id)
  (if (/= ddd 0)
    (progn
      (setq tpcnam nil ct 1)
      (repeat tpcs
        (eval (read (strcat ;|MSG0|;"(setq lst_" (itoa ct) ;|MSG0|;" nil)")))
        (setq ct (1+ ct))
      )
      (setq tpcs nil)
    )
  )
)


(defun wn:pagebox ( fil tpc / fff xxx str ret ct lst lst_n pgnam sldnam tpcnam)
  (set_tile ;|MSG0|;"error" errmsg2)
  (setq vvv (open (findfile fil) ;|MSG0|;"r"))
  (setq xxx (read-line vvv))
  (setq str (strcat ;|MSG0|;"TITLE*" tpc "*"))  ;!!
  (while xxx
    (if (wcmatch xxx str)
      (setq ret str tpcnam (x_str xxx "\"" "\"") xxx nil)
      (setq xxx (read-line vvv) ret nil)
    )
  )  
  (if ret
    (progn
      (setq ct 0 tpcs 0)
      (setq xxx (read-line vvv))
      (while xxx
        (cond
          ((wcmatch xxx ;|MSG0|;"PAGE{*")
            (setq ct (1+ ct) lst nil lst_n nil tpcs (1+ tpcs))
            (setq pgnam (x_str xxx "{" "}"))
            
            (setq sldnam (x_str (read-line vvv) "{" "}"))
            (setq lst_n (list pgnam sldnam))
            (setq xxx (read-line vvv))    ; reads "TXT{"
            (setq xxx (read-line vvv))    ; reads next line
            (while (not (wcmatch xxx ;|MSG0|;"}TXT*"))
              (setq xxx (x_str xxx "\"" "\""))  ;!!new line
              (cond 
                ((not xxx) nil)
                ((= (ascii xxx) 94) nil)
                (t (setq lst (append lst (list xxx))))
              )
              (setq xxx (read-line vvv))
            )
            (setq lst_n (append lst_n (list lst)))
            (eval (read (strcat ;|MSG0|;"(setq lst_" (itoa ct) ;|MSG0|;" lst_n)")))
          )
          ((wcmatch xxx ;|MSG0|;"}TOPIC*")(setq xxx nil))
          (t (setq xxx (read-line vvv)))
        )
      )
    )
    (alert (strcat ;|R13NEW_LSP_4|;"No topic <" tpc ;|R13NEW_LSP_5|;">\nfound in file <" fff ">."))
  )
  (close vvv)
  (setq vvv nil)
  (if ret
    (progn
      (setq cur_tpc 1)
      (setq dcl_id (load_dialog ;|MSG0|;"r13new.dcl"))
      (if (not (new_dialog ;|MSG0|;"infodlg" dcl_id))(exit))
      (tileset cur_tpc tpcs)
      (action_tile ;|MSG0|;"prev_btn" ;|MSG0|;"(setq cur_tpc (1- cur_tpc))(tileset cur_tpc tpcs)")
      (action_tile ;|MSG0|;"next_btn" ;|MSG0|;"(setq cur_tpc (1+ cur_tpc))(tileset cur_tpc tpcs)")
      (start_dialog)
      (unload_dialog dcl_id)
    )
  )
  (set_tile ;|MSG0|;"error" errmsg1)
)


(defun tileset ( nnn tpcs / )
  (set_tile ;|MSG0|;"infotitle" (strcat secnam " - " tpcnam ))
  (set_tile ;|MSG0|;"pgno" (strcat ;|R13NEW_LSP_6|;" Page " (itoa nnn) 
    ;|R13NEW_LSP_7|;" of " (itoa tpcs)))
  (listset nnn)
  (imagset nnn)
  (if (= nnn 1)
    (mode_tile ;|MSG0|;"prev_btn" 1)
    (mode_tile ;|MSG0|;"prev_btn" 0)
  )
  (if (<= tpcs nnn)
    (mode_tile ;|MSG0|;"next_btn" 1)
    (mode_tile ;|MSG0|;"next_btn" 0)
  )
)

(defun listset ( nnn / lst )
  (eval (read (strcat ;|MSG0|;"(setq lst (caddr lst_" (itoa nnn) "))")))
  (start_list ;|MSG0|;"infotxt")
  (mapcar 'add_list lst)
  (end_list)
)

(defun imagset ( nnn / dimx dimy sld)
  (eval (read (strcat ;|MSG0|;"(setq sld (cadr lst_" (itoa nnn) "))")))
  (setq dimx (dimx_tile ;|MSG0|;"infosld") dimy (dimy_tile ;|MSG0|;"infosld"))
  (start_image ;|MSG0|;"infosld")
  (fill_image 0 0 dimx dimy 8)
  (slide_image 0 0 dimx dimy sld)
  (end_image)
)

;;;=========================================================================
;;; X_STR extracts the text from between a <beg> and <end> character

(defun x_str ( str beg end / ct xxx mk yyy )
  (setq ct 1 mk 0 yyy "" b_num 0 e_num 0 mk1 0)
  (if (= end "")(setq strl (1+ (strlen str)))(setq strl (strlen str)))
  (while (< ct strl)
    (setq xxx (substr str ct 1))
    (if (= beg "")
      (setq mk 1 beg nil b_num 1)    ;; if the first occurance 
      (if (and (= mk1 0)(= xxx beg)) ;; of beginning character
        (setq b_num ct mk 1 ct (1+ ct) xxx (substr str ct 1) mk1 1)
      )
    )
    (if (/= end "")
      (if (= xxx end)             ;; if the ending character
        (setq e_num ct mk 0 ct (- (strlen str) 1))
      )
    )
    (if (= mk 1) (setq yyy (strcat yyy xxx)) )
    (setq ct (1+ ct))
  )
  (if (= e_num 0)(setq e_num ct))
  yyy
)

;;;=========================================================================
;;; Error handling program
;
;(defun c:xxx ()
;  (ac:erron '("orthomode" "snapang")) ;; list all relavent sysvars or `nil'
;  (defun ac_errprg ()                           ;<< Optional 
;    (if vvv (progn (close vvv)(setq vvv nil) )) ;<< error 
;  )                                             ;<< program
;
;  ;; program body here;
;  (setq ac_errmsg ">> some message <<")  ;<< Optional error message
;
;  (ac:erroff)
;  (princ)
;)

;;;===========================================================================

(defun ac:erron ( varlst / )
  (setvar ;|MSG0|;"cmdecho" 0)
  (setq acerr *error*)
  (setq ac=mods nil)
  (if varlst 
    (foreach n varlst 
      (setq ac=mods (append ac=mods (list (list n (getvar n)))))
    )
  )
  (defun *error* (msg) 
    (if ac_errprg (ac_errprg))
    (if ac=mods (foreach n ac=mods (setvar (car n) (cadr n))) )
    (setq *error* acerr)
    (princ (strcat ;|R13NEW_LSP_8|;"Error: " msg ))
    (if (and ac_errmsg (/= ac_errmsg ""))
      (princ (strcat "\n  >> " ac_errmsg " <<"))
    )
    (setq ac_errmsg nil)
    (princ)
  )
  (defun ac:erroff ()
    (if ac=mods (foreach n ac=mods (setvar (car n) (cadr n))) )
    (setq ac_errprg nil)
    (setq *error* acerr)
  )
)

;;;===========================================================================

;(princ ;|R13NEW_LSP_9|;"\nR13NEW.LSP loaded. Enter WHATSNEW to use. ")
(princ)


