@echo off
@echo --------------------------------------------------------------------
@echo (C) Copyright 1990-1994 by Autodesk, Inc.
@echo Permission to use, copy, modify, and distribute this software and its
@echo documentation for any purpose and without fee is hereby granted.   
@echo THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
@echo ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
@echo MERCHANTABILITY ARE HEREBY DISCLAIMED.                                 
@echo --------------------------------------------------------------------
@echo MSDOS batch file to build High C 3.x ADS sample programs

set SAVHC=%HIGHC%
set SAVIP=%IPATH%
set SAVPTH=%PATH%

:: location of root of Metaware High-C directory tree
set HIGHC=c:\hc3_21

:: Location of ADS.LIB 
set ADSLIB=c:\acad13\ads

:: Location of ADS include files
set ADSINC=c:\acad13\ads

:: add location of High-C's and Phar Lap's bin directories to the path
set PATH=%HIGHC%\bin;c:\pharlap6\bin;%path%;

:: location of include files such as for High-C and ADS
set IPATH=%HIGHC%\INC;%ADSINC%

:: compiler options
set HCOPTS=-f387 -O3 -l%ADSLIB%\ads.lib -Hnopack -Hldopt#-backcompat

if exist %HIGHC%\small\hc386.lib goto L1
echo You must edit hc3xsamp.bat and change the variable HIGHC 
goto done 

:L1
if exist %ADSLIB%\ads.lib goto L2
echo You must edit hc3xsamp.bat and change the variable ADSLIB
goto done 

:L2
if exist %ADSINC%\adslib.h goto L3
echo You must edit hc3xsamp.bat and change the variable ADSINC
goto done 

:L3
@echo Creating hcsamp.pro ... 
echo #define PROTOTYPES 1 > hcsamp.pro
echo pragma Align_members(1); >> hcsamp.pro
echo pragma On(Prototype_conversion_warn); >> hcsamp.pro
echo pragma Off(Prototype_override_warnings); >> hcsamp.pro
echo pragma On(Read_only_strings); >> hcsamp.pro

if .%1 == . goto L4
@echo Compiling %1.c 

:: for no debug use this line to compile and link
  hc386 %1.c %HCOPTS% -Hpro=hcsamp.pro -Hkeep

:: For debug use this which has the -g and -fullsym switches.
::hc386 %1.c %HCOPTS% -Hpro=hcsamp.pro -g -Hkeep -Hldopt=-fullsym

goto done

:L4
@echo Compiling ads_perr.c
  hc386 ads_perr.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling appmngr.c
  hc386 appmngr.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling arbmat.c
  hc386 arbmat.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling colext.c
  hc386 colext.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling dlgtest.c
  hc386 dlgtest.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling dragger.c
  hc386 dragger.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling fact.c
  hc386 fact.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling gpalsym.c
  hc386 gpalsym.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling gravity.c
  hc386 gravity.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling grvecs.c
  hc386 grvecs.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling magnets.c
  hc386 magnets.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling mountain.c
  hc386 mountain.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling sld2ps.c
  hc386 sld2ps.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling sqr.c
  hc386 sqr.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling tadc.c
  hc386 tadc.c %HCOPTS% -Hpro=hcsamp.pro

@echo Compiling tower.c
  hc386 tower.c %HCOPTS% -Hpro=hcsamp.pro

@echo Building geomcal
  echo cal.c calerr.c calexpr.c callex.c > geomcal.lnk
  echo calmngf.c calstdf.c calusrf.c util.c >> geomcal.lnk
  hc386 @geomcal.lnk %HCOPTS% -Hpro=hcsamp.pro -o geomcal
  del geomcal.lnk

:done

set HIGHC=%SAVHC%
set IPATH=%SAVIP%
set PATH=%SAVPTH%
set SAVHC=
set SAVIP=
set SAVPTH=
set ADSLIB=
set ADSINC=
set HCOPTS=

@echo
@echo HC3XSAMP completed
@echo on
