/*****************************************************************************
      UTIL.H
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: Library of various utility functions. This is not a well
               organized library, just a rather random collection of 
               functions. But you might find some of the functions useful.
  
*****************************************************************************/

#ifndef _UTIL_H
#define _UTIL_H


/****************************************************************************/
/*  DEFINES                                                                 */
/****************************************************************************/

#define      PI               3.14159265358979323846
#define      DEGRAD           (PI/180.0)  
#define      EPS              1e-10
#define      EPS_COS          0.99999

#define      ELEMENTS(array)  (sizeof(array)/sizeof((array)[0]))
#define      SQR(x)           ((x)*(x))
#define      LENGTH(v)        sqrt(SQR((v)[X])+SQR((v)[Y])+SQR((v)[Z]))
#define      DISTANCE(a,b)    sqrt(SQR((a)[X]-(b)[X])+SQR((a)[Y]-(b)[Y])\
                                   +SQR((a)[Z]-(b)[Z]))
#define      DOTPROD(a,b)     ((a)[X]*(b)[X]+(a)[Y]*(b)[Y]+(a)[Z]*(b)[Z])

#define      CPY_PNT(a,b)     ((a)[X]=(b)[X],(a)[Y]=(b)[Y],(a)[Z]=(b)[Z])
#define      SUB_PNT(a,b,c)   ((a)[X]=(b)[X]-(c)[X],(a)[Y]=(b)[Y]-(c)[Y],\
                               (a)[Z]=(b)[Z]-(c)[Z])
#define      ADD_PNT(a,b,c)   ((a)[X]=(b)[X]+(c)[X],(a)[Y]=(b)[Y]+(c)[Y],\
                               (a)[Z]=(b)[Z]+(c)[Z])

/****************************************************************************/
/*  EXPORTED FUNCTIONS                                                      */
/****************************************************************************/

int sa_get_pline_segment_data  _((ads_name plseg_name, 
                                  struct resbuf *plseg_rb,
                                  ads_point p1, ads_point p2,
                                  ads_point center, double *radius,
                                  ads_point normal));
                                   
int sa_get_cs_of_picked_entity _((char *prompt, int axis_required,
                                  ads_point origin, ads_point xaxis,
                                  ads_point yaxis, ads_point zaxis));
                                   
void   sa_save_acad_vars      _((void));
void   sa_restore_acad_vars   _((void));
void   sa_cmdecho_off         _((void));
void   sa_cmdecho_back        _((void));
void   sa_undo_group          _((void));
void   sa_undo_end            _((void));
void   sa_set_sortents        _((int pick_mode));
void   sa_save_sortents       _((void));
void   sa_restore_sortents    _((void));

void   sa_cross               _((ads_point v, ads_point v1, ads_point v2));
double sa_det                 _((ads_point a, ads_point b, ads_point c));
int    sa_u2w                 _((ads_point p1, ads_point p2));
int    sa_w2u                 _((ads_point p1, ads_point p2));
int    sa_points_are_collinear _((ads_point p1, ads_point p2, ads_point p3));
void   sa_transform_pt        _((ads_point m[4], ads_point p1, ads_point p2));
int    sa_normalize           _((ads_point v));
void   sa_normalize_angle     _((double *angle));
double sa_3d_angle            _((ads_point apex, ads_point p1, ads_point p2));

int    sa_plane_from_point_and_normal _((ads_point origin, 
                                         ads_point xaxis,
                                         ads_point yaxis, 
                                         ads_point zaxis));

int    sa_plane_equation              _((int pts3, 
                                         ads_point p1, ads_point p2, 
                                         ads_point p3,
                                         ads_point n, double *d));
                                   
int    sa_rotate_point_around_axis _((ads_point pp, double angle,
                                      ads_point p1, ads_point p2));

double sa_angle_around_axis        _((ads_point p1, ads_point p2, 
                                      ads_point from, ads_point to));

void   sa_orientate_cs_upwards     _((ads_point origin, ads_point xaxis,
                                      ads_point yaxis, ads_point zaxis));

int    sa_is_planar_pline          _((ads_name vertex_name, ads_point normal));

int    sa_pline_name_from_vertex_name _((ads_name vertex_name,
                                         ads_name pline_name));

int    sa_make_arb_matrix _((ads_point zaxis, ads_point m[4]));

int    sa_get_radius_of_picked_entity _((char *prompt, double *radius));

int    sa_snap _((char *prompt, char *mode, ads_point p));
double sa_uniform_scaling_factor _((ads_point m[4]));

double sa_visual_distance _((ads_point p1, ads_point p2));


#endif /*_UTIL_H*/
