/* Next available MSG number is  1 */

/*****************************************************************************
      CALMNGF.C
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: Management of the table of calculator functions.

*****************************************************************************/


/****************************************************************************/
/*  INCLUDES                                                                */
/****************************************************************************/

#include "cal.h"


/****************************************************************************/
/*  EXPORTED VARIABLES                                                      */
/****************************************************************************/

cft cal_funcs_table;                  /* Table of calculator functions  */
int cal_funcs_number = 0;             /* Number of calculator functions */

/* Variables for passing actual parameters to calculator functions 
   and returning the value from the function:

   Before a calculator function is called, its acutal parameters must 
   be stored in global array 'params[]'. The function returns its result
   in global variable 'result'. See functions in module 'calstdf.c'.
*/

int             no_of_params;
vector_real_int params[MAX_FUNC_PARAM];
vector_real_int result;


/****************************************************************************/
/*.doc cal_register_function(external)*/
/*+
  Function registers new calculator function. 'func_name' is the
  name of the function which will be used to refer to this function
  in arithmetic expressions, 'func_ptr' is a pointer to the function 
  definition. If the function fails, it prints an error message
  and terminates the ADS application.
-*/
/****************************************************************************/


void
/*FCN*/cal_register_function(func_name, func_ptr)

  char *func_name;
  void (*func_ptr)();
{
    int  i;
    char name[MAX_SYMBOL_LENGTH+1];
    int  len;

    if (cal_err)
        return;

    /* Do initial checking */

    if (cal_funcs_number >= MAX_CAL_FUNC) {
        error(44, NULL);
        return;
    }

    if (func_name == NULL) {
        error(46, NULL);
        return;
    }

    len = strlen(func_name);

    if (len > MAX_SYMBOL_LENGTH) {
        error(47, func_name);
        return;
    }

    /* Check whether the function name is an identifier */

    strcpy(name, func_name);

    if (!ads_isalpha(name[0])) {
        error(42, func_name);
        return;
    }
    for (i = 0; i < len; i++) {
        name[i] = ads_toupper(name[i]);
        if (!ads_isalnum(name[i]) && (name[i] != '_')) {
            error(42, func_name);
            return;
        }
    }

    /* Check whether function of this name wasn't already registered */

    for (i = 0; i < cal_funcs_number; i++) {
        if (strcmp(cal_funcs_table[i].name, name) == 0) {
            error(60, func_name);
            return;
        }
    }

    /* Insert the new calculator function at the end of the table */

    strcpy(cal_funcs_table[cal_funcs_number].name, name);
    cal_funcs_table[cal_funcs_number].func = func_ptr;
    cal_funcs_number++;

} /*cal_register_function*/


/****************************************************************************/
/*.doc cal_invoke_function(external)*/
/*+
  Invoke calculator function whose name is 'func_name'. 

  Before a function is invoked, the function parameters must be stored in 
  array'params[]', the number of actual parameters in 'no_of_params'. The 
  invoked function returns its result in 'result'. 

  Function returns TRUE if function 'func_name' was successfully invoked
  and the invoked function succeeded, otherwise FALSE is returned. You can
  use 'cal_err' variable to check the reason why the invocation failed.
-*/
/****************************************************************************/


int
/*FCN*/cal_invoke_function(func_name)

  char *func_name;
{
    int i;

    if (cal_err)
        return(FALSE);

    for (i = 0; i < cal_funcs_number; i++) {
        if (strcmp(func_name, cal_funcs_table[i].name) == 0) {
            (*cal_funcs_table[i].func)();
            return(cal_err == 0);
        }
    } /*for*/

    error(52, func_name);
    return(FALSE);
} /*cal_invoke_function*/


