/*****************************************************************************
      CALLEX.H
      (C) Copyright 1988-1994 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1988-1993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

  Description: Header file for callex.c

*****************************************************************************/


/****************************************************************************/
/*  DEFINES                                                                 */
/****************************************************************************/

#define MAX_LINE_LENGTH   130         /* Max lenght of the input line */
#define MAX_SYMBOL_LENGTH  32         /* Max length of any symbol     */


/****************************************************************************/
/*  TYPEDEFS                                                                */
/****************************************************************************/

typedef enum 
{
    ident_sym,
    real_sym,
    int_sym,
    func_sym,
    lbracket_sym,
    rbracket_sym,
    lparent_sym,
    rparent_sym,
    at_sym,
    lessthan_sym,
    plus_sym,
    minus_sym,
    asterisk_sym,
    slash_sym,
    ampersand_sym,
    caret_sym,
    pi_sym,
    comma_sym,
    getvar_sym,
    cvunit_sym,
    equal_sym,
    no_sym
} symbol_type;


/* Output structure from the lexical analyser */

typedef struct 
{
    symbol_type sym;                  /* Returned symbol type         */
    char        id[MAX_SYMBOL_LENGTH+1]; /* Returned identifier       */
    double      real_num;             /* Returned real or int number  */
    void        (*func_ptr)();        /* Returned pointer to function */
} lex_output_type;


/****************************************************************************/
/*  EXPORTED VARIABLES AND FUNCTIONS                                        */
/****************************************************************************/

extern lex_output_type cal_lex;       /* Output struct from lex. analyser */

void        cal_lex_start   _((char *line));
void        cal_next_symbol _((void));

