@echo off
:: --------------------------------------------------------------------
:: (C) Copyright 1990-1994 by Autodesk, Inc.
:: Permission to use, copy, modify, and distribute this software and its
:: documentation for any purpose and without fee is hereby granted.   
:: THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
:: ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
:: MERCHANTABILITY ARE HEREBY DISCLAIMED.                                 
:: --------------------------------------------------------------------
::
::             ARX environment setup for nmake
::
:: Batch file to set up environment for building ARX programs with
:: 32-bit edition MSVC++ for Windows and Windows NT. This batch file
:: requires NMAKE and the make file MKARX.MAK. 
::


::  The name of source file (without extension) must be supplied as first
::  parameter to batch file. The MKARX.MAK make file expects the file
::  extension to be .CPP not .CC. If you want to use .CC then you must
::  change the "EXT" macro at the beginning of the MKARX.MAK file.

if (%1) == () goto noname

:: set variable for name of source file (without extension)
set INFILE=%1

:: save off old path
set OLDPATH=%PATH%

:: set variable for location of root of MSVC++ (32-bit) directory tree
set MSVCPATH=\msvc

:: add MSVC++ binaries to path
set PATH=%msvcpath%\bin

:: set variable for the location of root of the ARX subdirectory tree
set ARXPATH=\acad\acrx

:: set variable for location of ADS include files
set ADSINC=\acad\ads

:: set variable for location of ARX include files
set ACRXINC=%arxpath%\inc

:: set variable for location of ARX library files
set ACRXLIB=%arxpath%\lib

:: set variable to tell MSVC++ where to look for include files
:: Comment this out if you don't want it to override your system setting
set INCLUDE=%msvcpath%\include;%adsinc%;%acrxinc%

:: set variable to tell MSVC++ where to look for library files
:: Comment this out if you don't want it to override your system setting
set LIB=%msvcpath%\lib;%acrxlib%

nmake -nologo -s -k -f mkarx.mak

:: restore old path
set PATH=%OLDPATH%

:: clean up environment space
set INFILE=
set OLDPATH=
set MSVCPATH=
set ARXPATH=
set ADSINC=
set ACRXINC=
set ACRXLIB=
:: Uncomment the following if you don't want INCLUDE and LIB set
:: set INCLUDE=
:: set LIB=

goto end

:noname
echo syntax is
echo mkarx [filename with no extension]

:end
