/***************************************************************************

	Department-Employee Form Application:
	This program shows how to build a simple data entry form.
	
	Q+E Software, Inc
	5540 Centerview Drive
	Suite 324
	Raleigh, NC  27606
		
	Tech Support : (919) 851-1152
	Fax          : (919) 859-9337
	BBS          : (919) 851-1381
	CompuServe   : GO QESOFT
		
***************************************************************************/

#include <windows.h>		/* required for all Windows applications */
#include "form.h"		/* specific to this program */
#include "..\include\qelib.h"	/* function prototypes */

int FillDeptForm (HWND);
int FillEmpForm (HWND);
int FillDeptEmpForm (HWND);

/* Global variables */

HANDLE	hInst;			/* current instance */
HWND	hWnd;			/* Main window handle. */

int	hdbc;			/* Handle to Database Connection */
int	hstmt;			/* Handle to SQL Statement */
int	hstmt2;			/* Handle to SQL Statement */
char	sql[1024];		/* SQL Statement Text*/
char	dir[80];		/* Data directory */
int	mode;			/* 0 if UPDATING or 1 if INSERTING */

char	DeptName[20];		/* Department name */
char	DeptID[10];		/* Department ID */
char	LocID[10];		/* Location ID */
char	MgrID[10];		/* Manager ID */

char	FirstName[15];		/* First name */
char	LastName[15];		/* Last name */
char	EmpID[15];		/* Employee ID */
char	HireDate[30];		/* Hire Date */
char	Salary[15];		/* Salary */
char	Dept[15];		/* Department */
char	Exempt[5];		/* Exempt */
char	FullName[64];		/* Full name */

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;			/* current instance */
HANDLE hPrevInstance;			/* previous instance */
LPSTR lpCmdLine;			/* command line */
int nCmdShow;				/* show-window type (open/icon) */
{
	MSG msg;			/* message */

	if (!hPrevInstance)		 /* Other instances of app running? */
	if (!InitApplication(hInstance)) /* Initialize shared things */
		return (FALSE);		 /* Exits if unable to initialize */

/* Perform initializations that apply to a specific instance */

	if (!InitInstance(hInstance, nCmdShow))
		return (FALSE);

/* Acquire and dispatch messages until a WM_QUIT message is received. */

	while (GetMessage(&msg,	   /* message structure */
		NULL,		   /* handle of window receiving the message*/
		NULL,		   /* lowest message to examine */
		NULL))		   /* highest message to examine */
	{
		TranslateMessage(&msg);	/* Translates virtual codes */
		DispatchMessage(&msg);	/* Dispatches message */
	}
	return (msg.wParam);   /* Returns value from PostQuitMessage */
}


BOOL InitApplication(hInstance)
HANDLE hInstance;			       /* current instance */
{
	WNDCLASS  wc;

/* Fill in window class structure with parameters that describe the */
/* main window.	*/

	wc.style = NULL;		/* Class style(s). */
	wc.lpfnWndProc = MainWndProc;	/* Function to retrieve messages */
					/* for windows of this class. */
	wc.cbClsExtra = 0;		/* No per-class extra data. */
	wc.cbWndExtra = 0;		/* No per-window extra data. */
	wc.hInstance = hInstance;	/* Application that owns the class. */
	wc.hIcon = LoadIcon(hInstance, "ExampleIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
	wc.lpszMenuName =  "FormMenu";/* Name of menu resource in RC file*/
	wc.lpszClassName = "FormWClass";/* Used in call to CreateWindow*/

/* Register the window class and return success/failure code. */

	return (RegisterClass(&wc));

}

BOOL InitInstance(hInstance, nCmdShow)
	HANDLE	hInstance;		/* Current instance identifier. */
	int	nCmdShow;		/* Param for first ShowWindow() call*/
{
	FARPROC lpProcDataDir;	        /* Pointer to the DataDir funtion */
	int	result;			/* Result from dialog procedure */

/* Save the instance handle in global variable, which will be used in */
/* many subsequence calls from this application to Windows. */

	hInst = hInstance;

/* Create a main window for this application instance. */

	hWnd = CreateWindow(
		"FormWClass",	/* See RegisterClass() call. */
		"Sample Forms",		/* Text for win title bar */
		WS_OVERLAPPEDWINDOW,	/* Window style. */
		CW_USEDEFAULT,		/* Default horicontal pos. */
		CW_USEDEFAULT,		/* Default vertical position */
		200,			/* Width. */
		45,			/* Height. */
		NULL,			/* Overlapped windows have no parent*/
		NULL,			/* Use the window class menu. */
		hInstance,		/* This instance owns this window. */
		NULL			/* Pointer not needed. */
		);

/* If window could not be created, return "failure" */

	if (!hWnd)
		return (FALSE);

/* Make the window visible; update its client area */

	ShowWindow(hWnd, nCmdShow);  /* Show the window */
	UpdateWindow(hWnd);          /* Sends WM_PAINT message */

/* Find out which directory contains the data files */
	
	lpProcDataDir = MakeProcInstance(DataDirProc, hInst);
	result=DialogBox(hInst,	"DataDirBox", hWnd, lpProcDataDir);
	FreeProcInstance(lpProcDataDir);
	return (result);	

}

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;				  /* window handle */
unsigned message;			  /* type of message */
WORD wParam;				  /* additional information */
LONG lParam;				  /* additional information */
{
	FARPROC lpProcAbout;	/* pointer to the "About" function */
	FARPROC lpProcForm;	/* pointer to the form functions */
	int	result;		/* Result from dialog procedure */
	char	*ptr;		/* Pointer to error text */

	switch (message) {
	case WM_CREATE:
		
/* Initialize QELIB */
		
		if (qeLibInit() != qeSUCCESS) goto err;
		
/* Connect to database */
		
		hdbc = qeConnect ("DSN=QEDBF");
		if (hdbc == 0) goto err;	/* Check for error */
		
/* Turn on random fetching.  This allows us to use qeFetchPrev. */
		
		qeSetSelectOptions (hdbc, qeFETCH_ANY_DIR);
			
		break;
		
	case WM_COMMAND:	   /* message: command from application menu*/
		switch (wParam) {
		case IDM_ABOUT:
			lpProcAbout = MakeProcInstance(About, hInst);

			DialogBox(hInst,	/* current instance */
			"AboutBox",		/* resource to use */
			hWnd,			/* parent handle */
			lpProcAbout);		 /* About() instance address*/

			FreeProcInstance(lpProcAbout);
			break;

/* Pop-up the Department form */
			
		case IDM_DEPT:
			lpProcForm = MakeProcInstance(DeptFormProc, hInst);
			result=DialogBox(hInst,	"DEPT_FORM", hWnd,lpProcForm);
			FreeProcInstance(lpProcForm);
			break;
		
/* Pop-up the Employee form */
			
		case IDM_EMP:
			lpProcForm = MakeProcInstance(EmpFormProc, hInst);
			result=DialogBox(hInst,	"EMP_FORM", hWnd,lpProcForm);
			FreeProcInstance(lpProcForm);
			break;
		
/* Pop-up the Department-Employee form */
			
		case IDM_DEPTEMP:
			lpProcForm = MakeProcInstance(DeptEmpFormProc, hInst);
			result=DialogBox(hInst, "DEPTEMP_FORM", hWnd,
				lpProcForm);
			FreeProcInstance(lpProcForm);
			break;
		
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));

		}
		break;
		
	case WM_DESTROY:		  /* message: window being destroyed*/
	
/* Disconnect from the database system (QEDBF) */
		
		qeDisconnect(hdbc);
		
/* Terminate QELIB Session */
		
		qeLibTerm ();
		
/* Post QUIT message */
		
		PostQuitMessage(0);
		break;

	default:			  /* Passes it on if unproccessed */
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
	
err:	ptr = qeErrMsg();
	MessageBox(hWnd, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	return(FALSE);
}

BOOL FAR PASCAL DataDirProc(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box*/
		return (TRUE);

	case WM_COMMAND:			/* received a command */
		if (wParam == IDOK) {		/* "OK" box selected */
			GetDlgItemText(hDlg, DATADIR, dir, 80);
			if (dir[lstrlen(dir)-1] != '\\') lstrcat (dir, "\\");
			EndDialog(hDlg, TRUE);	/* Exits the dialog box	*/
			return (TRUE);
		}
		
		if (wParam == IDCANCEL) {	/* Cancel command */
			EndDialog(hDlg, FALSE);	/* Exits the dialog box	*/
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
}

BOOL FAR PASCAL DeptFormProc(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	char	*ptr;		/* Pointer to error message text */
	
	switch (message) {
		
	case WM_INITDIALOG:

/* Build the SQL Statement */
		
		lstrcpy (sql, "SELECT * FROM ");
		lstrcat (sql, dir);
		lstrcat (sql, "DEPT.DBF");
		
/* Execute the SQL statement */
		
		hstmt = qeExecSQL (hdbc, sql);
		if (hstmt == 0) goto err;	/* Check for error */
		
/* Fetch the first record */
		
		if (qeFetchNext(hstmt)) break;
		
/* Fill the form */
		
		if (FillDeptForm(hDlg) == FALSE) goto err;
		
/* Set mode to update */
		
		mode = UPDATING;
		
		SetFocus (GetDlgItem (hDlg, NEXT));
		return (FALSE);

	case WM_COMMAND:			/* received a command */
		switch (wParam) {
		
		
/* NEXT BUTTON */
			
		case NEXT:
			
/* Fetch the next record.  Break out of this SWITCH if no more records. */
			
			if (qeFetchNext(hstmt)) {
				MessageBox (hDlg, "No more records.", NULL,
					    MB_OK);
				break;
			}
		
/* Fill the department form with the new record */
			
			if (FillDeptForm(hDlg) == FALSE) goto err;
			
/* If the user is in INSERT mode, then abort INSERT & switch to UPDATE mode */
			
			if (mode == INSERTING) {
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
			}
			return (TRUE);
			

/* PREV BUTTON */
			
		case PREV:
			
/* Fetch the previous record.  Break out of this SWITCH if no more records. */
			
			if (qeFetchPrev(hstmt)) {
				MessageBox (hDlg, "No more records.", NULL,
					    MB_OK);
				break;
			}
			
/* Fill the department form with the new record */
			
			if (FillDeptForm(hDlg) == FALSE) goto err;
			
/* If the user is in INSERT mode, then abort INSERT & switch to UPDATE mode */
			
			if (mode == INSERTING) {
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
			}
			return (TRUE);

			
/* UPDATE BUTTON */
			
		case UPDATE:

/* Get the current values out of the form */
			
UPDATE_REC:		GetDlgItemText (hDlg, DEPTID, DeptID, 10);
			GetDlgItemText (hDlg, NAME, DeptName, 20);
			GetDlgItemText (hDlg, LOC, LocID, 10);
			GetDlgItemText (hDlg, MGR, MgrID, 10);
			
/* Update each field (column) */
			
			if (qePutChar (hstmt, 1, "", DeptID)) goto err;
			if (qePutChar (hstmt, 2, "", DeptName)) goto err;
			if (qePutChar (hstmt, 3, "", LocID)) goto err;
			if (qePutChar (hstmt, 4, "", MgrID)) goto err;
			if (qeRecUpdate (hstmt)) goto err;
			
			return(TRUE);
			
			
/* NEW/INSERT BUTTON */
			
		case NEW:
			if (mode == UPDATING) {
/* Clear text boxes */

				SetDlgItemText (hDlg, NAME,  "");
				SetDlgItemText (hDlg, DEPTID, "");
				SetDlgItemText (hDlg, LOC, "");
				SetDlgItemText (hDlg, MGR, "");
				
/* Set mode to INSERT */
				
				SetDlgItemText(hDlg, NEW, "Insert");
				mode = INSERTING;
				SetFocus (GetDlgItem (hDlg, NAME));
				return (FALSE);
				
			}
			else {
			
/* Create a NEW record buffer */
				
				if (qeRecNew (hstmt, qeRecNum(hstmt))) 
					goto err;

/* Update the new record */
				
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
				goto UPDATE_REC;
			}

			
/* DELETE BUTTON */
		
		case DELETE:
			
/* Delete the current record */
			
			if (qeRecDelete (hstmt)) goto err;
			
/* Fetch the next record.  If that fails then fetch the previous record. */
			
			if (qeFetchNext(hstmt)) {
				if (qeFetchPrev(hstmt)) break;
			}
			
/* Fill the form */
			
			if (FillDeptForm(hDlg) == FALSE) goto err;
			return (TRUE);
			
/* EXIT BUTTON */
		
		case EXIT:
		case IDCANCEL:
			qeEndSQL (hstmt);
			EndDialog(hDlg, TRUE);	/* Exits the dialog box	*/
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
	
err:	ptr = qeErrMsg();
	MessageBox(hDlg, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	return (FALSE);
}

BOOL FAR PASCAL EmpFormProc(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	char	*ptr;		/* Pointer to error message text */
		
	switch (message) {
		
	case WM_INITDIALOG:

/* Build SQL Statement */
		
		lstrcpy (sql, "SELECT FIRST_NAME, LAST_NAME, EMP_ID, ");
		lstrcat (sql, "HIRE_DATE, SALARY, DEPT, EXEMPT FROM ");
		lstrcat (sql, dir);
		lstrcat (sql, "EMP.DBF");
		
/* Execute the SQL statement */
		
		hstmt = qeExecSQL (hdbc, sql);
		if (hstmt == 0) goto err;	/* Check for error */
		
/* Fetch the first record */
		
		if (qeFetchNext(hstmt)) break;
		
/* Fill the form */
		
		if (FillEmpForm(hDlg) == FALSE) goto err;
		
/* Set mode to update */
		
		mode = UPDATING;
		
		SetFocus (GetDlgItem (hDlg, NEXT));
		return (FALSE);

	case WM_COMMAND:			/* received a command */
		switch (wParam) {
		
		
/* NEXT BUTTON */
			
		case NEXT:
			if (qeFetchNext(hstmt)) break;
			if (FillEmpForm(hDlg) == FALSE) goto err;
			if (mode == INSERTING) {
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
			}
			return (TRUE);
			

/* PREV BUTTON */
			
		case PREV:
			if (qeFetchPrev(hstmt)) break;
			if (FillEmpForm(hDlg) == FALSE) goto err;
			if (mode == INSERTING) {
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
			}
			return (TRUE);

			
/* UPDATE BUTTON */
			
		case UPDATE:

/* Get the current values out of the form */
			
UPDATE_REC:		GetDlgItemText (hDlg, FIRST, FirstName, 15);
			GetDlgItemText (hDlg, LAST, LastName, 15);
			GetDlgItemText (hDlg, EMPID, EmpID, 15);
			GetDlgItemText (hDlg, HIRE, HireDate, 30);
			GetDlgItemText (hDlg, SALARY, Salary, 15);
			GetDlgItemText (hDlg, DEPT, Dept, 15);
			GetDlgItemText (hDlg, EXEMPT, Exempt, 5);

/* Update each field (column) */
			
			if (qePutChar (hstmt, 1, "", FirstName)) goto err;
			if (qePutChar (hstmt, 2, "", LastName)) goto err;
			if (qePutChar (hstmt, 3, "", EmpID)) goto err;
			if (qePutChar (hstmt, 4, "m//d//yy",
				HireDate)) goto err;
			if (qePutChar (hstmt, 5, "", Salary)) goto err;
			if (qePutChar (hstmt, 6, "", Dept)) goto err;
			if (qePutChar (hstmt, 7, "", Exempt)) goto err;
			if (qeRecUpdate (hstmt)) goto err;
			
			return(TRUE);

/* NEW/INSERT BUTTON */
			
		case NEW:
			if (mode == UPDATING) {
/* Clear text boxes */

				SetDlgItemText (hDlg, FIRST, "");
				SetDlgItemText (hDlg, LAST, "");
				SetDlgItemText (hDlg, EMPID, "");
				SetDlgItemText (hDlg, HIRE, "");
				SetDlgItemText (hDlg, SALARY, "");
				SetDlgItemText (hDlg, DEPT, "");
				SetDlgItemText (hDlg, EXEMPT, "");
				
/* Set mode to insert */
				
				SetDlgItemText(hDlg, NEW, "Insert");
				mode = INSERTING;
				SetFocus (GetDlgItem (hDlg, FIRST));
				return (FALSE);
				
			}
			else {
				
/* Create a NEW record buffer */
				
				if (qeRecNew (hstmt, qeRecNum(hstmt))) 
					goto err;

/* Update the new record */
				
				SetDlgItemText(hDlg, NEW, "New");
				mode = UPDATING;
				goto UPDATE_REC;
			}

			
/* DELETE BUTTON */
		
		case DELETE:
			
/* Delete the current record */
			
			if (qeRecDelete (hstmt)) goto err;
			
/* Fetch the next record.  If that fails then fetch the previous record. */
			
			if (qeFetchNext(hstmt)) {
				if (qeFetchPrev(hstmt)) break;
			}
			
/* Fill the form */
			
			if (FillEmpForm(hDlg) == FALSE) goto err;
			return (TRUE);
			
			
/* EXIT BUTTON */
		
		case EXIT:
		case IDCANCEL:
			qeEndSQL (hstmt);
			EndDialog(hDlg, TRUE);	/* Exits the dialog box	*/
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
	
err:	ptr = qeErrMsg();
	MessageBox (hDlg, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	return (FALSE);
}

BOOL FAR PASCAL DeptEmpFormProc(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	char	*ptr;		/* Pointer to error message text */
		
	switch (message) {
		
	case WM_INITDIALOG:

/* Build SQL Statement */
		
		lstrcpy (sql, "SELECT * FROM ");
		lstrcat (sql, dir);
		lstrcat (sql, "DEPT.DBF");
		
/* Execute the SQL statement */
		
		hstmt = qeExecSQL (hdbc, sql);
		if (hstmt == 0) goto err;	/* Check for error */
		
/* Fetch the first record */
		
		if (qeFetchNext(hstmt)) break;
		
/* Fill the form */
		
		if (FillDeptEmpForm(hDlg) == FALSE) goto err;
		
		SetFocus (GetDlgItem (hDlg, NEXT));
		return (FALSE);

	case WM_COMMAND:			/* received a command */
		switch (wParam) {
		
		
/* NEXT BUTTON */
			
		case NEXT:
			if (qeFetchNext(hstmt)) break;
			if (FillDeptEmpForm(hDlg) == FALSE) goto err;
			return (TRUE);
			

/* PREV BUTTON */
			
		case PREV:
			if (qeFetchPrev(hstmt)) break;
			if (FillDeptEmpForm(hDlg) == FALSE) goto err;
			return (TRUE);

			
/* EXIT BUTTON */
		
		case EXIT:
		case IDCANCEL:
			qeEndSQL (hstmt);
			EndDialog(hDlg, TRUE);	/* Exits the dialog box	*/
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
	
err:	ptr = qeErrMsg();
	MessageBox (hDlg, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	return (FALSE);
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box*/
		return (TRUE);

	case WM_COMMAND:			/* received a command */
		if (wParam == IDOK		/* "OK" box selected? */
		|| wParam == IDCANCEL) {	/* System menu close command*/
			EndDialog(hDlg, TRUE);	/* Exits the dialog box */
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
}

int FillDeptForm (HWND hDlg) {
	
	char	*ptr;
	
	ptr = qeValChar(hstmt, 1, "", 10);		 /* Get dept id */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (DeptID, ptr);
	
	ptr = qeValChar(hstmt, 2, "", 20);		 /* Get dept name */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (DeptName, ptr);
	
	ptr = qeValChar(hstmt, 3, "", 10);		 /* Get loc id */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (LocID, ptr);
	
	ptr = qeValChar(hstmt, 4, "", 10);		 /* Get mgr id */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (MgrID, ptr);

/* Fill text boxes */
	
	SetDlgItemText (hDlg, NAME,  DeptName);
	SetDlgItemText (hDlg, DEPTID,DeptID);
	SetDlgItemText (hDlg, LOC,   LocID);
	SetDlgItemText (hDlg, MGR,   MgrID);
	return (TRUE);

}

int FillEmpForm (HWND hDlg) {
	
	char	*ptr;
	
	ptr = qeValChar(hstmt, 1, "", 0);		 /* Get first name */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (FirstName, ptr);
	
	ptr = qeValChar(hstmt, 2, "",0);		 /* Get last name */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (LastName, ptr);
	
	ptr = qeValChar(hstmt, 3, "",0);		 /* Get employee ID */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (EmpID, ptr);
	
	ptr = qeValChar(hstmt, 4, "", 0);		 /* Get hire date */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (HireDate, ptr);
	
	ptr = qeValChar(hstmt, 5, "", 0);		 /* Get Salary */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (Salary, ptr);
	
	ptr = qeValChar(hstmt, 6, "", 0);		 /* Get dept */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (Dept, ptr);

	ptr = qeValChar(hstmt, 7, "", 0);		 /* Get exempt */
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (Exempt, ptr);

/* Fill text boxes */
	
	SetDlgItemText (hDlg, FIRST, FirstName);
	SetDlgItemText (hDlg, LAST, LastName);
	SetDlgItemText (hDlg, EMPID, EmpID);
	SetDlgItemText (hDlg, HIRE, HireDate);
	SetDlgItemText (hDlg, SALARY, Salary);
	SetDlgItemText (hDlg, DEPT, Dept);
	SetDlgItemText (hDlg, EXEMPT, Exempt);
	return (TRUE);

}

int FillDeptEmpForm (HWND hDlg) {
	
	char	*ptr;
	
/* Get Department ID */
	
	ptr = qeValChar(hstmt, 1, "", 10);
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (DeptID, ptr);
	
/* Get Department Name */
	
	ptr = qeValChar(hstmt, 2, "", 20);
	if (qeErr() < -2 || qeErr() > 0) return (FALSE); /* Check for error */
	lstrcpy (DeptName, ptr);
	
/* Build SQL Statement */
		
	lstrcpy (sql, "SELECT FIRST_NAME-(' '+LAST_NAME), FIRST_NAME, ");
	lstrcat (sql, "LAST_NAME, EMP_ID FROM ");
	lstrcat (sql, dir);
	lstrcat (sql, "EMP.DBF WHERE DEPT = '");
	lstrcat (sql, DeptID);
	lstrcat (sql, "'");
		
/* Execute the SQL statement */
		
	hstmt2 = qeExecSQL (hdbc, sql);
	if (hstmt2 == 0) return (FALSE);	/* Check for error */
	
/* Fill in department name box */
	
	SetDlgItemText (hDlg, NAME, DeptName);
		
/* Remove any existing names from the listbox */
	
	SendDlgItemMessage (hDlg, FULL, LB_RESETCONTENT, 0, 0L);
	
/* Fill in list box with employees */
	
	while (qeFetchNext(hstmt2) == 0) {
		ptr = qeValChar(hstmt2, 1, "", 0);	/* Get full name */
		if (qeErr() < -2 || qeErr() > 0) return (FALSE);
		lstrcpy (FullName, ptr);
		SendDlgItemMessage (hDlg, FULL, LB_ADDSTRING, 0,
			(long) FullName);
	}
	
/* End SQL statement */
	
	qeEndSQL(hstmt2);
	
	return (TRUE);

}

