
DynamicLinkLibrary variableByteSubclass: #QELIBDLL
  classVariableNames: ''
  poolDictionaries: ''  !


!QELIBDLL class methods !

fileName
        "Answer the receiver's file name."
     ^'QELIB'! !



!QELIBDLL methods !
   
checkError
    | err errmsg|

" Q+E Database Library
   Copyright 1991-1993 Q+E Software.
   Smalltalk class written by David Motsinger "

    err := self qeErr.
    err=0
       ifTrue:[^false].
    errmsg := self qeErrMsg.
    MessageBox message: errmsg.
    ^true!
 
qeAppendSQL: hdbc partialstmt: aString
    <api: qeAppendSQL short struct short>
    ^self invalidArgument!
 
qeApplyAll: hstmt
    <api: qeApplyAll short short>
    ^self invalidArgument!
   
qeBeginTran: hdbc
    <api: qeBeginTran short short>
    ^self invalidArgument!
   
qeClauseGet2: hstmt whichclause: anInt1
   <api: qeClauseGet short short ulong>
   ^self invalidArgument!
   
qeClauseGet: hstmt whichclause: anInt1
    | ptr temp |
    ptr := self qeClauseGet2: hstmt whichclause: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeClearParam: hstmt paramnum: anInt1
   <api: qeClearParam short short short>
   ^self invalidArgument!

qeColAlias2: hstmt colnum: anInt1
   <api: qeColAlias short short ulong>
   ^self invalidArgument!
   
qeColAlias: hstmt colnum: anInt1
    | ptr temp |
    ptr := self qeColAlias2: hstmt colnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeColDateEnd: hstmt colnum: anInt1
   <api: qeColDateEnd short short short>
   ^self invalidArgument!
 
qeColDateStart: hstmt colnum: anInt1
   <api: qeColDateStart short short short>
   ^self invalidArgument!
 
qeColDBType: hstmt colnum: anInt1
   <api: qeColDBType short short short>
   ^self invalidArgument!
   
qeColDBTypeName2: hstmt colnum: anInt1
   <api: qeColDBTypeName short short ulong>
   ^self invalidArgument!
   
qeColDBTypeName: hstmt colnum: anInt1
    | ptr temp |
    ptr := self qeColDBTypeName2: hstmt colnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeColExpr2: hstmt colnum: anInt1
   <api: qeColExpr short short ulong>
   ^self invalidArgument!
   
qeColExpr: hstmt colnum: anInt1
    | ptr temp |
    ptr := self qeColExpr2: hstmt colnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeColName2: hstmt colnum: anInt1
   <api: qeColName short short ulong>
   ^self invalidArgument!
  
qeColName: hstmt colnum: anInt1
    | ptr temp |
    ptr := self qeColName2: hstmt colnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
 
qeColPrecision: hstmt colnum: anInt1
   <api: qeColPrecision short short short>
   ^self invalidArgument!
 
qeColScale: hstmt colnum: anInt1
   <api: qeColScale short short short>
   ^self invalidArgument!
 
qeColType: hstmt colnum: anInt1
   <api: qeColType short short short>
   ^self invalidArgument!
   
qeColTypeAttr: hstmt colnum: anInt1 attribute: anInt2
   <api: qeColTypeAttr short short short short>
   ^self invalidArgument!

qeColumns: hdbc tablename: aString
    <api: qeColumns short struct short>
    ^self invalidArgument!
 
qeColWidth: hstmt colnum: anInt1
   <api: qeColWidth short short long>
   ^self invalidArgument!
  
qeCommit: hdbc
    <api: qeCommit short short>
    ^self invalidArgument!
 
qeConnect: constring
    <api: qeConnect struct short>
    ^self invalidArgument!
 
qeDatabases: hdbc
    <api: qeDatabases short short>
    ^self invalidArgument!
 
qeDataLen: hstmt
    <api: qeDataLen short long>
    ^self invalidArgument!
   
qeDBErr
    <api: qeDBErr long>
    ^self invalidArgument!

qeDisconnect: hdbc
    <api: qeDisconnect short short>
    ^self invalidArgument!

qeEndSQL: hstmt
    <api: qeEndSQL short short>
    ^self invalidArgument!

qeErr
    <api: qeErr short>
    ^self invalidArgument!
   
qeErrMsg
    | ptr temp |
    ptr := self qeErrMsg2.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
   
qeErrMsg2
   <api: qeErrMsg ulong>
   ^self invalidArgument!
  
qeExecSQL: hdbc stmt: aString
    <api: qeExecSQL short struct short>
    ^self invalidArgument!
  
qeFetchLogClose: hstmt
    <api: qeFetchLogClose short short>
    ^self invalidArgument!
  
qeFetchNext: hstmt
    <api: qeFetchNext short short>
    ^self invalidArgument!
  
qeFetchNumRecs: hstmt
    <api: qeFetchNumRecs short long>
    ^self invalidArgument!
 
qeFetchPrev: hstmt
    <api: qeFetchPrev short short>
    ^self invalidArgument!
  
qeFetchRandom: hstmt recnum: anInt1
   <api: qeFetchRandom short long short>
   ^self invalidArgument!

qeGetAutoUpdate: hdbc
    <api: qeGetAutoUpdate short short>
    ^self invalidArgument!

qeGetIsolationLevel: hdbc
    <api: qeGetIsolationLevel short short>
    ^self invalidArgument!

qeGetLockOptions: hdbc
    <api: qeGetLockOptions short short>
    ^self invalidArgument!

qeGetLoginTimeout
    <api: qeGetLoginTimeout short>
    ^self invalidArgument!

qeGetMaxRows: hdbc
    <api: qeGetMaxRows short long>
    ^self invalidArgument!

qeGetODBCHdbc: hdbc
    <api: qeODBCHdbc short long>
    ^self invalidArgument!

qeGetODBCHenv
    <api: qeGetODBCHenv long>
    ^self invalidArgument!

qeGetODBCHstmt: hdbc
    <api: qeGetODBCHstmt short long>
    ^self invalidArgument!

qeGetODBCInfoChar2: hdbc option: anInt2
   <api: qeGetODBCInfoChar short short ulong>
   ^self invalidArgument!
   
qeGetODBCInfoChar: hdbc option: anInt2
    | ptr temp |
    ptr := self qeGetODBCInfoChar2: hdbc option: anInt2.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeGetODBCLong: hdbc option: anInt1
    <api: qeGetODBCLong short short long>
    ^self invalidArgument!

qeGetOneHstmtPerHdbcOptions: hdbc
    <api: qeGetOneHstmtPerHdbcOptions short short>
    ^self invalidArgument!

qeGetQueryTimeout: hdbc
    <api: qeGetQueryTimeout short long>
    ^self invalidArgument!

qeGetSelectOptions: hdbc
    <api: qeGetSelectOptions short long>
    ^self invalidArgument!

qeGetSupportedIsolationLevels: hdbc
    <api: qeGetSupportedIsolationLevels short short>
    ^self invalidArgument!

qeGetTableCaching: hdbc
    <api: qeGetTableCaching short short>
    ^self invalidArgument!

qeGetTraceOptions
    <api: qeGetTraceOptions short>
    ^self invalidArgument!

qeLibInit
    <api: qeLibInit short>
    ^self invalidArgument!

qeLibTerm
    <api: qeLibTerm short>
    ^self invalidArgument!

qeMoreResults: hstmt
    <api: qeMoreResults short short>
    ^self invalidArgument!

qeNativeSQL2: hstmt
   <api: qeNativeSQL short ulong>
   ^self invalidArgument!
   
qeNativeSQL: hstmt
    | ptr temp |
    ptr := self qeNativeSQL2: hstmt.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeNumCols: hstmt
    <api: qeNumCols short short>
    ^self invalidArgument!
  
qeNumModRecs: hstmt
    <api: qeNumModRecs short long>
    ^self invalidArgument!
 
qeNumParams: hstmt
    <api: qeNumParams short short>
    ^self invalidArgument!

qeParamNum: hstmt paramname: aString
    <api: qeParamNum short struct short>
    ^self invalidArgument!
 
qeProcedureColumns: hstmt procname: aString
    <api: qeProcedureColumns short struct short>
    ^self invalidArgument!
 
qePutBinary: hstmt colnum: anInt1 newval: aString vallen: anInt2
    <api: qePutBinary short short struct long short>
    ^self invalidArgument!
 
qePutChar: hstmt colnum: anInt1 fmtstring: aString1 newval: aString2
    <api: qePutChar short short struct struct short>
    ^self invalidArgument!
 
qePutDecimal: hstmt colnum: anInt1 precision: anInt2 sacle: anInt3 newval: aString2
    <api: qePutDecimal short short short short struct short>
    ^self invalidArgument!
 
qePutDouble: hstmt colnum: anInt1 newval: aDouble
    <api: qePutDouble short short double short>
    ^self invalidArgument!
 
qePutInt: hstmt colnum: anInt1 newval: anInt2
    <api: qePutInt short short short short>
    ^self invalidArgument!
 
qePutLong: hstmt colnum: anInt1 newval: aLong
    <api: qePutLong short short long short>
    ^self invalidArgument!
 
qePutNull: hstmt colnum: anInt1
    <api: qePutLong short short short>
    ^self invalidArgument!
 
qeQBEPrepare: hstmt
    <api: qeQBEPrepare short short>
    ^self invalidArgument!

qeQryAllocate: hdbc statement: aString
    <api: qeQryAllocate short struct short>
    ^self invalidArgument!

qeQryBuilder: hqry parent: anInt1 flags: anInt2 initdlg: anInt3
    <api: qeQryBuilder short short short short short>
    ^self invalidArgument!

qeQryFree: hqry
    <api: qeQryFree short short>
    ^self invalidArgument!

qeQryGetFileName2: hqry
   <api: qeQryGetFileName short ulong>
   ^self invalidArgument!
   
qeQryGetFileName: hqry
    | ptr temp |
    ptr := self qeQryGetFileName2: hqry.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetFileOffset: hqry
    <api: qeQryGetFileOffset short long>
    ^self invalidArgument!

qeQryGetHdbc: hqry
    <api: qeQryGetHdbc short short>
    ^self invalidArgument!

qeQryGetNumParams: hqry
    <api: qeQryGetNumParams short short>
    ^self invalidArgument!

qeQryGetParamDefault2: hqry paramnum: anInt1
   <api: qeQryGetParamDefault short short ulong>
   ^self invalidArgument!
   
qeQryGetParamDefault: hqry paramnum: anInt1
    | ptr temp |
    ptr := self qeQryGetParamDefault2: hqry paramnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetParamFormat2: hqry paramnum: anInt1
   <api: qeQryGetParamFormat short short ulong>
   ^self invalidArgument!
   
qeQryGetParamFormat: hqry paramnum: anInt1
    | ptr temp |
    ptr := self qeQryGetParamFormat2: hqry paramnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetParamName2: hqry paramnum: anInt1
   <api: qeQryGetParamName short short ulong>
   ^self invalidArgument!
   
qeQryGetParamName: hqry paramnum: anInt1
    | ptr temp |
    ptr := self qeQryGetParamName2: hqry paramnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetParamPrompt2: hqry paramnum: anInt1
   <api: qeQryGetParamPrompt short short ulong>
   ^self invalidArgument!
   
qeQryGetParamPrompt: hqry paramnum: anInt1
    | ptr temp |
    ptr := self qeQryGetParamPrompt2: hqry paramnum: anInt1.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetParamType: hqry paramnum: anInt1
    <api: qeQryGetParamType short short short>
    ^self invalidArgument!

qeQryGetSource2: hqry
   <api: qeQryGetSource short ulong>
   ^self invalidArgument!
   
qeQryGetSource: hqry
    | ptr temp |
    ptr := self qeQryGetSource2: hqry.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryGetStmt2: hqry
   <api: qeQryGetStmt short ulong>
   ^self invalidArgument!
   
qeQryGetStmt: hqry
    | ptr temp |
    ptr := self qeQryGetStmt2: hqry.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeQryOpenQueryFile: constring
    <api: qeQryOpenQueryFile struct short>
    ^self invalidArgument!
 
qeQryPrepare: hqry
    <api: qeQryPrepare short short>
    ^self invalidArgument!

qeQrySaveQueryFile: hqry pathname: aString
    <api: qeQrySaveQueryFile short struct short>
    ^self invalidArgument!
 
qeQrySetFileName: hqry filename: aString
    <api: qeQrySetFileName short struct short>
    ^self invalidArgument!
 
qeQrySetHdbc: hqry hdbc: anInt1
    <api: qeQrySetHdbc short short short>
    ^self invalidArgument!

qeQrySetNumParams: hqry numparams: anInt1
    <api: qeQrySetNumParams short short short>
    ^self invalidArgument!

qeQrySetParamDefault: hqry paramnum: anInt1 paramdefault: aString
    <api: qeQrySetParamDefault short short struct short>
    ^self invalidArgument!

qeQrySetParamFormat: hqry paramnum: anInt1 paramfmt: aString
    <api: qeQrySetParamFormat short short struct short>
    ^self invalidArgument!

qeQrySetParamName: hqry paramnum: anInt1 paramname: aString
    <api: qeQrySetParamName short short struct short>
    ^self invalidArgument!

qeQrySetParamPrompt: hqry paramnum: anInt1 paramprompt: aString
    <api: qeQrySetParamPrompt short short struct short>
    ^self invalidArgument!

qeQrySetParamType: hqry paramnum: anInt1 paramtype: anInt2
    <api: qeQrySetParamType short short short short>
    ^self invalidArgument!

qeQrySetStmt: hqry stmt: aString
    <api: qeQrySetStmt short struct short>
    ^self invalidArgument!

qeQrySetSource: hqry hdbc: anInt1
    <api: qeQrySetSource short short short>
    ^self invalidArgument!

qeRecClearConditions: hstmt
    <api: qeRecClearConditions short short>
    ^self invalidArgument!

qeRecDelete: hstmt
    <api: qeRecDelete short short>
    ^self invalidArgument!

qeRecFind: hstmt startpos: anInt1 flags: anInt2
    <api: qeRecFind short short short short>
    ^self invalidArgument!

qeRecGetKey: hstmt colnum: anInt1
    <api: qeRecGetKey short short short>
    ^self invalidArgument!

qeRecLock: hstmt
    <api: qeRecLock short short>
    ^self invalidArgument!

qeRecNew: hstmt recnum: aLong
    <api: qeRecNew short long short>
    ^self invalidArgument!

qeRecNum: hstmt
    <api: qeRecNum short long>
    ^self invalidArgument!

qeRecSetConditionBinary: hstmt colnum: anInt1 operator: anInt2 value: aString length: aLong
    <api: qeRecSetConditionBinary short short short struct long short>
    ^self invalidArgument!

qeRecSetConditionChar: hstmt colnum: anInt1 operator: anInt2 value: aString casesens: anInt3
    <api: qeRecSetConditionChar short short short struct short short>
    ^self invalidArgument!

qeRecSetConditionDecimal: hstmt colnum: anInt1 operator: anInt2 value: aString precision: anInt3 scale: anInt4
    <api: qeRecSetConditionDecimal short short short struct short short short>
    ^self invalidArgument!

qeRecSetConditionDouble: hstmt colnum: anInt1 operator: anInt2 value: aDouble
    <api: qeRecSetConditionDouble short short short double short>
    ^self invalidArgument!

qeRecSetConditionInt: hstmt colnum: anInt1 operator: anInt2 value: anInt3
    <api: qeRecSetConditionInt short short short short short>
    ^self invalidArgument!

qeRecSetConditionLong: hstmt colnum: anInt1 operator: anInt2 value: aLong
    <api: qeRecSetConditionLong short short short long short>
    ^self invalidArgument!

qeRecSetConditionNull: hstmt colnum: anInt1 operator: anInt2
    <api: qeRecSetConditionNull short short short short>
    ^self invalidArgument!

qeRecSetKey: hstmt colnum: anInt1 value: anInt2
    <api: qeRecSetKey short short short short>
    ^self invalidArgument!

qeRecState: hstmt
    <api: qeRecState short short>
    ^self invalidArgument!

qeRecUndo: hstmt
    <api: qeRecUndo short short>
    ^self invalidArgument!

qeRecUpdate: hstmt
    <api: qeRecUpdate short short>
    ^self invalidArgument!

qeRollback: hdbc
    <api: qeRollback short short>
    ^self invalidArgument!
 
qeSetAutoUpdate: hdbc option: anInt1
    <api: qeSetAutoUpdate short short short>
    ^self invalidArgument!

qeSetCacheFileName: hdbc filename: aString
    <api: qeSetCacheFileName short struct short>
    ^self invalidArgument!

qeSetDB: hdbc database: aString
    <api: qeSetDB short struct short>
    ^self invalidArgument!
  
qeSetSQL: hdbc partialstmt: aString
    <api: qeSetSQL short struct short>
    ^self invalidArgument!
 
qeSetDriverTraceFile: hdbc filename: aString
    <api: qeSetDriverTraceFile short struct short>
    ^self invalidArgument!
 
qeSetIsolationLevel: hdbc level: anInt1
    <api: qeSetIsolationLevel short short short>
    ^self invalidArgument!
 
qeSetLockOptions: hdbc option: anInt1
    <api: qeSetLockOptions short short short>
    ^self invalidArgument!
 
qeSetLoginTimeout: seconds
    <api: qeSetLoginTimeout long short>
    ^self invalidArgument!
 
qeSetMaxRows: hdbc maxrows: aLong
    <api: qeSetMaxRows short long short>
    ^self invalidArgument!
 
qeSetODBCHdbc: odbchdbc
    <api: qeSetODBCHdbc struct short>
    ^self invalidArgument!
 
qeSetOneHstmtPerHdbcOptions: hdbc flags: aLong
    <api: qeSetOneHstmtPerHdbcOptions short long short>
    ^self invalidArgument!
 
qeSetParamBinary: hstmt paramnum: anInt1 paramval: aString paramlen: aLong
    <api: qeSetParamBinary short short struct long short>
    ^self invalidArgument!
 
qeSetParamChar: hstmt paramnum: anInt1 paramval: aString maxlen: aLong
    <api: qeSetParamChar short short struct long short>
    ^self invalidArgument!
 
qeSetParamDate: hstmt paramnum: anInt1 paramval: aString
    <api: qeSetParamDate short short struct short>
    ^self invalidArgument!
 
qeSetParamDateTime: hstmt paramnum: anInt1 paramval: aString precision: anInt2
    <api: qeSetParamDateTime short short struct short short>
    ^self invalidArgument!
 
qeSetParamDecimal: hstmt paramnum: anInt1 paramval: aString precision: anInt2 scale: anInt3
    <api: qeSetParamDecimal short short struct short short short>
    ^self invalidArgument!
 
qeSetParamDouble: hstmt paramnum: anInt1 paramval: aDouble
    <api: qeSetParamDouble short short double short>
    ^self invalidArgument!
 
qeSetParamInt: hstmt paramnum: anInt1 paramval: anInt2
    <api: qeSetParamInt short short short short>
    ^self invalidArgument!
 
qeSetParamLong: hstmt paramnum: anInt1 paramval: aLong
    <api: qeSetParamLong short short long short>
    ^self invalidArgument!
 
qeSetParamNull: hstmt paramnum: anInt1 paramtype: anInt2 precision: aLong scale: anInt3
    <api: qeSetParamNull short short short long short short>
    ^self invalidArgument!
 
qeSetParamTime: hstmt paramnum: anInt1 paramval: aString
    <api: qeSetParamTime short short struct short>
    ^self invalidArgument!
 
qeSetQueryTimeout: hdbc seconds: aLong
    <api: qeSetQueryTimeout short long short>
    ^self invalidArgument!
 
qeSetSelectOptions: hdbc flags: aLong
    <api: qeSetSelectOptions short long short>
    ^self invalidArgument!
 
qeSetSQL: hdbc partialstmt: aString
    <api: qeSetSQL short struct short>
    ^self invalidArgument!

qeSetTableCaching: hdbc setting: anInt1
    <api: qeSetTableCaching short short short>
    ^self invalidArgument!
 
qeSetTraceOptions: flags
    <api: qeSetTraceOptions short short>
    ^self invalidArgument!
 
qeSetupInfo
    | ptr temp |
    ptr := self qeSetupInfo2.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
 
qeSetupInfo2
   <api: qeSetupInfo ulong>
   ^self invalidArgument!

qeSources: option
    <api: qeSources short short>
    ^self invalidArgument!
 
qeSQLExecute: hstmt
    <api: qeSQLExecute short short>
    ^self invalidArgument!
 
qeSQLPrepare: hstmt stmt: aString
    <api: qeSQLPrepare short struct short>
    ^self invalidArgument!

qeTables: hdbc qualifier: aString1 user: aString2 table: aString3 flags: anInt
    <api: qeTables short struct struct struct short short>
    ^self invalidArgument!

qeTraceOff
    <api: qeTraceOff short>
    ^self invalidArgument!
 
qeTraceOn: file
    <api: qeTraceOn struct short>
    ^self invalidArgument!
  
qeTraceOn: file
    <api: qeTraceOn struct short>
    ^self invalidArgument!
  
qeTraceUser: tracestring
    <api: qeTraceUser struct short>
    ^self invalidArgument!
  
qeTypeInfo: hdbc
    <api: qeTypeInfo short short>
    ^self invalidArgument!
   
qeUndoAll: hstmt
    <api: qeUndoAll short short>
    ^self invalidArgument!
   
qeUniqueWhereClause2: hstmt
   <api: qeUniqueWhereClause short ulong>
   ^self invalidArgument!
   
qeUniqueWhereClause: hstmt
    | ptr temp |
    ptr := self qeUniqueWhereClause2: hstmt.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeValChar2: hstmt colnum: anInt1 fmtstring: aString maxlen: anInt2
   <api: qeValChar short short struct short ulong>
   ^self invalidArgument!
   
qeValChar: hstmt colnum: anInt1 fmtstring: aString maxlen: anInt2
    | ptr temp |
    ptr := self qeValChar2: hstmt colnum: anInt1 fmtstring: aString maxlen: anInt2.
    temp := String fromAddress: (WinAddress fromString: ptr).
"     MessageBox message: temp printString. "
    ^temp!
  
qeValDecimal2: hstmt colnum: anInt1 precision: anInt2 scale: anInt3
  <api: qeValChar short short short short ulong>
   ^self invalidArgument!

qeValDecimal: hstmt colnum: anInt1 precision: anInt2 scale: anInt3
    | ptr temp |
    ptr := self qeDecimal2: hstmt colnum: anInt1 precision: anInt2 scale: anInt3.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
  
qeValDouble: hstmt colnum: anInt1
   <api: qeValDouble short short double>
   ^self invalidArgument!
  
qeValInt: hstmt colnum: anInt1
   <api: qeValInt short short short>
   ^self invalidArgument!
 
qeValLong: hstmt colnum: anInt1
   <api: qeValLong short short long>
   ^self invalidArgument!

qeValMultiChar2: hstmt startcolnum: anInt1 endcolnum: anInt2 numfmtstring: aString1 datefmtstring: aString2 separator: aString3
   <api: qeValMultiChar short short short struct struct struct ulong>
   ^self invalidArgument!

qeValMultiChar: hstmt startcolnum: anInt1 endcolnum: anInt2 numfmtstring: aString1 datefmtstring: aString2 separator: aString3
    | ptr temp |
    ptr := self qeValMultiChar2: hstmt startcolnum: anInt1 endcolnum: anInt2 numfmtstring: aString1 datefmtstring: aString2 separator: aString3.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
   
qeVerNum
    | ptr temp |
    ptr := self qeVerNum2.
    temp := String fromAddress: (WinAddress fromString: ptr).
    ^temp!
   
qeVerNum2
   <api: qeVerNum ulong>
   ^self invalidArgument!

qeWarning
    <api: qeWarning short>
    ^self invalidArgument! !
 
