/********************************************************************
 * GE144.ctl - PC installer control file for Aldus Gallery Effects 1.5
 *
 * Copyright (C) 1992 Aldus Corporation.  All rights reserved.
 *
 * ABSTRACT:
 * All product-specific text goes in the .CTL file.  Nothing in the .RC
 * file should be product-specific.  Both the .CTL and the .RC files
 * must be localized.
 *
 * When localizing, only text in "double quotes" need be translated.
 * (Although, if the names of files on the distribution diskettes have
 * been changed, they'll have to be changed in this control file too.)
 *
 *******************************************************************/

/* The PRODUCT command is required.  
 */
PRODUCT "Classic 1.5"

VERSIONREQ "1.03"      /* minimum installer version required */


/* There is one DISK statement for each distribution disk.  It gives
 * the name by which the user will be asked for the disk, and a list
 * of the files on the disk.  In addition to the file names, the list
 * of files contains the sizes of the files (uncompressed, in bytes)
 * and the subdirectories in which the files can be found.  If the
 * file is in the root, the subdirectory can be left off.  The options
 * CHECKDATE or NOREPLACE can be specified after the subdirectory.  Lines
 * are separated by commas.
 *
 * This part of the control file will be created automatically by the
 * Disk Builder Utility.
 */


DISK "1 (1.44MB)"
   {
   _C_ALDUS.92         63,
   ALDSETUP.EXE     268432  CHECKDATE,
   ALDSETRS.RSL      30208  CHECKDATE,
   GECD.CTL          9978,
   README.TXT         9540,
   GALLERY.EX~      287776  CHECKDATE,
   IMAGE.TI~        126618  CHECKDATE,
   GALLERY.RSL          23,
   COMMDLG.DL~       89248  CHECKDATE,
   ALDVM.DL~         45550  "ALDUS"  CHECKDATE,
   ALDIM.DL~        148512  "ALDUS"  CHECKDATE,
   ALDIMRES.RS~       4080  "ALDUS\USENGLSH"  CHECKDATE,
   ALDVMRES.RS~       5824  "ALDUS\USENGLSH"  CHECKDATE,
   GALLERY.HL~       53296  "GE_POUCH"  CHECKDATE,
   CRACKLE.TI~       65714  "TEXTURES"  CHECKDATE,
   GAUZE.TI~         65714  "TEXTURES"  CHECKDATE,
   LIZARDSK.TI~      65714  "TEXTURES"  CHECKDATE,
   MARBLE.TI~        30034  "TEXTURES"  CHECKDATE,
   WOOD1.TI~         65714  "TEXTURES"  CHECKDATE
   }


DISK "2 (1.44MB)"
   {
   BRIGHTNE.EF~      67216  "GE_POUCH\PLUG_IN"  CHECKDATE,
   COLORBAL.EF~      67616  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHALKCHA.EF~      74144  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHARCOAL.EF~      72912  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHROME.EF~        71632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CRAQUELU.EF~      79744  "GE_POUCH\PLUG_IN"  CHECKDATE,
   DARKSTRO.EF~      75632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   DRYBRUSH.EF~      74112  "GE_POUCH\PLUG_IN"  CHECKDATE,
   EMBOSS.EF~        69776  "GE_POUCH\PLUG_IN"  CHECKDATE,
   FILMGRAI.EF~      68400  "GE_POUCH\PLUG_IN"  CHECKDATE,
   BRIGHTNE.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   COLORBAL.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHALKCHA.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHARCOAL.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CHROME.HL~         1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CRAQUELU.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   DARKSTRO.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   FRESCO.EF~        76128  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CLASSIC.HL~       44562  "GE_POUCH\PLUG_IN"  CHECKDATE,
   GRAPHICP.EF~      71216  "GE_POUCH\PLUG_IN"  CHECKDATE,
   MOSAIC.EF~        78080  "GE_POUCH\PLUG_IN"  CHECKDATE,
   POSTERED.EF~      72240  "GE_POUCH\PLUG_IN"  CHECKDATE,
   RIPPLE.EF~        76752  "GE_POUCH\PLUG_IN"  CHECKDATE,
   SMUDGEST.EF~      71520  "GE_POUCH\PLUG_IN"  CHECKDATE,
   SPATTER.EF~       70448  "GE_POUCH\PLUG_IN"  CHECKDATE,
   WATERCOL.EF~      79888  "GE_POUCH\PLUG_IN"  CHECKDATE,
   DRYBRUSH.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   EMBOSS.HL~         1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   FILMGRAI.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   FRESCO.HL~         1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   GRAPHICP.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   MOSAIC.HL~         1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   POSTERED.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   RIPPLE.HL~         1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   SMUDGEST.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   SPATTER.HL~        1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   WATERCOL.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   TEXTURIZ.EF~     161120  "GE_POUCH\PLUG_IN"  CHECKDATE,
   TEXTURIZ.HL~       1632  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CLASSIC2.HL~      43191  "GE_POUCH\PLUG_IN"  CHECKDATE,
   CONTROLS.HL~      15743  "GE_POUCH\PLUG_IN"  CHECKDATE
   }


INITIAL GEDir "C:\CLASSIC.GE"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus Gallery Effects 1.5 files."
	" "
	"If this is the directory you want, click OK."
	}

PACKAGE PROLOGUE "" SELECTED INVISIBLE
	{
	SET MustReboot "FALSE"
	SET Answer2 "&Setup"    /* Set to "&Setup" to force computer adjustment of AUTOEXEC.BAT */

	GETALDDIR AldDir
	GETWINSYSDIR WinSysDir
	GETWINDIR WinDir
	}   /* end of Prologue */


DIALOG BadMove "&Setup" "&Manual"
  {
	CAPTION "Modify your system file?"
	TEXT
	{
	"The PATH statement in AUTOEXEC.BAT must include"
	"the Aldus Gallery Effects and Aldus directories in order for"
	"the program to run."
	" "
	"If you want to edit the PATH statement yourself later,"
	"click ""Manual.""  If you want Aldus Setup to modify"
	"the PATH statement, click ""Setup."""
	}
  }

DIALOG AldusGroup "&Continue"
  {
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus group window has been created containing"
	"Aldus Gallery Effects 1.5 and Aldus Setup. Double-click"
	"the Gallery Effects 1.5 icon to open it."
	}
  }

PACKAGE First "" SELECTED INVISIBLE
  {
	SET ExeInstalled "FALSE"
  }

PACKAGE Classic "Gallery Effects 1.5  (3.1MB)" SELECTED
    {
    CONFIRMDIR GEDir


/*    GETPERSONAL  */               /* ask user for personalization info */


    CONCAT AldDir "USENGLSH" EngDir
    CONCAT EngDir "SETUP" SetupDir
    CONCAT GEDir "TEXTURES" TexDir
    CONCAT GEDir "GE_POUCH" PouchDir
    CONCAT PouchDir "PLUG_IN" PlugDir

	
    FILES AldDir
	{
	ALDIM.DL~
	ALDVM.DL~
	}

    FILES EngDir
	{
	ALDIMRES.RS~
	ALDVMRES.RS~
	}

    FILES SetupDir
	{
	ALDSETUP.EXE
	ALDSETRS.RSL
	GECD.CTL
	}

    FILES GEDir
	{
	_C_ALDUS.92
	README.TXT
	GALLERY.EX~
	IMAGE.TI~
	}

    FILES TexDir
	{
	CRACKLE.TI~
	GAUZE.TI~
	LIZARDSK.TI~
	MARBLE.TI~
	WOOD1.TI~
	}

    FILES PouchDir
	{
	GALLERY.HL~
	}

    FILES PlugDir
	{
	BRIGHTNE.EF~
	CHALKCHA.EF~
	CHARCOAL.EF~
	CHROME.EF~
	CLASSIC.HL~
	COLORBAL.EF~
	CRAQUELU.EF~
	DARKSTRO.EF~
	DRYBRUSH.EF~
	EMBOSS.EF~
	FILMGRAI.EF~
	FRESCO.EF~
	GRAPHICP.EF~
	TEXTURIZ.EF~
	MOSAIC.EF~
	POSTERED.EF~
	RIPPLE.EF~
	SMUDGEST.EF~
	SPATTER.EF~
	WATERCOL.EF~
	BRIGHTNE.HL~
	CHALKCHA.HL~
	CHARCOAL.HL~
	CHROME.HL~
	COLORBAL.HL~
	CONTROLS.HL~
	CRAQUELU.HL~
	DARKSTRO.HL~
	DRYBRUSH.HL~
	EMBOSS.HL~
	FILMGRAI.HL~
	FRESCO.HL~
	GRAPHICP.HL~
	CLASSIC2.HL~
	TEXTURIZ.HL~
	MOSAIC.HL~
	POSTERED.HL~
	RIPPLE.HL~
	SMUDGEST.HL~
	SPATTER.HL~
	WATERCOL.HL~
	}

    FILES WinDir
	{
	GALLERY.RSL
	}
	
    FILES WinSysDir
	{
	COMMDLG.DL~
	}
	
    WININI
	{
	"Aldus" "GalleryLangDir" "USENGLSH",
	"Extensions" "TIF" "GALLERY.EXE ^.TIF"
	}

    /* Ask the user if they want their system files checked and
     * updated if necessary.  Record their answer in the variable
     * Answer.
     */

    SET Answer2 "&Setup"    /* Force modification of system files */
/*    DISPLAY BadMove Answer2   *//* Don't display dialog asking user about AUTOEXEC.BAT */
    IF Answer2 EQS "&Setup"
	{
	GETBOOTDRIVE BootDrive
	ONINSTALL
	    {
	    SET MustReboot "TRUE"
	    MODIFY "AUTOEXEC.BAT" BootDrive
		{
		PATH "path" AldDir
		}
	    } /* end oninstall */
	}  /* end if */



    CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
    CONCAT GEDir "GALLERY.EXE" FullGalleryName
    ONINSTALL
	{
	ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
	ADDPROGRAMITEM "Aldus" FullGalleryName "Gallery Effects 1.5" FullGalleryName 0
	/* DISPLAY AldusGroup */
	}

/*
    ONINSTALL
	{
	PERSONALIZE GEDir "GALLERY.EXE"     
	}
*/


    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
	{
	WINDOWSMENU GEDir "README.TXT" "&README.TXT" 
	}
    SET ExeInstalled "TRUE"
    }   /* end Gallery package */


DIALOG SucRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"The Aldus group window has been created containing"
	"Aldus Gallery Effects 1.5 and Aldus Setup. In the"
	"Program Manager, double-click the Gallery Effects 1.5"
	"icon to open it."
	" "
	"Please read the Aldus Gallery Effects 1.5 README.TXT"
	"file, which has been added to the View menu of the"
	"Aldus Setup Main Window."
    }
}

DIALOG SucNoRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
    }
}

DIALOG RebootReminder "&OK"
{
    TEXT
	{
	"Your AUTOEXEC.BAT file has been changed."
	"You must restart your computer before running"
	"Aldus Gallery Effects 1.5."
	}
}

PACKAGE Last "" SELECTED INVISIBLE
 {
    IF ExeInstalled EQS "TRUE"
	{  
	ONINSTALL
		{
		DISPLAY SucRead
		}
	}
    IF ExeInstalled EQS "FALSE"
	{
	ONINSTALL
		{
		DISPLAY SucRead
		}
	}
 }

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
    IF MustReboot EQS "TRUE"
	{
	DISPLAY RebootReminder
	}
    }
