// Next available MSG number is    91 
// MODULE_ID RENDER_DCL_
/*    Copyright (C) 1991-1993 by Autodesk, Inc.

*****************************************************************************
*                                                                           *
*     Permission to use, copy, modify, and distribute this software         *
*     for any purpose and without fee is hereby granted, provided           *
*     that the above copyright notice appears in all copies and that        *
*     both that copyright notice and this permission notice appear in       *
*     all supporting documentation.                                         *
*                                                                           *
*     THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
*     WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR       *
*     PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.                 *
*                                                                           *
*****************************************************************************
*/

//****************************************************************************
//
// R13 Render Dialogue Control Language (DCL) -- Version 1.0
//
//****************************************************************************

// Change level to 3 for new DCL auditing.
dcl_settings : default_dcl_settings { }

@include /*MSG0*/"rendcomm.dcl"

//****************************************************************************
//
// Sub-assemblies common to the render and preferences dialog
//
//****************************************************************************
render_quality_ave : popup_list {
    label = /*RENDER_DCL_1*/"Rendering Type:";
    key = /*MSG0*/"pf_st";
    mnemonic = /*RENDER_DCL_2*/"R";
    list = /*RENDER_DCL_3*/"AutoCAD Render";
    render_types = /*MSG0*/"crender";
    edit_width = 20;
    fixed_width = true;
}

render_procedure_ave : boxed_column {
    label = /*RENDER_DCL_4*/"Rendering Procedure";
    : toggle {
        key = /*MSG0*/ "pf_sd";
        label = /*RENDER_DCL_5*/"Skip Render dialog";
        mnemonic = /*RENDER_DCL_6*/"S";
    }
    : radio_column {
        key = /*MSG0*/"pf_rp";
        : radio_button {
            key = /*MSG0*/"pf_rp_10";
            label = /*RENDER_DCL_7*/"Render entire scene";
            mnemonic = /*RENDER_DCL_8*/"R";
        }
        : radio_button {
            key = /*MSG0*/"pf_rp_20";
            label = /*RENDER_DCL_9*/"Query for selections";
            mnemonic = /*RENDER_DCL_10*/"Q";
        }
    }
}

render_options_ave : boxed_column {
    label = /*RENDER_DCL_11*/"Rendering Options";
    : toggle {
        key = /*MSG0*/"pf_ss";
        label = /*RENDER_DCL_12*/"Smooth Shading";
        mnemonic = /*RENDER_DCL_13*/"S";
    }
    : toggle {
        key = /*MSG0*/"pf_mo";
        label = /*RENDER_DCL_14*/"Merge";
        mnemonic = /*RENDER_DCL_15*/"M";
    }
    : toggle {
        key = /*MSG0*/"pf_af";
        label = /*RENDER_DCL_16*/"Apply Materials";
        mnemonic = /*RENDER_DCL_17*/"A";
    }
    : edit_box_4 {
        label = /*RENDER_DCL_18*/"Smoothing Angle:";
        key = /*MSG0*/"pf_sa";
        mnemonic = /*RENDER_DCL_19*/"A";
    }
    : button {
        key = /*MSG0*/"Options";
        label = /*RENDER_DCL_20*/"More Options...";
        mnemonic = /*RENDER_DCL_21*/"O";
    }
}


ave_render_destination : boxed_column {
    label = /*RENDER_DCL_22*/"Destination";
    : popup_list {
        key = /*MSG0*/"pf_ds";
        list = /*RENDER_DCL_23*/"Viewport\nRender Window\nFile";
    }
    spacer_1;
    : column {
        : var_text {
            key = /*MSG0*/"pf_width";
            alignment = left;
            label = /*RENDER_DCL_25*/"Width: 640";
        }
        : var_text {
            key = /*MSG0*/"pf_height";
            alignment = left;
            label = /*RENDER_DCL_26*/"Height: 480";
        }
        : var_text {
            key = /*MSG0*/"pf_colors";
            alignment = left;
            label = /*RENDER_DCL_27*/"Colors: 8-bit";
        }
    }
    spacer_1;
    : button {
        key = /*MSG0*/"FOptions";
        label = /*RENDER_DCL_28*/"More Options...";
        mnemonic = /*RENDER_DCL_29*/"p";
    }
}

render_settings_ave : column {
    : boxed_column {
        label = /*RENDER_DCL_30*/"Lights";
        : edit_box_4 {
            label = /*RENDER_DCL_31*/"Icon Scale:";
            key = /*MSG0*/"pf_ic_tx";
            mnemonic = /*RENDER_DCL_32*/"I";
        }
    }
    spacer_1;    
    : button {
        label = /*RENDER_DCL_33*/"Information...";
        key = /*MSG0*/"Info";
        mnemonic = /*RENDER_DCL_34*/"t";
    }
    : button {
        label = /*RENDER_DCL_35*/"Reconfigure <";
        key = /*MSG0*/"Reconfigure";
        mnemonic = /*RENDER_DCL_36*/"c";
    }
}

pref_ave : dialog {
    label = /*RENDER_DCL_37*/"Rendering Preferences";
    render_quality_ave;
    : row {
        render_colormap;
        render_procedure_ave;
    }
    : row {
        render_options_ave;
        ave_render_destination;
        render_settings_ave;
    }
    spacer_1_ok_cancel_help_errtile;
}

render_ave : dialog {
    label = /*RENDER_DCL_38*/"Render";
    render_quality_ave;
    : row {
        render_scene_list;
        : column { 
            render_colormap2;
            render_options_ave;
        }
        : column {
            ave_render_destination;
        }
    }
    spacer_1;
    : row {
        fixed_width = true;
        alignment = centered;
        : button {
            key = /*MSG0*/"pf_re_scene";
            label = /*RENDER_DCL_39*/"Render Scene";
            is_default = true;
        }
        : spacer { width = 2; }
        : button {
            key = /*MSG0*/"pf_re_ent";
            label = /*RENDER_DCL_40*/"Render Objects <";
        }
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
    errtile;
}

//***************************************************************************
// Statistics dialog box

rend_stats : dialog {
    label = /*RENDER_DCL_41*/"Statistics";
    width = 50;
    spacer_1;
    : var_text { key = /*MSG0*/"name"; }
    : var_text { key = /*MSG0*/"stype"; }
    : var_text { key = /*MSG0*/"stime"; }
    : var_text { key = /*MSG0*/"record"; }
    : var_text { key = /*MSG0*/"faces"; }
    : var_text { key = /*MSG0*/"triangles"; }
    spacer_1;
    : row {
        alignment = centered;
        fixed_width = true;
        width = 39;
        : toggle {
            label = /*RENDER_DCL_42*/"Save Statistics to File:";
            mnemonic = /*RENDER_DCL_43*/"S";
            key = /*MSG0*/"save_stats";
            height = 1;
        }
        : edit_box {
            label = "";
            key = /*MSG0*/"stats_name";
            edit_width = 14;
            edit_limit = 132;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Main light dialog.

ave_light : dialog {
    label = /*RENDER_DCL_44*/"Lights";
    key = /*MSG0*/"dialog";
    dialog_kind = /*MSG0*/"main";
    : row {
        : column {
            : row {
                : list_box_8x8 {
                    key = /*MSG0*/"list";
                    label = /*RENDER_DCL_45*/"Lights:";
                    mnemonic = /*RENDER_DCL_46*/"L";
                }
                : column {
                    spacer_0;
                    button_mod;
                    button_del;
                    button_pkt;
                    spacer_0;
                }
            }
            : row {
                button_new;
                : popup_list { 
                    key = /*MSG0*/"light_type_popup";
                    edit_width = 15;
                    mnemonic = /*RENDER_DCL_47*/"T";
                    list = /*RENDER_DCL_48*/"Point Light\nDistant Light\nSpotlight";
                    light_types = /*MSG0*/"overhead\ndirect\nsh_spot";
                }
            }
        }
        spacer;
        : column {
            children_alignment = centered;
            : boxed_column {
                label = /*RENDER_DCL_49*/"Ambient Light";
                : edit_box_4 {
                    label = /*RENDER_DCL_50*/"Intensity:";
                    key = /*MSG0*/"ambient_t";
                    mnemonic = /*RENDER_DCL_51*/"I";
                }
                : slider_0_1 { key = /*MSG0*/"ambient_s"; }
                light_color_panel;
            }
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Dialog to edit the currently selected Point light definition.

ave_point_light : dialog {
    key = /*MSG0*/"dialog";
    dialog_kind = /*MSG0*/"point";
    : row {
        ave_basic_lights;
        : column {
            alignment = top;
            fixed_height = true;
            attenuation_panel;
            spacer_0;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}


//****************************************************************************
// Dialog to edit the currently selected Spot light definition.

ave_spotlight : dialog {
    key = /*MSG0*/"dialog";
    dialog_kind = /*MSG0*/"spot";
    : row {
        ave_basic_lights;
        : column {
            ave_spot_lights;
            attenuation_panel;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}

//****************************************************************************
// Tile used only by Spotlights.

ave_spot_lights : column {
    fixed_height = true;
    : edit_box_8 {
        label = /*RENDER_DCL_52*/"Hotspot:";
        key = /*MSG0*/"conea_t";
        mnemonic = /*RENDER_DCL_53*/"H";
    }
    : slider {
        key = /*MSG0*/"conea_s";
        min_value = 0;
        max_value = 160;
        small_increment = 1;
        big_increment = 10;
    }
    : edit_box_8 {
        label = /*RENDER_DCL_54*/"Falloff:";
        key = /*MSG0*/"coned_t";
        mnemonic = /*RENDER_DCL_55*/"F";
    }
    : slider {
        key = /*MSG0*/"coned_s";
        min_value = 0;
        max_value = 160;
        small_increment = 1;
        big_increment = 10;
    }
}
//****************************************************************************
// Dialog to edit distant lights (sun).

ave_distant_light : dialog {
    key = /*MSG0*/"dialog";
    dialog_kind = /*MSG0*/"distant";
    : row {
        : column {
            distant_light_parameters_panel;
        }
        : column {
            azimuth_altitude_panel;
            light_source_panel;
        }
    }
    spacer_1_ok_cancel_help_errtile;
}


//****************************************************************************
//Materials list dialog

rend_list : dialog {
    label = /*RENDER_DCL_56*/"Materials Library";
    : column { 
        key = /*MSG0*/"top_key";
        : row {
            material_column;
            : column {
                finish_preview;
                spacer_0;
                import_export_delete;
                spacer_0;
            }
            library_column;
        }
        spacer_1_ok_cancel_help_custom;
    }
}


//****************************************************************************
// Main material dialog

ave_finish : dialog {
  label = /*RENDER_DCL_57*/"Materials";
  : column {
    key = /*MSG0*/"top_key";
    : row {
        material_list;
        material_preview_and_select;
        : column {
            width = 18;
            spacer_0;
            button_mod;
            button_dup;
            button_new;
            spacer_0;
            material_attach;
        }
    }
    spacer_1_ok_cancel_help_errtile;
  }
}


material_preview_and_select : column {
    finish_preview;
    spacer_1;
    button_imp;
    button_pkt;
}


//
// Dialogs to edit a minimal, standard, granite, marble, or wood material.
//

ave_minimal_material_mod : dialog {
  key = /*MSG0*/"dialog";
  : column {
    key = /*MSG0*/"top_key";
    material_name;
    : row {
        minimal_attributes;
        minimal_value_color_preview;
    }
    spacer_1_ok_cancel_help_errtile;
  }
}

minimal_attributes : boxed_column {
    label = /*RENDER_DCL_58*/"Attributes";
    : row {
        : radio_column {
            key = /*MSG0*/"attribute";
            alignment = top;
            : radio_button {
                label = /*RENDER_DCL_59*/"Color";
                key = /*MSG0*/"diffuse";
                mnemonic = /*RENDER_DCL_60*/"C";
            }
            : radio_button {
                label = /*RENDER_DCL_61*/"Ambient";
                key = /*MSG0*/"ambient";
                mnemonic = /*RENDER_DCL_62*/"A";
            }
            : radio_button {
                label = /*RENDER_DCL_63*/"Reflection";
                key = /*MSG0*/"reflection";
                mnemonic = /*RENDER_DCL_64*/"e";
            }
            : radio_button {
                label = /*RENDER_DCL_65*/"Roughness";
                key = /*MSG0*/"roughness";
                mnemonic = /*RENDER_DCL_66*/"o";
            }
        }
        : column {
            : sample_image { key = /*MSG0*/"sample_0"; }
            : sample_image { key = /*MSG0*/"sample_1"; }
            : sample_image { key = /*MSG0*/"sample_2"; } 
            spacer_1_5;
       }
    }
}


sample_image : image_button {
    color = -15;
    height = 1.5;
    aspect_ratio = 1;
    fixed_height = true;
    fixed_width = true;
    is_tab_stop = false;
}



minimal_value_color_preview : column {
    : row {
        : column {
            value_edit_slider;
            minimal_color_widget;
        }
        finish_preview;
    }
}


minimal_color_widget : boxed_row {
    label = /*RENDER_DCL_67*/"Color";
    : column {
        : row {
            : toggle {
                label = /*RENDER_DCL_68*/"By ACI";
                key = /*MSG0*/"by_aci";
                mnemonic = /*RENDER_DCL_69*/"y";
            }
            lock;
        }
        color_system;
        variable_color_model;
        display_and_get_color;
    }
}


variable_color_model : row {
    : column {
        : text {
            key = /*MSG0*/"top_text";
            width = 10;
            value = /*RENDER_DCL_70*/"Red:";
        }
        : text {
            key = /*MSG0*/"middle_text";
            width = 10;
            value = /*RENDER_DCL_71*/"Green:";
        }
        : text {
            key = /*MSG0*/"bottom_text";
            width = 10;
            value = /*RENDER_DCL_72*/"Blue:";
        }
    }
    : column {
        : edit_box_4 {
            label = "";
            key = /*MSG0*/"top_edit";
        } 
        : edit_box_4 {
            label = "";
            key = /*MSG0*/"middle_edit";
        } 
        : edit_box_4 {
            label = "";
            key = /*MSG0*/"bottom_edit";
        }
    }
    : column {
        : slider_0_1_fixed { key = /*MSG0*/"top_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"middle_slider"; }
        : slider_0_1_fixed { key = /*MSG0*/"bottom_slider"; }
    }
}


//
// Material attach by ACI dialogue.
//

rend_material_aci : dialog {
  label = /*RENDER_DCL_73*/"Attach by AutoCAD Color Index";
  : column {
    key = /*MSG0*/"top_key";
    : row {
        : list_box {
            key = /*MSG0*/"list";
            label = /*RENDER_DCL_74*/"Select a Material:";
            mnemonic = /*RENDER_DCL_75*/"M";
            width = 18;
        }
        : column {
            finish_preview;
            : button {
                label = /*RENDER_DCL_76*/"Attach ->";
                key = /*MSG0*/"attach";
                mnemonic = /*RENDER_DCL_77*/"t";
            }
            : button {
                label = /*RENDER_DCL_78*/"Detach";
                key = /*MSG0*/"detach";
                mnemonic = /*RENDER_DCL_79*/"D";
            }
        }
        : list_box {
            key = /*MSG0*/"index";
            label = /*RENDER_DCL_80*/"Select ACI:";
            mnemonic = /*RENDER_DCL_81*/"A";
            width = 31;
            tabs = /*MSG0*/"4 12";
            multiple_select = true;
            fixed_width_font = true;
        }
    }
    spacer_1_ok_cancel_help_errtile;
  }
}


//
// Material attach by layer dialogue.
//

rend_material_layer : dialog {
  label = /*RENDER_DCL_82*/"Attach by Layer";
  : column {
    key = /*MSG0*/"top_key";
    : row {
        : list_box {
            key = /*MSG0*/"list";
            label = /*RENDER_DCL_83*/"Select a Material:";
            mnemonic = /*RENDER_DCL_84*/"M";
            width = 18;
        }
        : column {
            finish_preview;
            : button {
                label = /*RENDER_DCL_85*/"Attach ->";
                key = /*MSG0*/"attach";
                mnemonic = /*RENDER_DCL_86*/"t";
            }
            : button {
                label = /*RENDER_DCL_87*/"Detach";
                key = /*MSG0*/"detach";
                mnemonic = /*RENDER_DCL_88*/"D";
            }
        }
        : list_box {
            key = /*MSG0*/"layer";
            label = /*RENDER_DCL_89*/"Select Layer:";
            mnemonic = /*RENDER_DCL_90*/"A";
            width = 38;
            tabs = /*MSG0*/"22";
            multiple_select = true;
        }
    }
    spacer_1_ok_cancel_help_errtile;
  }
}
