; Next available MSG number is    8 
; MODULE_ID DDUCSP_LSP_
;;;
;;;    dducsp.lsp
;;;
;;;    Copyright (C) 1992, 1994 by Autodesk, Inc.
;;;
;;;    Permission to use, copy, modify, and distribute this software
;;;    for any purpose and without fee is hereby granted, provided
;;;    that the above copyright notice appears in all copies and
;;;    that both that copyright notice and the limited warranty and
;;;    restricted rights notice below appear in all supporting
;;;    documentation.
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;.
;;;   C:DDUCSP - User Coordinate System presets dialogue.
;;;     
;;;              Uses DDUCSP.DCL for the dialogue definition.  The
;;;              slide images are in ACAD.SLB.
;;;
;;; ===========================================================================
;;; ===================== load-time error checking ============================
;;;

  (defun ai_abort (app msg)
     (defun *error* (s)
        (if old_error (setq *error* old_error))
        (princ)
     )
     (if msg
       (alert (strcat " Application error: "
                      app
                      " \n\n  "
                      msg
                      "  \n"
              )
       )
     )
     (exit)
  )

;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.

  (cond
     (  (and ai_dcl (listp ai_dcl)))          ; it's already loaded.

     (  (not (findfile ;|MSG0|;"ai_utils.lsp"))                     ; find it
        (ai_abort "DDUCSP"
                  (strcat "Can't locate file AI_UTILS.LSP."
                          "\n Check support directory.")))

     (  (eq ;|MSG0|;"failed" (load "ai_utils" ;|MSG0|;"failed"))            ; load it
        (ai_abort "DDUCSP" "Can't load file AI_UTILS.LSP"))
  )

  (if (not (ai_acadapp))               ; defined in AI_UTILS.LSP
      (ai_abort "DDUCSP" nil)         ; a Nil <msg> supresses
  )                                    ; ai_abort's alert box dialog.

;;; ==================== end load-time operations ===========================

(defun ai_ucsp_start ()
  (foreach v0 '(;|MSG0|;"world" "left" "cview" "top" "front" 
                "bottom" "back" "right" "prev")
    (start_image (strcat "ucsp_" v0))
    (slide_image
      0 0
      (- (dimx_tile (strcat "ucsp_" v0)) 1) (- (dimy_tile (strcat "ucsp_" v0)) 1)
      (strcat "acad(u-" v0 ")")
    )
    (end_image)
  )
)

(defun ai_ucsp_set ()
  (if ai_ucsp_sv
    (command "_.UCS" "_V")
    (if ai_ucsp_prevs
      (command "_.UCS" "_P")
      (if ai_ucsp_chg
        (progn
          (if (/= ai_ucsp_a "*")
            (setvar "LASTPOINT" (trans (getvar "UCSORG") 0 1))
          )
          (if (< ai_ucsp_pick 6)
            (setq ai_ucsp_set0 "@")
            (setq ai_ucsp_set0 "*0,0,0" ai_ucsp_a "*")
          )
          (cond ((= ai_ucsp_pick 0)
                 (setq ai_ucsp_set1 "0,-1,0"
                       ai_ucsp_set2 "0,0,1"
                 )
                )
                ((= ai_ucsp_pick 2)
                 (setq ai_ucsp_set1 "1,0,0"
                       ai_ucsp_set2 "0,0,1"
                 )
                )
                ((= ai_ucsp_pick 3)
                 (setq ai_ucsp_set1 "1,0,0"
                       ai_ucsp_set2 "0,-1,0"
                 )
                )
                ((= ai_ucsp_pick 4)
                 (setq ai_ucsp_set1 "-1,0,0"
                       ai_ucsp_set2 "0,0,1"
                 )
                )
                ((= ai_ucsp_pick 5)
                 (setq ai_ucsp_set1 "0,1,0"
                       ai_ucsp_set2 "0,0,1"
                 )
                )
                (T
                 (setq ai_ucsp_set1 "1,0,0"
                       ai_ucsp_set2 "0,1,0"
                 )
                )
          )
          (command "_.UCS" "_3P" ai_ucsp_set0 
                   (strcat ai_ucsp_a ai_ucsp_set1) 
                   (strcat ai_ucsp_a ai_ucsp_set2)
          ) 
        )
      )
    )
  )
)

(defun ai_ucsp_p (val currtile)
  (mode_tile ai_ucsp_currtile 4)
  (setq ai_ucsp_pick val
        ai_ucsp_sv nil
        ai_ucsp_currtile currtile
  )
  (if (/= val 1)
    (setq ai_ucsp_chg T)
  )
  (mode_tile ai_ucsp_currtile 4)
)

(defun ai_ucsp_swcs ()
  (mode_tile ai_ucsp_currtile 4)
  (set_tile ;|MSG0|;"ucsp_a_wcs" "1")
  (setq ai_ucsp_pick 6
        ai_ucsp_sv nil
        ai_ucsp_currtile ;|MSG0|;"ucsp_world"
  )
  (if (/= 1 (getvar "WORLDUCS"))
    (setq ai_ucsp_chg T)
    (setq ai_ucsp_chg nil)
  )
  (mode_tile ai_ucsp_currtile 4)
)

(defun ai_ucsp_cview ()
  (mode_tile ai_ucsp_currtile 4)
  (setq ai_ucsp_sv T 
        ai_ucsp_chg nil
        ai_ucsp_currtile ;|MSG0|;"ucsp_cview"
  )
  (set_tile ;|MSG0|;"ucsp_a_wcs" "1")
  (mode_tile ai_ucsp_currtile 4)
)

(defun ai_ucsp_rucs (typ)
  (setq ai_ucsp_a typ)
  (mode_tile ai_ucsp_currtile 2)
)

(defun ai_ucsp_prev ()
  (mode_tile ai_ucsp_currtile 4)
  (setq ai_ucsp_prevs T
        ai_ucsp_currtile ;|MSG0|;"ucsp_prev"
  )
  (mode_tile ai_ucsp_currtile 4)
)

(defun ai_ucsp_main ( / ai_ucsp_pick ai_ucsp_sv globals)
  (if (not (new_dialog ;|MSG0|;"dducsp" dcl_id))
    (exit)
  )

  (ai_ucsp_start)
  (setq ai_ucsp_a "@" 
        ai_ucsp_pick 2
        ai_ucsp_currtile ;|MSG0|;"ucsp_top"
  )
  (if (= 1 (getvar "WORLDUCS"))
    (progn
      (set_tile ;|MSG0|;"ucsp_a_wcs" "1")
      (setq ai_ucsp_currtile ;|MSG0|;"ucsp_world")
    )
    (set_tile ;|MSG0|;"ucsp_r_ucs" "1")
  )
  (mode_tile ai_ucsp_currtile 2)
  (mode_tile ai_ucsp_currtile 4)
  (action_tile ;|MSG0|;"ucsp_world" "(ai_ucsp_swcs)")
  (action_tile ;|MSG0|;"ucsp_cview" "(ai_ucsp_cview)")
  (action_tile ;|MSG0|;"ucsp_left" "(ai_ucsp_p 0 $key)")
  (action_tile ;|MSG0|;"ucsp_top" "(ai_ucsp_p 1 $key)")
  (action_tile ;|MSG0|;"ucsp_front" "(ai_ucsp_p 2 $key)")
  (action_tile ;|MSG0|;"ucsp_bottom" "(ai_ucsp_p 3 $key)")
  (action_tile ;|MSG0|;"ucsp_back" "(ai_ucsp_p 4 $key)")
  (action_tile ;|MSG0|;"ucsp_right" "(ai_ucsp_p 5 $key)")
  (action_tile ;|MSG0|;"ucsp_prev" "(ai_ucsp_prev)")
  (action_tile ;|MSG0|;"ucsp_r_ucs" "(ai_ucsp_rucs \"@\")")
  (action_tile ;|MSG0|;"ucsp_a_wcs" "(ai_ucsp_rucs \"*\")")
  (action_tile ;|MSG0|;"accept" "(done_dialog 1)")
  (action_tile ;|MSG0|;"cancel" "(done_dialog 0)")
  (action_tile ;|MSG0|;"help" "(help \"\" \"DDUCSP\")")
  (if (= (start_dialog) 1)
    (ai_ucsp_set)
  )
)

(defun c:dducsp ( / app dcl_id old_cmd old_osmode ai_ucsp_prevs 
                    ai_ucsp_sw undo_init)

  ;; Set up error function.
  (setq old_cmd (getvar "CMDECHO")    ; save current setting of cmdecho
        old_error  *error*            ; save current error function
        *error* ai_error              ; new error function
        old_osmode (getvar "OSMODE")  ; disable OSNAP for duration
  )

  (setvar "CMDECHO" 0)
  (setvar "OSMODE" 0)

  (cond
     (  (not (ai_notrans)))                     ; transparent not OK
     (  (not (ai_acadapp)))                     ; ACADAPP.EXP xloaded?
     (  (not (setq dcl_id (ai_dcl ;|MSG0|;"dducsp"))))  ; is .DCL file loaded?
     (T (ai_undo_push)
        (ai_ucsp_main)
        (ai_undo_pop)
     )
  )

  (setvar "OSMODE" old_osmode)
  (setq *error* old_error) 
  (setvar "cmdecho" old_cmd)

  (princ)
)

(princ "  DDUCSP loaded.  ")
(princ)
