// Next available MSG number is    39 
// MODULE_ID DDINSERT_DCL_
/* Next available MSG number is  41 */

//----------------------------------------------------------------------------
//
//     ddinsert.dcl
//
//     Copyright (C) 1992, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//.
//----------------------------------------------------------------------------
//
// Corresponding dialogues for DDINSERT.LSP which is an AutoLISP implementation
// of the AutoCAD Insert command with a dialogue interface.
//
//----------------------------------------------------------------------------


//dcl_settings : default_dcl_settings { audit_level = 3; }


ddinsert : dialog {
    label = "Insert";
    : boxed_column {
	label = "Block";
	: row {
	    : button {
		label = "Block...";
		key = "int_blocks";
		mnemonic = "B";
		width = 10;
		fixed_width = true;
	    }
	    : edit_box {
		label = "";
		key = "current_name";
		width = 36;
		edit_limit = 217;
	    }
	}
	: row {
	    : button {
		label = "File...";
		key = "ext_blocks";
		mnemonic = "F";
		width = 10;
		fixed_width = true;
	    }
	    : edit_box {
		key = "path_name";
		width = 36;
	    }
	}
    }
    : boxed_column {
	label = "Options";
	: row {
	    : toggle {
		label = "Specify Parameters on Screen";
		key = "on_screen";
		mnemonic = "S";
		fixed_width = true;
	    }
	}
	: row {
	    : boxed_column {
		label = "Insertion Point";
		: edit_box {
		    label = "X:";
		    mnemonic = "X";
		    key = "x_pt";
		    edit_width = 10;
		}
		: edit_box {
		    label = "Y:";
		    mnemonic = "Y";
		    key = "y_pt";
		    edit_width = 10;
		}
		: edit_box {
		    label = "Z:";
		    mnemonic = "Z";
		    key = "z_pt";
		    edit_width = 10;
		}
	    }
	    : boxed_column {
		label = "Scale";
		: edit_box {
		    label = "X:";
		    mnemonic = "X";
		    key = "x_scale";
		    edit_width = 10;
		}
		: edit_box {
		    label = "Y:";
		    mnemonic = "Y";
		    key = "y_scale";
		    edit_width = 10;
		}
		: edit_box {
		    label = "Z:";
		    mnemonic = "Z";
		    key = "z_scale";
		    edit_width = 10;
		}
	    }
	    : column {
		: boxed_column {
		    label = "Rotation";
		    fixed_height = true;
		    : edit_box {
			label = "Angle:";
			key = "rotation";
			mnemonic = "A";
			edit_width = 6;
		    }
		}
	    }
	}
    }
    : toggle {
	label = "Explode";
	key = "explode";
	mnemonic = "E";
	fixed_width = true;
    }
    ok_cancel_help_errtile;
}


list_blocks : dialog {
    label = "Defined Blocks";
    : edit_box {
	label = "Pattern:";
	key = "pattern";
	mnemonic = "P";
	allow_accept=true;
	is_default=true;
    }
    : list_box {
	key = "bl_match";
	width = 32;
	allow_accept = true;
    }
    : edit_box {
	label = "Selection:";
	key = "selection";
	mnemonic = "S";
	allow_accept=true;
	edit_limit = 217;
    }
    spacer;
    ok_cancel_err;
}

blk_exists : dialog {
    label = "Warning";
    : paragraph {
	: text_part {
	    label = "A Block with this name already exists in the drawing.";
	}
	: text_part {
	    label = "Do you want to redefine it?";
	}
    }
    spacer_1;
    : row {
	fixed_width = true;
	alignment = centered;
	: button {
	    label = "OK";
	    key = "redefine";
	    width = 8;
	}
	: spacer {
	    width = 2;
	}
	: default_button {
	    label = "Cancel";
	    key = "no";
	    width = 8;
	}
    }
}


