;----- Inc_Dec.Asm - Increment or Decrement and integer.

;Copyright (c) 1992 Gary Meeker

;Syntax - Inc IntVal%
;
;  where IntVal is the Integer to increment

.Model Medium
.Code
;Include Mixed.Inc

Public _Inc
_Inc   Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for IntVal%
       Inc  WORD PTR [SI]
       Mov  AX,[SI]
       Mov  BP,BX
       Ret  2
_Inc   Endp

Public _Dec
_Dec   Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for IntVal%
       Dec  WORD PTR [SI]
       Mov  AX,[SI]
       Mov  BP,BX
       Ret  2
_Dec   Endp

Public _IncL
_IncL  Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for LongVal&
       Add  WORD PTR [SI], 1
       Adc  WORD PTR [SI+02], 0
       Mov  AX,[SI]
       Mov  DX,[SI+02]
       Mov  BP,BX
       Ret  2
_IncL  Endp

Public _DecL
_DecL  Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for LongVal&
       Sub  WORD PTR [SI], 1
       Sbb  WORD PTR [SI+02], 0
       Mov  AX,[SI]
       Mov  DX,[SI+02]
       Mov  BP,BX
       Ret  2
_DecL  Endp

Public IncStep
IncStep Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for StepVal%
       Mov  AX, [SI]
       Mov  SI,[BP+06]    ;get the address for IntVal%
       Add  [SI], AX
       Mov  AX,[SI]
       Mov  BP,BX
       Ret  4
IncStep Endp

Public DecStep
DecStep Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Mov  SI,[BP+04]    ;get the address for StepVal%
       Mov  AX, [SI]
       Mov  SI,[BP+06]    ;get the address for IntVal%
       Sub  [SI], AX
       Mov  AX,[SI]
       Mov  BP,BX
       Ret  4
DecStep ENDP

Public IncStepL
IncStepL Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Xor  DX,DX
       Mov  SI,[BP+04]    ;get the address for StepVal%
       Mov  AX, [SI]
       Mov  SI,[BP+06]    ;get the address for LongVal&
       Add  [SI], AX
       Adc  [SI+02], DX
       Mov  AX,[SI]
       Mov  DX,[SI+02]
       Mov  BP,BX
       Ret  4
IncStepL Endp

Public DecStepL
DecStepL Proc Far
       Mov  BX,BP         ;save BP
       Mov  BP,SP
       Xor  DX,DX
       Mov  SI,[BP+04]    ;get the address for StepVal%
       Mov  AX, [SI]
       Mov  SI,[BP+06]    ;get the address for LongVal&
       Sub  [SI], AX
       Sbb  [SI+02], DX
       Mov  AX,[SI]
       Mov  DX,[SI+02]
       Mov  BP,BX
       Ret  4
DecStepL ENDP

Public IncTrap
IncTrap Proc Far
       Mov  DX,BP         ;save BP
       Mov  BP,SP
       Mov  DI,[BP+08]    ;get the address for IntVal%
       Mov  SI,[BP+06]    ;get the address for LoLimit%
       Mov  BX,[BP+04]    ;get the address for HiLimit%
       Mov  AX,[DI]
       Inc  AX
       Cmp  AX,[BX]
       Jle  IncExit
       Mov  AX,[SI]
IncExit:
       Mov  [DI],AX
       Mov  BP,DX
       Ret  6
IncTrap Endp

Public DecTrap
DecTrap Proc Far
       Mov  DX,BP         ;save BP
       Mov  BP,SP
       Mov  DI,[BP+08]    ;get the address for IntVal%
       Mov  BX,[BP+06]    ;get the address for LoLimit%
       Mov  SI,[BP+04]    ;get the address for HiLimit%
       Mov  AX,[DI]
       Dec  AX
       Cmp  AX,[BX]
       Jge  DecExit
       Mov  AX,[SI]
DecExit:
       Mov  [DI],AX
       Mov  BP,DX
       Ret  6
DecTrap ENDP
End
