;----- ConfBits.Asm - retrieves or sets an "element" from a bit array

; DECLARE FUNCTION GetConfBit(St$, ConfNum&)
; DECLARE SUB SetConfBit(St$, ConfNum&, BYVAL State%)

;Syntax:
;  BitState = GetConfBit%(St$, ConfNum&)

;  Where St$ is the string holding the bits, and ConfNum& is the
;  bit to get.  GetConfBit% returns 0 if the bit is clear, or -1 if
;  the bit is set.  Using -1 allows statements such as:
;
;     IF NOT GetConfBit%(St$, ConfNum&) THEN . . .

;Syntax:
;  SetConfBit(St$, ConfNum&, State%)

;  Where St$ is the string holding the bits, ConfNum& is the bit to set
;  and State% is 0 to clear the bit or anything else to set the bit.

;  SetConfBit St$, ConfNum&, 1

.Model Medium
.Code
Include Mixed.Inc

HProc GetConfBit, Str:Ptr, ConfNum:Ptr
    Mov  SI,Str           ;Get the descriptor address for St$
    Mov  BX,[SI]          ;Save LEN(St$)
    Mov  SI,[SI+02]       ;Point SI to St$
    Mov  DI,ConfNum       ;Point DI to ConfNum&
    Call SetMask          ;Set the Mask in DH, adjust SI to character & AX to 0
    Jc   GQuit            ;Exit if pointing past LEN(St$)
    Test DH,[SI]          ;Is the bit set?
    Jz   GQuit            ;No, exit with AX set to 0
    Dec  AX               ;Yes, decrement AX to set it to -1
GQuit:
    HRet

HEndp

HProc SetConfBit, Str:Ptr, ConfNum:Ptr, State:Word

    Mov  SI,Str           ;Get the descriptor address for St$
    Mov  BX,[SI]          ;Save LEN(St$)
    Mov  SI,[SI+02]       ;Point SI to the string
    Mov  DI,ConfNum       ;Point DI to ConfNum&
    Call SetMask          ;Set the Mask in DH, adjust SI to character & AX to 0
    Jc   SQuit            ;Exit if pointing past LEN(St$)
    Mov  CX,State         ;Get State%
    Jcxz Clear            ;Setting the bit to zero? Yes,
    Or   Byte Ptr [SI],DH ;No, set the bit to One
    Jmp  Short SQuit      ;and skip over the code below

Clear:
    Not  DH               ;flip all of the mask bits in DH
    And  Byte Ptr [SI],DH ;and use AND instead of OR to clear the bit

SQuit:
    HRet

HEndp

SetMask PROC NEAR
    Mov  AX,[DI]          ;
    Mov  DX,[DI+02]       ;DX:AX holds the bit to get

    Mov  CX,8             ;Divide by 8
    Div  CX               ;
    Cmp  AX,BX            ;Check against the length of St$, Valid?
    Jb   OK               ;Yes,
    Stc                   ;No, Set Carry to indicate error
    Ret

OK: Add  SI,AX            ;Point SI the correct character in Array$
    Mov  DH,01h           ;Set only the low-order bit in DH as a TEST mask
    Mov  CL,DL            ;Get the remainder into CL
    Shl  DH,CL            ;Position that bit opposite the element we want
    Xor  AX,AX            ;Clear AX to return zero and Clear Carry
    Ret
SetMask ENDP

End
