/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX or
echo run install2.cmd .
exit
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*-- get the command line --*/
parse arg sourcedir destdir


call SysCls


readmefile = 'liesmich'
readmename = 'Lies mich'
bDeu = "1 "
fWinMan = 0



  /* Go search for the OS2.INI file, this will be our bootdrive */
  testos2path = SysSearchPath('PATH', 'OS2.INI');
  bootdrive = FILESPEC("drive", testos2path);
  os2path = FILESPEC("path",testos2path);
  ver = SysOS2Ver()

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Bitte geben Sie das Ziel-Verzeichnis '
  say 'fuer die ELSA Bildschirmtreiber an'
  say '(Standardeinstellung: 'bootdrive'\WINOS232):'
  /*-- if error --*/
  parse pull destdir
  if destdir = ' ' then do
    destdir = bootdrive'\WINOS232'
  end
end


  DestDrive = FILESPEC("drive", destdir)
if sourcedir = '' then do
  thisdir = directory()
  say ''
  say 'Bitte geben Sie das Quell-Verzeichniss an'
  say '(Standardeinstellung: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- do main screen --*/
call SysCls
say
say '                   ELSA Bildschirmtreiber Installation'
say
say 'Der ELSA Bildschirmtreiber wird mit folgenden '
say 'Einstellungen installiert:'
say
say 'Quell-Verszeichnis: "'sourcedir'"'
say 'Ziel-Verzeichnis  : "'destdir'"'
say
say 'Einstellungen in Ordnung (J/N)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation abgebrochen.'
  exit
end


     ScreenSys = SysSearchPath('PATH', 'screen01.sys');
     "@attrib -r -h -s "||ScreenSys
     if ScreenSys > ' ' then
        "@copy "||ScreenSys||" "||bootdrive||os2path||"*.ibm"
     call CopyDriverFiles sourcedir , destdir
     DestDrive
     "@CD "||destdir
     DosSys = SysSearchPath('PATH', 'command.com');
     DosPath = FILESPEC("PATH", DosSys);
     "@attrib -r -h -s "||bootdrive||DosPath||"vsvga.sys"
     "@attrib -r -h -s "||bootdrive||os2path||"dll\*.dll"
     if DosSys > " " then
        "@copy "||destdir||"\vsvga.sys "||bootdrive||DosPath||"*.*"
     if (COMPARE(ver,'2.1') < 4) then do
        "@copy "||destdir||"\elsainst.dll "||bootdrive||os2path||"dll"
        "@copy "||bootdrive||os2path||"install\dspinstl.exe"||" "||destdir
     end
     call SaveWinIni DestDrive destdir
     DSPINSTL.EXE                       /* go execute DSPINSTL */
     say ""
/*-- create a program object --*/
call SysCls
say
say
say
say
say 'Der ELSA Resolution Manager kann als Objekt '
say 'auf Ihrer Arbeitsoberflaeche installiert werden.'
say 'Soll dies erfolgen (J/N) ?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call WinMan

say
say 'Erstelle den Programm-Ordner,'
x = SysCreateObject("WPFolder",,
                    "ELSA Video Configuration",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<ELSAFLDR>;ICONFILE="||destdir||"\wininst.ICO", "replace")
if x = 0 then do
  say 'Fehler beim Erstellen des Programm-Ordners.'
  say 'Abbruch der Installation !'
  exit
end


say readmefile||' Datei,'
x = SysCreateObject("WPProgram",,
                    readmename,,
                    "<ELSAFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\"||readmefile)

say 'und die Programm Datei.'
x = SysCreateObject("WPProgram",,
                    "ELSA Resolution Manager",,
                    "<ELSAFLDR>",,
                    "EXENAME="||destdir||"\WININST.EXE;STARTUPDIR="||destdir)


WinMan:

  call SysIni 'USER' , 'PM_INSTALL', 'WINOS2_LOCATION'
  winpath = result
  windrive = FILESPEC("drive", result);
  if result = "ERROR:"  then
     do
     winpath = os2path||'mdos\winos2'
     windrive = bootdrive
     end

winlen = length(winpath)
if substr( winpath, winlen, 1 ) \= '' then do
   winlen = length(winpath) - 1
end


/*-- create a program object --*/
say
say
say
say
say 'Bitte legen Sie die Diskette '
say 'mit den ELSA Windows Treibern '
say 'in das Laufwerk A: ein'
say 'Vorgang fortsetzen ? (J/N)'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call GoodBye
param = bDeu||winpath
"@call wmancopy.bat "||param


say 'Bitte warten, die Windows Treiber '
say 'werden kopiert und expandiert...'
say

fWinMan = 1

call GoodBye




GoodBye:
/*-- exit with a goodbye --*/
     call RestoreWinIni fWinMan DestDrive destdir
call SysCls
say
say
say
     if fWinMan = 0 then do
        say 'ELSA Windows Resolution Manager (WINMan) wurde nicht installiert.'
     end

say
say 'Die ELSA Bildschirmtreiber wurden erfolgreich installiert .'
say 'Bitte starten Sie ihr System neu.'
say
say 'Unter Verwendung des ELSA Resolution Manager '
say 'kann die gewuenschte Bildschirm-Aufloesung '
say 'ausgewaehlt werden.'
say
say 'Letzte Neuerungen und Informationen sind in '
say 'der Liesmich Datei beschrieben.'
say
exit


INST_EXIT:
  EXIT



CopyDriverFiles: Arg SrcDrive , DestDir

  DestDrive = FILESPEC("drive",DestDir)
  /*-- create the dest. dir --*/
  DestDrive
  rc = SysMkDir(DestDir)
  if rc = 0 then do
    say 'The directory ' DestDir ' was created successfully.'
  end
  else do
    if SysFileTree(DestDir,file,D)>0 then
    do
       say 'The directory ' DestDir ' could not be created successfully; cancelling.'
       exit
    end
  end
  say 'Please wait ....'
  "@xcopy "||SrcDrive||"*.* "||DestDir
  return

SaveWinIni: arg backdr backcd
  call SysIni 'USER' , 'PM_INSTALL', 'WINOS2_LOCATION'
  winpath = result
  windrive = FILESPEC("drive", result);
  if result = "ERROR:"  then
     do
     winpath = os2path||'mdos\winos2'
     windrive = bootdrive
     end

  windrive
  "@cd "||winpath
  "@copy win.ini win.tmp"

  backdr
  "@cd "||backcd


  return


RestoreWinIni: arg fRestore backdr backcd
  call SysIni 'USER' , 'PM_INSTALL', 'WINOS2_LOCATION'
  winpath = result
  windrive = FILESPEC("drive", result);
  if result = "ERROR:"  then
     do
     winpath = os2path||'mdos\winos2'
     windrive = bootdrive
     end

  windrive
  "@cd "||winpath
  if fRestore = 0 then do
     "@copy win.tmp win.ini"
  end
  "@del win.tmp"

  backdr
  "@cd "||backcd

  return

