#include <windows.h>
#include "openfile.h"
#include "commdlg.h"

HWND   hwnd;
HWND   hwndEdit;
HANDLE hAccelTable;
HANDLE hInst;

/* new variables for common dialogs */

OPENFILENAME ofn;
char szFileName[MAXFILENAME];
char szFileTitle[MAXFILENAME];


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
                    int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
        if (!InitApplication (hInstance))
            return (FALSE);

    if (!InitInstance (hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage (&msg, NULL, NULL, NULL)) 
        if (!TranslateAccelerator (hwnd, hAccelTable, &msg)) 
        {
            TranslateMessage (&msg);
            DispatchMessage (&msg); 
        }

    return (msg.wParam);
}


BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style         = NULL;
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject (WHITE_BRUSH); 
    wc.lpszMenuName  = "AppMenu";
    wc.lpszClassName = "AppClass";

    return (RegisterClass (&wc));
}


BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
    RECT            Rect;

    hInst = hInstance;

    hAccelTable = LoadAccelerators (hInst, "AppAccel");

    hwnd = CreateWindow ("AppClass", "Application Title",
               WS_OVERLAPPEDWINDOW,
               CW_USEDEFAULT,
               CW_USEDEFAULT,
               CW_USEDEFAULT,
               CW_USEDEFAULT,
               NULL, NULL, hInstance, NULL);

    if (!hwnd)
        return (FALSE);

    GetClientRect (hwnd, (LPRECT) &Rect);

    hwndEdit = CreateWindow ("Edit", NULL,
                   WS_CHILD | WS_VISIBLE | ES_MULTILINE |
                   WS_VSCROLL | WS_HSCROLL |
                   ES_AUTOHSCROLL | ES_AUTOVSCROLL,
                   0, 0, 
                   (Rect.right-Rect.left), (Rect.bottom-Rect.top),
                   hwnd, IDC_EDIT, hInst, NULL);

    if (!hwndEdit)
    {
        DestroyWindow(hwnd);
        return (NULL);
    }

    /* fill in non-variant fields of OPENFILENAME struct. */
    ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner         = hwnd;
    ofn.lpstrFilter       = "All Files (*.*)\0*.*\0";
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter    = 0;
    ofn.nFilterIndex      = 0;
    ofn.lpstrFile         = szFileName;
    ofn.nMaxFile          = MAXFILENAME;
    ofn.lpstrInitialDir   = NULL;
    ofn.lpstrFileTitle    = szFileTitle;
    ofn.nMaxFileTitle     = MAXFILENAME;
    ofn.lpstrTitle        = NULL;
    ofn.lpstrDefExt       = "C";
    ofn.Flags             = 0;

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    return (TRUE);

}


long FAR PASCAL MainWndProc (HWND hWnd, unsigned message, 
                             WPARAM wParam, LPARAM lParam)
{
    FARPROC lpProcAbout;

    switch (message) 
    {
        case WM_COMMAND:
            switch (wParam) 
            {
                case IDM_ABOUT:
                    lpProcAbout = MakeProcInstance (About, hInst);
                    DialogBox (hInst, "About", hWnd, lpProcAbout);
                    FreeProcInstance (lpProcAbout);
                    break;

                case IDM_OPEN:
                    if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
                        return FALSE;

                    lstrcpy (szWindowTitle, "Application Title");
                    lstrcat (szWindowTitle, " - ");
                    lstrcat (szWindowTitle, szFileTitle);
                    SetWindowText (hWnd, szWindowTitle);

                    MessageBox (hWnd, "Open File goes here",
                        "Application Title",
                        MB_ICONASTERISK | MB_OK);
                    break;

                case IDM_SAVEAS:
                    if (!GetSaveFileName ((LPOPENFILENAME)&ofn))
                        return FALSE;

                    lstrcpy (szWindowTitle, "Application Title");
                    lstrcat (szWindowTitle, " - ");
                    lstrcat (szWindowTitle, szFileTitle);
                    SetWindowText (hWnd, szWindowTitle);
                                            
                    MessageBox (hWnd, "Save File goes here",
                        "Application Title",
                        MB_ICONASTERISK | MB_OK);
                    break;

                case IDM_EXIT:
                    DestroyWindow (hWnd);
                    break;
            } 
            break;

        case WM_SETFOCUS:
            SetFocus (hwndEdit);
            break;

        case WM_SIZE:
            MoveWindow (hwndEdit, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
            break;

        case WM_DESTROY:
            PostQuitMessage (0);
            break;

        default:
            return (DefWindowProc (hWnd, message, wParam, lParam));
    }
    return (NULL);
}


BOOL FAR PASCAL About (HWND hDlg, unsigned message, 
                       WPARAM wParam, LPARAM lParam)
{
    switch (message) 
    {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
            if (wParam == IDOK || wParam == IDCANCEL) 
            {
                EndDialog (hDlg, TRUE);
                return (TRUE);
            }
            break;
    }

    return (FALSE);
}
