{$A+,B-,D+,E+,F-,I-,L+,N+,O-,R-,S-,V-}
{$M 16384,0,655360}
program UNPACK;
uses LZH;

type
  IObuf = array[0..10*1024-1] of byte;
var
  ex,cfile:string;
  ls,clen:integer;
  d,infile,outfile: file;
  ibuf,obuf: IObuf;
  s: String;

  procedure Error (msg: String);
  begin
    writeln(msg);
    HALT(1)
  end;

{$F+}
  procedure ReadNextBlock;
{$F-}
  begin
    inptr:= 0;
    BlockRead(infile,inbuf^,sizeof(ibuf),inend);
    if IoResult>0 then Error('! Error reading input file');
  end;

{$F+}
  procedure WriteNextBlock;
{$F-}
  var
    wr: word;
  begin
    BlockWrite(outfile,outbuf^,outptr,wr);
    if (IoResult>0) or (wr<outptr) then
      Error('! Error writing output file');
    outptr:= 0
  end;

  procedure OpenInput (fn: String);
  begin
    assign(infile,fn); reset(infile,1);
    if IoResult>0 then Error('! Can''t open input file');
    inbuf:= @ibuf;
    ReadToBuffer:= ReadNextBlock;
    ReadToBuffer;
  end;

  procedure OpenOutput (fn: String);
  begin
    assign(outfile,fn); rewrite(outfile,1);
    if IoResult>0 then Error('! Can''t open output file');
    outbuf:= @obuf;
    outend:= sizeof(obuf);
    outptr:= 0;
    WriteFromBuffer:= WriteNextBlock;
  end;

begin 
if ParamCount=0 then 
 begin
  writeln('Syntax: DECOM INFILE  ');
 end;
OpenInput(ParamStr(1));
CLEN :=length(paramstr(1));
CFILE :=Copy(PARAMSTR(1),1,CLEN-4);
OpenOutput(CFILE+'.RAW');
Decode;
close(infile); 
if IoResult>0 then Error('! Error closing input file');
if outptr>0 then WriteNextBlock;
close(outfile); 
if IoResult>0 then Error('! Error closing output file');
end.
