/****************************************************************************/
/*  Projekt:  EuroSpeed                                                     */
/*	Programm: Sample														*/
/*  Datei:    Tools.C                                                       */
/*                                                                          */
/*	Funktionen: CenterDialog()												*/
/*				ErrorBox( HWND hWnd, int iMessageID )						*/
/*				EnableAll( HWND hWnd, BOOL bConnect )						*/
/*				InitOpenFileName()											*/
/*				UseDDEan( HWND hWnd, FARPROC lpDdeProc )					*/
/*				SetReceive( HWND hWnd )										*/
/*				WriteProtokoll( HWND hWnd, LPSTR lpAddString, BOOL bAdd )	*/
/*				UseSenden() 												*/
/*				ErrorProtokoll()											*/
/*																			*/
/****************************************************************************/
/*                                                                          */
/*	Torsten Schulz	 -	 Acotec GmbH Berlin   -    17.12.1992				*/
/*                                                                          */
/****************************************************************************/

/*
 * Includes
 */

#include <Windows.H>
#include <Time.H>
#include <CommDlg.H>
#include <DdeMl.H>
#include <Memory.H>
#include "Sample.H"

/*
 * Defines
 */

#define _WINDOWS
#define NOCOMM

/*
 * Functions
 */

/*--------------------------------------------------------------------------*/
/*  CenterDialog: Zentriert das Dialogfeld auf 2 / 3                        */
/*--------------------------------------------------------------------------*/
void CenterDialog ( HWND hDlg )
{
  RECT rc;

	GetWindowRect( hDlg, &rc );
	SetWindowPos( hDlg,NULL,
				  (GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2,
				  (GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 3,
				  0, 0, SWP_NOSIZE | SWP_NOACTIVATE   );

}

/*--------------------------------------------------------------------------*/
/*	ErrorBox: Wird benutzt, um Fehlermeldungen auszugeben, die nicht die */
/*	DDE Kommunikation betreffen (z.B.: Kein Speicher). 		*/
/*--------------------------------------------------------------------------*/
void ErrorBox( HWND hWnd, int iMessageID )
{
	char        szBuffer[ MAX_TEXT ];

	LoadString( hInst, iMessageID, szBuffer, MAX_TEXT );
	MessageBox( hWnd, szBuffer, "ERROR",
				MB_ICONEXCLAMATION | MB_OK  );
}

/*--------------------------------------------------------------------------*/
/*	EnableAll: Setzt die Fenster auf den Stand der Verbindung.				*/
/*--------------------------------------------------------------------------*/
void EnableAll( HWND hWnd, BOOL bConnect )
{

	EnableWindow( hWndDatei	  ,	 bConnect );
	EnableWindow( hWndSend	  ,	 bConnect );
	EnableWindow( hWndEmpfang ,	 bConnect );
	EnableWindow( hWndDDEan   , !bConnect );
	EnableWindow( hWndDDEaus  ,	 bConnect );
	EnableMenuItem( GetMenu(hWnd), IDM_DATEI,	bConnect ? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( GetMenu(hWnd), IDM_SENDEN,	bConnect ? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( GetMenu(hWnd), IDM_EMPFANG, bConnect ? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( GetMenu(hWnd), IDM_DDEAN,  !bConnect ? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( GetMenu(hWnd), IDM_DDEAUS,	bConnect ? MF_ENABLED : MF_GRAYED );
	SetProp( hWnd, "bConnection", bConnect );
	InvalidateRect( hCldWnd, NULL, FALSE );


}

/*--------------------------------------------------------------------------*/
/*	InitOpenFileName: Nutzt den CommonOpenDialog zur Dateiauswahl und		*/
/*					  speichert den Pfad- und Dateinamen in der lokalen 	*/
/*					  Struktur ab.											*/
/*--------------------------------------------------------------------------*/
void InitOpenFileName( HWND             hWnd,
					   LPOPENFILENAME	lpofn )
{
	char        szDirName[MAX_PATH],
				szFilter[MAX_PATH],
				szFile[MAX_PATH],
				szTitle[MAX_PATH],
				szFileTitle[MAX_PATH];
	int         i, iCount;
	char		cReplace;

	HANDLE		hData;
	LPLOCAL		lpData;

	/* Holt das "Windows" Verzeichnis */
	GetWindowsDirectory(szDirName, sizeof(szDirName));

	/* Setzt den initialen Filterstrings */
	iCount = LoadString(hInst, IDSTR_FILTERSTRING, szFilter, MAX_PATH);
	cReplace = szFilter[iCount - 1];
	for (i = 0; szFilter[i] != '\0'; i++)
	{
		if (szFilter[i] == cReplace) szFilter[i] = '\0';
	}

	lstrcpy( szFileTitle, "" ); /* enthaelt den Dateinamen */
	lstrcpy( szTitle, "Dateiauswahl" ); /* Caption */

	/*
	 * Fuellen der Struktur
	 */

	/* Setzt alle Plaetze der Struktur auf NULL. */
	_fmemset( lpofn, 0, sizeof(OPENFILENAME) );

	lpofn->lStructSize = sizeof(OPENFILENAME);
	lpofn->hwndOwner = hWnd;
	lpofn->lpstrFilter = szFilter;
	lpofn->nFilterIndex = 1;
	lpofn->lpstrFile= szFile;
	lpofn->nMaxFile = sizeof(szFile);
	lpofn->lpstrFileTitle = szFileTitle;
	lpofn->nMaxFileTitle = sizeof(szFileTitle);
	lpofn->lpstrInitialDir = szDirName;
	lpofn->lpstrTitle = szTitle;
	lpofn->Flags =	OFN_PATHMUSTEXIST |
					OFN_FILEMUSTEXIST |
					OFN_HIDEREADONLY    ;

	/* Alle Dateien zugelassen */
	lstrcpy( szFile, "*.*" );

	if (GetOpenFileName( lpofn ))
	{
		/* Sichern des Dateinamens im Localen Speicher */
		hData = GetProp( hWnd, "hLocal" );
		lpData = (LPLOCAL) GlobalLock( hData );
		lstrcpy( lpData->szFile, lpofn->lpstrFile	);
		GlobalUnlock (hData);

		WriteProtokoll( hWnd, lpofn->lpstrFileTitle, TRUE );
	}
}


/*--------------------------------------------------------------------------*/
/*	UseDDEan: DDE Verbindung initialisieren und aufbauen;					*/
/*	return:   liefert den Konversationshandle zurueck; im Fehlerfall		*/
/*			  wird durch TestDDEConnect eine NULL zurueckgegeben			*/
/*--------------------------------------------------------------------------*/
HCONV UseDDEan( HWND hWnd, FARPROC lpDdeProc )
{
	HCONV	hConv;

	lpDdeProc = TestDDEInititialize( hWnd );
	if ( lpDdeProc )
	{
		hConv = TestDDEConnect( hWnd );
		EnableAll( hWnd, (hConv != NULL) );
	}
	else
	{
		hConv = NULL;
	}
	return hConv;
}

/*--------------------------------------------------------------------------*/
/*	SetReceive:	Ermoeglicht die Applikation durch Aufruf der Funktion		*/
/*				"Listen" als passive Gegenstelle zu	dienen.					*/
/*	return:		Nur bei Erfolg TRUE											*/
/*--------------------------------------------------------------------------*/
BOOL SetReceive( HWND hWnd, HCONV hConv, BOOL bEmpfang )
{

	if ( bEmpfang )
	{
		if (!Listen( hWnd, hConv ))
		{
			return FALSE;
		}
		CheckMenuItem( GetMenu( hWnd ), IDM_EMPFANG, MF_CHECKED);
	}
	else
	{
		CheckMenuItem( GetMenu( hWnd ), IDM_EMPFANG, MF_UNCHECKED);
	}
	SetProp( hWnd, "bEmpfang",					 bEmpfang );
	EnableWindow( hWndEmpfang,					!bEmpfang );
	EnableMenuItem( GetMenu(hWnd), IDM_EMPFANG, !bEmpfang ? MF_ENABLED : MF_GRAYED );

	InvalidateRect( hCldWnd, NULL, FALSE );

	return TRUE;
}

/*--------------------------------------------------------------------------*/
/*	WriteProtokoll:	Schreibt den lpAddString mit Datum in das Protokoll-	*/
/*					fenster, ggf wird der letzte Protokolleintrag entfernt. */
/*					Ist bAdd auf FALSE gesetzt, dann wird das Protokoll 	*/
/*					initialisiert.											*/
/*	return: 		nicht ausgewertet										*/
/*--------------------------------------------------------------------------*/
BOOL WriteProtokoll( HWND hWnd, LPSTR lpAddString, BOOL bAdd )
{

/* Zeitermittlung */
#define HOUR (datetime->tm_hour)
#define MIN  (datetime->tm_min)
#define SEC  (datetime->tm_sec)
	   long lTime;
	   struct tm *datetime;

static char szProtokoll    [ MAX_PROTOKOLL ];
	   char szOldProtokoll [ MAX_PROTOKOLL ];
	   int	i;

	hWnd = hWnd;

	if ( bAdd )
	{
		/* Zeit */
		time( &lTime );
		datetime = localtime( &lTime );

		/*
		 * Ist das Protokoll groesser als MAX_PROTOKOLL, werden solange die
		 * letzten Protokolleintraege geloescht, bis der neue Eintrag
		 * eingefuegt werden kann.
		 */
		while ((lstrlen(szProtokoll) > (MAX_PROTOKOLL - (lstrlen(lpAddString) + 14))))
		{
			i = lstrlen(szProtokoll);
			while (( szProtokoll[i] != '\r' ) || ( i == 0 ))	i--;
			szProtokoll[i] = '\0';
		}

		/* altes Protokoll sichern */
		lstrcpy ( (LPSTR) szOldProtokoll, (LPSTR) szProtokoll );

		/* Neues Protokoll */
		wsprintf( szProtokoll, "%02d:%02d:%02d %s\r\n%s",
				  HOUR, MIN, SEC,
				  (LPSTR) lpAddString, (LPSTR) szOldProtokoll	);
	}
	else
	{
		szProtokoll[0] = '\0';
	}

	SetWindowText ( hWndProtokoll, szProtokoll	);
	InvalidateRect( hWndProtokoll, NULL, FALSE );

	return TRUE;

}

/*--------------------------------------------------------------------------*/
/* ErrorProtokoll: Realisiert die Protokollausgabe des letzten DDE Fehlers	*/
/* return:		   Returnwert der Funktion WriteProtokoll					*/
/*--------------------------------------------------------------------------*/
BOOL ErrorProtokoll( HWND hWnd, DWORD dwDdeInst )
{
	char		szBuffer[ MAX_TEXT ];

	wsprintf( szBuffer, "DDE Error %X", DdeGetLastError( dwDdeInst ));

	return WriteProtokoll( hWnd, (LPSTR) szBuffer, TRUE );
}

/*--------------------------------------------------------------------------*/
/* UseSenden: Startet die DDE Transaktion "Verbindung aufbauen".			*/
/* return:	  Ergebnis des Funktion DDETransAktConnect						*/
/*--------------------------------------------------------------------------*/
BOOL UseSenden(HWND hWnd, HCONV hConv )
{
	BOOL		bReturn;
	FARPROC 	lpDialogProc;
	char		szNumber[ MAX_NUMBER ];
	HANDLE		hData;
	LPLOCAL		lpData;

	lpDialogProc = MakeProcInstance ( DlgVerbindung, hInst );
	bReturn = DialogBox ( hInst, "VerbindungDlg", hWnd, lpDialogProc );
	FreeProcInstance ( lpDialogProc );

	if ( bReturn )
	{
		hData = GetProp( hWnd, "hLocal" );
		lpData = (LPLOCAL) GlobalLock( hData );
		lstrcpy( szNumber, lpData->szNumber	);
		GlobalUnlock (hData);

		bReturn = DDETransAktConnect( hWnd, hConv, (LPSTR) szNumber	);
	}
	return bReturn;
}
