/****************************************************************************/
/*  Projekt:  EuroSpeed                                                     */
/*  Programm: Sample                                                        */
/*  Datei:    Sample.H                                                      */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/*  Torsten Schulz   -   Acotec GmbH Berlin   -    17.12.1992               */
/*                                                                          */
/****************************************************************************/

/*
 * Define for RC Compiler
 */
/* Menuitems */
#define IDM_DDEAN           10
#define IDM_DDEAUS          11
#define IDM_DATEI           12
#define IDM_SENDEN          13
#define IDM_EMPFANG         14
#define IDM_EXIT            15
#define IDM_DELETE          20
#define IDM_DISCONN         21
#define IDM_HELP            40
#define IDM_HELPHELP        41
#define IDM_ABOUT           42

/* Icons */
#define IDI_ICON            90

/* Dialogs */
#define ID_OK               100
#define ID_CANCEL           101
#define ID_HELP             102
#define ID_ABOUT            103
#define ID_ICON             104
#define ID_OPTIONS          105

#define ID_HELP1            110
#define ID_BITTE            111
#define ID_NUMMER           112

/* Strings */
#define IDSTR_ABOUT         200
#define IDSTR_FILTERSTRING  201

#define IDSTR_HELP          210
#define IDSTR_BITTE         211

#define IDERR_DEFAULT       300
#define IDERR_NOMEM         301
#define IDERR_DDEINIT       302
#define IDERR_DONOT         303
#define IDERR_NOFILE        304
#define IDERR_TIMER         305

/* Puffergroessen */
#define MAX_TEXT            256
#define MAX_PATH            256
#define MAX_PROTOKOLL       1024
#define MAX_NUMBER          52

/* Hoehe der Statuszeile */
#define STATUS_HEIGHT       19
#define BUTTON_HEIGHT       24
#define BUTTON_WIDTH        80

/* Lokale Daten */
typedef struct
{
	char    szFile   [ MAX_PATH   ];    /* Name der ausgewaehlten Datei */
	char    szNumber [ MAX_NUMBER ];    /* Rufnummer */

} LOCAL, FAR *LPLOCAL;

HANDLE      hInst;                      /* Applikationsinstanz   */
DWORD       dwDdeInst;                  /* DDE Instanz           */
HWND        hWndGlob;                   /* Appl. Windowhandle    */
HWND        hCldWnd,                    /* Unterfenster Handles  */
			hWndDDEan,
			hWndDDEaus,
			hWndDatei,
			hWndSend,
			hWndEmpfang,
			hWndProtokoll;

/*
 * prototypes
 */

/* Tools.C */
void    CenterDialog (       HWND   hDlg );
void    ErrorBox(            HWND   hWnd,
							 int    iMessageID );
void    EnableAll(           HWND   hWnd,
							 BOOL   bConnect );
void    InitOpenFileName(    HWND   hWnd,
							 LPOPENFILENAME lpofn);
HCONV   UseDDEan(            HWND   hWnd,
							 FARPROC lpDdeProc );
BOOL    SetReceive(          HWND   hWnd,
							 HCONV  hConv,
							 BOOL   bEmpfang );
BOOL    WriteProtokoll(      HWND   hWnd,
							 LPSTR  lpAddString,
							 BOOL   bAdd );
BOOL    ErrorProtokoll(      HWND   hWnd,
							 DWORD  dwDdeInst );
BOOL    UseSenden(           HWND   hWnd,
							 HCONV  hConv );

/* Dialog.C */
BOOL FAR PASCAL DlgAbout(    HWND   hDlg,
							 WORD   message,
							 WORD   wParam,
							 LONG   lParam  );
BOOL FAR PASCAL DlgVerbindung(HWND  hDlg,
							 WORD   message,
							 WORD   wParam,
							 LONG   lParam  );

/* Dde.C */
FARPROC TestDDEInititialize( HWND   hWnd );
HCONV   TestDDEConnect (     HWND   hWnd );
BOOL    DDETransAktConnect(  HWND   hWnd,
							 HCONV  hConv,
							 LPSTR  lpNumber );
BOOL    DDETransAktSend(     HWND   hWnd,
							 HCONV  hConv,
							 LPSTR  lpFile );
BOOL    DDETransAktDisconn(  HWND   hWnd,
							 HCONV  hConv );
BOOL    Listen(              HWND   hWnd,
							 HCONV  hConv );
