/****************************************************************************/
/*  Projekt:  EuroSpeed                                                     */
/*  Programm: Sample                                                        */
/*  Datei:    Sample.C                                                      */
/*                                                                          */
/*  Funktionen: WinMain()                                                   */
/*              WndProc()                                                   */
/*              ChildWndProc()                                              */
/*              SetControls()                                               */
/*              ShowControls()                                              */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/*  Torsten Schulz   -   Acotec GmbH Berlin   -    17.12.1992               */
/*                                                                          */
/****************************************************************************/

/*
 * Includes
 */

#include <Windows.H>
#include <CommDlg.H>
#include <Memory.H>
#include <DdeMl.H>
#include "Help.H"
#include "Sample.H"

/*
 * Defines
 */

#define _WINDOWS
#define NOCOMM

/*
 * Exports
 */

long FAR PASCAL WndProc(        HWND    hWnd,   WORD    message,
								WORD    wParam, LONG    lParam  );
long FAR PASCAL ChildWndProc(   HWND    hWnd,   WORD    message,
								WORD    wParam, LONG    lParam  );

/*
 * Prototyp
 */

void    SetControls(    HWND hWnd );
void    ShowControls(   HWND hWnd, LONG lParam );

/*
 * Functions
 */

/****************************************************************************/
/* WinMain                                                                  */
/****************************************************************************/
int PASCAL WinMain (    HANDLE      hInstance,
						HANDLE      hPrevInstance,
						LPSTR       lpszCmdParam,
						int         nCmdShow        )

{
static  char        szAppName[]   = "Sample";
static  char        szChildName[] = "Status";
		HWND        hWnd;
		MSG         msg;
		WNDCLASS    wc;
		HANDLE      hAccelerators;

	/* Ausblenden der Compilerwarnung "not used" */
	lpszCmdParam = lpszCmdParam;

	/* Initialisiert die globale Variable "hInst" */
	hInst = hInstance;

	if( !hPrevInstance )
	{
		/*
		 * Hauptfenster
		 */
		wc.style            =   CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc      =   WndProc;
		wc.cbClsExtra       =   0;
		wc.cbWndExtra       =   0;
		wc.hInstance        =   hInstance;
		wc.hIcon            =   LoadIcon( hInstance, szAppName);
		wc.hCursor          =   LoadCursor( NULL, IDC_ARROW );
		wc.hbrBackground    =   GetStockObject( WHITE_BRUSH );
		wc.lpszMenuName     =   szAppName;
		wc.lpszClassName    =   szAppName;

		RegisterClass( &wc );

		/*
		 * Statuszeile
		 */
		wc.lpfnWndProc      =   ChildWndProc;
		wc.hIcon            =   NULL;
		wc.hCursor          =   LoadCursor( NULL, IDC_ARROW );
		wc.hbrBackground    =   GetStockObject( LTGRAY_BRUSH );
		wc.lpszMenuName     =   NULL;
		wc.lpszClassName    =   szChildName;

		RegisterClass( &wc );
	}

	hWnd = CreateWindow(    szAppName,
							"EuroSpeed DDE Test",
							WS_OVERLAPPEDWINDOW,
							0,
							0,
							350,
							300,
							NULL,
							NULL,
							hInstance,
							NULL                    );

	hWndGlob = hWnd;                    /* Setzen des globalen Windowhandles */

	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	hAccelerators = LoadAccelerators( hInstance, "DDETestAccelerators" );

	while( GetMessage ( &msg, NULL, 0, 0 ))
	{
		if( !TranslateAccelerator( hWnd, hAccelerators, &msg ))
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	}

	return msg.wParam;
}

/****************************************************************************/
/* WndProc                                                                  */
/****************************************************************************/
long FAR PASCAL WndProc(    HWND    hWnd,
							WORD    message,
							WORD    wParam,
							LONG    lParam  )
{
	/* WM_PAINT */
	PAINTSTRUCT ps;
	HDC         hDC;

		FARPROC     lpDialogProc;
static  FARPROC     lpDdeProc;
static  HCONV       hConv;

	/*
	 * Variablen fuer Common Open Dialog
	 */
	OPENFILENAME ofn;

	HANDLE  hData;
	LPLOCAL lpData;

	switch( message )
	{

	case WM_CREATE:
		SetWindowText( hWnd, "EuroSpeed Sample" );

		SetControls( hWnd );

		/* aus dem Systemmenue wird SIZE und MAXIMIZE gestrichen */
		DeleteMenu( GetSystemMenu( hWnd, FALSE ), SC_SIZE,     MF_BYCOMMAND );
		DeleteMenu( GetSystemMenu( hWnd, FALSE ), SC_MAXIMIZE, MF_BYCOMMAND );

		/* Initialize global and static variables */
		hConv = NULL;
		EnableAll( hWnd, (hConv != NULL) );
		SetProp( hWnd, "bEmpfang", FALSE );
		WriteProtokoll ( hWnd, "", FALSE ); /* Protokollfenster initialisiert */
		lpDdeProc = NULL;

		hData = GlobalAlloc (GMEM_ZEROINIT | GMEM_MOVEABLE, sizeof (LOCAL));
		if ( hData )
		{
			lpData = (LPLOCAL) GlobalLock( hData );
			_fmemset( lpData, 0, sizeof( LOCAL ));
			GlobalUnlock( hData );
			SetProp( hWnd, "hLocal", hData );
		}
		else
		{
			SetProp( hWnd, "hLocal", NULL );
			ErrorBox( hWnd, IDERR_NOMEM );
		}
		return 0L;

	case WM_PAINT:
		hDC = BeginPaint( hWnd, &ps );
		TextOut( hDC, 4, 4, "Protokoll:", lstrlen( "Protokoll:" ) );
		EndPaint( hWnd, &ps);
		return 0L;

	case WM_SIZE:
		ShowControls( hWnd, lParam );

		return 0L;

	case WM_SETFOCUS:
		SetFocus( hWndDDEan );

		return 0L;

	case WM_COMMAND:
		switch( wParam )
		{
		case IDM_DDEAN:
			hConv = UseDDEan( hWnd, lpDdeProc );
			break;

		case IDM_DDEAUS:
			if( DdeDisconnect( hConv ) )
			{
				hConv = NULL;
				SetReceive( hWnd, hConv, FALSE );     /* kein Empfang mehr */
				EnableAll( hWnd, (hConv != NULL) );
			}
			else
			{
				ErrorBox( hWnd, IDERR_DONOT );
			}
			break;

		case IDM_DATEI:
			InitOpenFileName( hWnd, &ofn );
			break;

		case IDM_SENDEN:
			UseSenden( hWnd, hConv );
			break;

		case IDM_EMPFANG:
			SetReceive( hWnd, hConv, TRUE );
			break;

		case IDM_EXIT:
			SendMessage( hWnd, WM_CLOSE, 0, 0L );
			break;

		case IDM_DELETE:                /* Protokollfenster initialisiert */
			WriteProtokoll ( hWnd, "", FALSE );
			break;

		case IDM_DISCONN:
			DDETransAktDisconn( hWnd, hConv );
			break;

		case IDM_HELP:
			WinHelp( hWnd, "Sample.HLP", HELP_INDEX, 0L );
			break;

		case IDM_HELPHELP:
			WinHelp( hWnd, "Win.HLP", HELP_HELPONHELP, 0L );
			break;

		case IDM_ABOUT:
			lpDialogProc = MakeProcInstance ( DlgAbout, hInst );
			DialogBox ( hInst, "AboutDlg", hWnd, lpDialogProc );
			FreeProcInstance ( lpDialogProc );

			break;
		default:
			if( LOWORD( lParam ) == hWndDatei )
			{
				InitOpenFileName( hWnd, &ofn );
				break;
			}

			if( LOWORD( lParam ) == hWndSend )
			{
				UseSenden( hWnd, hConv );
				break;
			}

			if( LOWORD( lParam ) == hWndEmpfang )
			{
				SetReceive( hWnd, hConv, TRUE );
				break;
			}

			if( LOWORD( lParam ) == hWndDDEan )
			{
				hConv = UseDDEan( hWnd, lpDdeProc );
				break;
			}

			if( LOWORD( lParam ) == hWndDDEaus )
			{
				if( DdeDisconnect( hConv ) )
				{
					hConv = NULL;
					SetReceive( hWnd, hConv, FALSE );  /* kein Empfang mehr */
					EnableAll( hWnd, (hConv != NULL) );
				}
				else
				{
					ErrorBox ( hWnd, IDERR_DONOT );
				}
				break;
			}
		}
		return 0L;

	case WM_DESTROY:

		if ( lpDdeProc )
		{
			DdeUninitialize ( dwDdeInst );
			FreeProcInstance( lpDdeProc );
		}
		RemoveProp( hWnd, "bConnection" );
		RemoveProp( hWnd, "bEmpfang" );
		hData = RemoveProp( hWnd, "hLocal" );
		if ( hData ) GlobalFree( hData );
		PostQuitMessage( 0 );
		return 0L;

	}

	return DefWindowProc( hWnd, message, wParam, lParam );

}


/****************************************************************************/
/* ChildWndProc                                                             */
/****************************************************************************/
long FAR PASCAL ChildWndProc(   HWND    hCldWnd,
								WORD    message,
								WORD    wParam,
								LONG    lParam  )
{
	PAINTSTRUCT ps;
	HBRUSH      hBrush;
	HDC         hDC;
	RECT        rcClient;
	DWORD		dwOldColor;
	LOGPEN		lpBlack = { PS_SOLID, 1, 1, RGB(   0,	0,	 0 ) };
	LOGPEN      lpGray  = { PS_SOLID, 1, 1, RGB( 128, 128, 128 ) };
	LOGPEN      lpWhite = { PS_SOLID, 1, 1, RGB( 255, 255, 255 ) };
	HPEN        hBlackPen, hGrayPen, hWhitePen;
	HFONT       hFont;
	LOGFONT 	lf;

	switch (message)
	{

	case WM_PAINT:
		hDC = BeginPaint( hCldWnd, &ps );

		/*
		 * Draw background
		 */
		hBrush = SelectObject (hDC, GetStockObject( LTGRAY_BRUSH ));

		GetClientRect( hCldWnd, &rcClient );
		dwOldColor = SetBkColor (hDC, 0x00C0C0C0 ); /* LTGRAY */

		DeleteObject( hBrush );

		/*
		 * Draw rectangle
		 */
		hBlackPen = CreatePenIndirect( &lpBlack );
		hGrayPen  = CreatePenIndirect( &lpGray  );
		hWhitePen = CreatePenIndirect( &lpWhite );

		/* Big rect */
		SelectObject( hDC, hBlackPen );
		MoveTo( hDC, rcClient.left,     rcClient.top );
		LineTo( hDC, rcClient.right,    rcClient.top );

		/* first little rect */
		SelectObject( hDC, hGrayPen );
		MoveTo( hDC, rcClient.left+80,  rcClient.bottom-2 );
		LineTo( hDC, rcClient.left+80,  rcClient.top+3 );
		LineTo( hDC, rcClient.left+110, rcClient.top+3 );

		/* second little rect */
		SelectObject( hDC, hGrayPen );
		MoveTo( hDC, rcClient.left+290, rcClient.bottom-2 );
		LineTo( hDC, rcClient.left+290, rcClient.top+3 );
		LineTo( hDC, rcClient.left+320, rcClient.top+3 );

		SelectObject( hDC, hWhitePen );
		/* Big rect */
		MoveTo( hDC, rcClient.left,     rcClient.top+1 );
		LineTo( hDC, rcClient.right,    rcClient.top+1 );

		/* first little rect */
		MoveTo( hDC, rcClient.left+110, rcClient.top+3 );
		LineTo( hDC, rcClient.left+110, rcClient.bottom-2 );
		LineTo( hDC, rcClient.left+80,  rcClient.bottom-2 );

		/* second little rect */
		MoveTo( hDC, rcClient.left+320, rcClient.top+3 );
		LineTo( hDC, rcClient.left+320, rcClient.bottom-2 );
		LineTo( hDC, rcClient.left+290, rcClient.bottom-2 );

		DeleteObject( hBlackPen );
		DeleteObject( hGrayPen );
		DeleteObject( hWhitePen );

		/*
		 * Schriftart einstellen
		 */

		lf.lfHeight         =   8;
		lf.lfWidth          =   0;
		lf.lfWeight         =   400;
		lf.lfEscapement     =   0;
		lf.lfOrientation    =   0;
		lf.lfItalic         =   FALSE;
		lf.lfUnderline      =   FALSE;
		lf.lfStrikeOut      =   FALSE;
		lf.lfCharSet        =   ANSI_CHARSET;
		lf.lfOutPrecision   =   OUT_DEFAULT_PRECIS;
		lf.lfClipPrecision  =   CLIP_DEFAULT_PRECIS;
		lstrcpy( lf.lfFaceName, "Helv");

		hFont   = SelectObject(hDC, CreateFontIndirect( &lf ) );

		/*
		 * Text ausgeben
		 */

		/* Verbindung */
		TextOut( hDC, 4, 4, "Verbindung:", lstrlen( "Verbindung:" ) );
		if ( GetProp( GetParent(hCldWnd), "bConnection") )
		{
			TextOut( hDC, 84, 4, "On", lstrlen( "On" ) );
		}
		else
		{
			TextOut( hDC, 84, 4, "Off", lstrlen( "Off" ) );
		}

		/* Empfang */
		TextOut( hDC, 214, 4, "Empfang:", lstrlen( "Empfang:" ) );
		if ( GetProp( GetParent(hCldWnd), "bEmpfang") )
		{
			TextOut( hDC, 294, 4, "On", lstrlen( "On" ) );
		}
		else
		{
			TextOut( hDC, 294, 4, "Off", lstrlen( "Off" ) );
		}

		DeleteObject( SelectObject( hDC, hFont));
		SetBkColor (hDC, dwOldColor );

		EndPaint( hCldWnd, &ps );

		return 0;
	}
	return DefWindowProc( hCldWnd, message, wParam, lParam );
}


/*--------------------------------------------------------------------------*/
/*  SetControls: Erstellt die Windowshandles fuer alle Unterfenster         */
/*--------------------------------------------------------------------------*/
void SetControls( HWND hWnd )
{

		hCldWnd = CreateWindow( "Status", NULL,
								WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndDDEan = CreateWindow( "button", "DDE on",
								BS_DEFPUSHBUTTON | WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndDDEaus = CreateWindow( "button", "DDE off",
								BS_DEFPUSHBUTTON | WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndDatei = CreateWindow( "button", "Datei...",
								BS_PUSHBUTTON | WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndSend = CreateWindow( "button", "Senden...",
								BS_PUSHBUTTON | WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndEmpfang = CreateWindow( "button", "Empfang",
								BS_PUSHBUTTON | WS_CHILDWINDOW | WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );
		hWndProtokoll = CreateWindow( "edit", "",
								ES_MULTILINE |
								ES_LEFT |
								WS_VSCROLL |
								WS_HSCROLL |
								WS_BORDER |
								WS_CHILD |
								WS_VISIBLE,
								0, 0, 0, 0, hWnd, NULL, hInst, NULL );

}

/*--------------------------------------------------------------------------*/
/*  ShowControls: Ermoeglicht die Anzeige der Unterfenster in der be-       */
/*                rechneten Groesse.                                        */
/*--------------------------------------------------------------------------*/
void ShowControls( HWND hWnd, LONG lParam )
{
	hWnd = hWnd;

	MoveWindow( hCldWnd,                                /* Status      */
				0,                                      /*   X-Pos     */
				HIWORD( lParam ) - STATUS_HEIGHT,       /*   Y-Pos     */
				LOWORD( lParam ),                       /*   Width     */
				STATUS_HEIGHT,                          /*   height    */
				TRUE );                                 /*   Repaint   */
	MoveWindow( hWndDatei,                              /* Datei       */
				LOWORD( lParam ) - (BUTTON_WIDTH +4),
				10,
				BUTTON_WIDTH,
				BUTTON_HEIGHT,
				TRUE );
	MoveWindow( hWndSend,                               /* Senden      */
				LOWORD( lParam ) - (BUTTON_WIDTH +4),
				40,
				BUTTON_WIDTH,
				BUTTON_HEIGHT,
				TRUE );
	MoveWindow( hWndEmpfang,                            /* Empfang     */
				LOWORD( lParam ) - (BUTTON_WIDTH +4),
				70,
				BUTTON_WIDTH,
				BUTTON_HEIGHT,
				TRUE );
	MoveWindow( hWndDDEan,                              /* DDE an      */
				LOWORD( lParam ) - (BUTTON_WIDTH +4),
				HIWORD( lParam ) - (STATUS_HEIGHT) - ((2 * BUTTON_HEIGHT) +4 +4),
				BUTTON_WIDTH,
				BUTTON_HEIGHT,
				TRUE );
	MoveWindow( hWndDDEaus,                             /* DDE aus     */
				LOWORD( lParam ) - (BUTTON_WIDTH +4),
				HIWORD( lParam ) - (STATUS_HEIGHT) - (BUTTON_HEIGHT +4),
				BUTTON_WIDTH,
				BUTTON_HEIGHT,
				TRUE );
	MoveWindow( hWndProtokoll,                          /* Editfeld    */
				4,
				24,
				LOWORD( lParam ) - ((BUTTON_WIDTH  +4) +8),
				HIWORD( lParam ) - ((STATUS_HEIGHT +4) +30),
				TRUE );

}
