/*  Project : CITT - Highspeed
 * $Source: h:./rcs/ftddeml.h $
 *  Item    : dde interface 
 * $Date: 1993/01/12 10:23:20 $
 *  Author  : ug
 */

/*************************************************************************/
/*  DDE - Interface between CITT - Highspeed Application an Fileserver   */
/*************************************************************************/

/* vi; ts=4 */

/* miscallanous constants */

#define MAX_HOTITEMS        16
#define MAX_ITEM_LEN        20
#define MAX_TOPICS          1
#define MAX_TOPIC_LEN       16
#define MAX_FORMATS         42

#define NIL_TOPIC           -1


/* dde service string (and window class of server) */

#define SZDDE_SERVICE_NAME "EuroSrv"


/* indices of topics */

#define C_CONNECTION    1


/* dde topic string */

#define SZDDE_TOPIC_CONNECTION  "CONNECTION"


/* dde item strings */

#define SZDDE_ITEM_LOCAL_LOGBOOK        "LocalLogbook"
#define SZDDE_ITEM_LOCAL_LOGNAME        "LocalLogname"
#define SZDDE_ITEM_LOCAL_CHANNELMODE    "LocalChannelMode"
#define SZDDE_ITEM_DIR_PROTECT_REQ      "DirProtectReq"
#define SZDDE_ITEM_DIR_PROTECT_RESP     "DirProtectResp"
#define SZDDE_ITEM_DIR_PROTECT_UPDATE   "DirProtectUpdate"
#define SZDDE_ITEM_SYS_PROTECT_GET      "SysProtectGet"
#define SZDDE_ITEM_SYS_PROTECT_DELETE   "SysProtectDelete"
#define SZDDE_ITEM_SYS_PROTECT_ADD      "SysProtectAdd"
#define SZDDE_ITEM_CONNECT_REQ      	"ConnectReq"
#define SZDDE_ITEM_CONNECT_STATE        "ConnectState"
#define SZDDE_ITEM_DISCONNECT_REQ 		"DisconnectReq"
#define SZDDE_ITEM_DISCONNECT_STATE     "DiscState"
#define SZDDE_ITEM_SAVE_REQ             "SaveReq"
#define SZDDE_ITEM_SAVE_STATE           "SaveState"
#define SZDDE_ITEM_LOAD_REQ             "LoadReq"
#define SZDDE_ITEM_LOAD_STATE           "LoadState"
#define SZDDE_ITEM_DIR_REQ              "DirReq"
#define SZDDE_ITEM_DIR_STATE            "DirState"
#define SZDDE_ITEM_RENAME_REQ           "RenameReq"
#define SZDDE_ITEM_RENAME_STATE         "RenameState"
#define SZDDE_ITEM_DELETE_REQ           "DeleteReq"
#define SZDDE_ITEM_DELETE_STATE         "DeleteState"
#define SZDDE_ITEM_CHPASSWD_REQ      	"ChPasswdReq"
#define SZDDE_ITEM_CHPASSWD_STATE       "ChPasswdState"
#define SZDDE_ITEM_VERSION_GET          "VersionGet"
#define SZDDE_ITEM_ABORT_REQ          	"AbortReq"
#define SZDDE_ITEM_SERVER_STATE         "ServerState"
#define SZDDE_ITEM_REMOTE_TREE_GET      "RemoteTreeReq"
#define SZDDE_ITEM_REMOTE_TREE_STATE    "RemoteTreeState"
#define SZDDE_ITEM_LISTEN_REQ           "ListenReq"
#define SZDDE_ITEM_TYPED_DATA_REQ		"TypedDataReq"
#define SZDDE_ITEM_TYPED_DATA_IND		"TypedDataInd"
#define SZDDE_ITEM_INFO_REQ				"InfoReq"
#define SZDDE_ITEM_INFO_IND				"InfoInd"
#define SZDDE_ITEM_MKDIR_REQ			"MkDirReq"
#define SZDDE_ITEM_MKDIR_STATE			"MkDirState"
#define SZDDE_ITEM_RMDIR_REQ			"RmDirReq"
#define SZDDE_ITEM_RMDIR_STATE			"RmDirState"
#define SZDDE_ITEM_PUBLICDIR_REQ		"PublicDirReq"
#define SZDDE_ITEM_PUBLICDIR_STATE		"PublicDirState"
#define SZDDE_ITEM_CONNECT_IND			"ConnectInd"
#define SZDDE_ITEM_DISCONNECT_IND		"DisconnectInd"
#define SZDDE_ITEM_DIR_IND				"DirInd"
#define SZDDE_ITEM_LOAD_IND				"LoadInd"
#define SZDDE_ITEM_SAVE_IND				"SaveInd"
#define SZDDE_ITEM_DELETE_IND			"DeleteInd"
#define SZDDE_ITEM_RENAME_IND			"RenameInd"


/* indices of new clipboard formats */

#define C_LOCAL_LOGBOOK         1
#define C_LOCAL_LOGNAME         2
#define C_LOCAL_CHANNELMODE     3
#define C_DIR_PROTECT_REQ       4
#define C_DIR_PROTECT_RESP      5
#define C_DIR_PROTECT_UPDATE    6
#define C_SYS_PROTECT_GET       7
#define C_SYS_PROTECT_DELETE    8
#define C_SYS_PROTECT_ADD       9
#define C_CONNECT_REQ       	10
#define C_CONNECT_STATE         11
#define C_DISCONNECT_REQ 		12
#define C_DISCONNECT_STATE      13
#define C_SAVE_REQ              14
#define C_SAVE_STATE            15
#define C_LOAD_REQ              16
#define C_LOAD_STATE            17
#define C_DIR_REQ               18
#define C_DIR_STATE             19
#define C_RENAME_REQ            20
#define C_RENAME_STATE          21
#define C_DELETE_REQ            22
#define C_DELETE_STATE          23
#define C_CHPASSWD_REQ       	24
#define C_CHPASSWD_STATE        25
#define C_VERSION_GET           26
#define C_ABORT_REQ             27
#define C_SERVER_STATE          28
#define C_REMOTE_TREE_REQ       29
#define C_REMOTE_TREE_STATE     30
#define C_LISTEN_REQ            31
#define C_TYPED_DATA_REQ		32
#define C_TYPED_DATA_IND		33
#define C_INFO_REQ				34
#define C_INFO_IND				35
#define C_MKDIR_REQ				36
#define C_MKDIR_STATE			37
#define C_RMDIR_REQ				38
#define C_RMDIR_STATE			39
#define C_PUBLICDIR_REQ			40
#define C_PUBLICDIR_STATE		41
#define C_CONNECT_IND			42
#define C_DISCONNECT_IND		43
#define C_DIR_IND				44
#define C_LOAD_IND				45
#define C_SAVE_IND				46
#define C_DELETE_IND			47
#define C_RENAME_IND			48


/* strings for selfdefined clipboard formats */

#define SZDDE_FMT_LOCAL_LOGBOOK         "LOCAL_LOGBOOK"
#define SZDDE_FMT_LOCAL_LOGNAME         "LOCAL_LOGNAME"
#define SZDDE_FMT_LOCAL_CHANNELMODE     "LOCAL_CHANNELMODE"
#define SZDDE_FMT_DIR_PROTECT_REQ       "DIR_PROTECT_REQ"
#define SZDDE_FMT_DIR_PROTECT_RESP      "DIR_PROTECT_RESP"
#define SZDDE_FMT_DIR_PROTECT_UPDATE    "DIR_PROTECT_UPDATE"
#define SZDDE_FMT_SYS_PROTECT_GET       "SYS_PROTECT_GET"
#define SZDDE_FMT_SYS_PROTECT_DELETE    "SYS_PROTECT_DELETE"
#define SZDDE_FMT_SYS_PROTECT_ADD       "SYS_PROTECT_ADD"
#define SZDDE_FMT_CONNECT_REQ           "CONNECT_REQ"
#define SZDDE_FMT_CONNECT_STATE         "CONNECT_STATE"
#define SZDDE_FMT_DISCONNECT_REQ 		"DISCONNECT_REQ"
#define SZDDE_FMT_DISCONNECT_STATE      "DISCONNECT_STATE"
#define SZDDE_FMT_SAVE_REQ              "SAVE_REQ"
#define SZDDE_FMT_SAVE_STATE            "SAVE_STATE"
#define SZDDE_FMT_LOAD_REQ              "LOAD_REQ"
#define SZDDE_FMT_LOAD_STATE            "LOAD_STATE"
#define SZDDE_FMT_DIR_REQ               "DIR_REQ"
#define SZDDE_FMT_DIR_STATE             "DIR_STATE"
#define SZDDE_FMT_RENAME_REQ            "RENAME_REQ"
#define SZDDE_FMT_RENAME_STATE          "RENAME_STATE"
#define SZDDE_FMT_DELETE_REQ            "DELETE_REQ"
#define SZDDE_FMT_DELETE_STATE          "DELETE_STATE"
#define SZDDE_FMT_CHPASSWD_REQ       	"CHPASSWD_REQ"
#define SZDDE_FMT_CHPASSWD_STATE        "CHPASSWD_STATE"
#define SZDDE_FMT_VERSION_GET           "VERSION_GET"
#define SZDDE_FMT_ABORT_REQ             "ABORT_REQ"
#define SZDDE_FMT_SERVER_STATE          "SERVER_STATE"
#define SZDDE_FMT_REMOTE_TREE_REQ       "REMOTE_TREE_REQ"
#define SZDDE_FMT_REMOTE_TREE_STATE     "REMOTE_TREE_STATE"
#define SZDDE_FMT_LISTEN_REQ            "LISTEN_REQ"
#define SZDDE_FMT_TYPED_DATA_REQ		"TYPED_DATA_REQ"
#define SZDDE_FMT_TYPED_DATA_IND		"TYPED_DATA_IND"
#define SZDDE_FMT_INFO_REQ				"INFO_REQ"
#define SZDDE_FMT_INFO_IND				"INFO_IND"
#define SZDDE_FMT_MKDIR_REQ				"MKDIR_REQ"
#define SZDDE_FMT_MKDIR_STATE			"MKDIR_STATE"
#define SZDDE_FMT_RMDIR_REQ				"RMDIR_REQ"
#define SZDDE_FMT_RMDIR_STATE			"RMDIR_STATE"
#define SZDDE_FMT_PUBLICDIR_REQ			"PUBLICDIR_REQ"
#define SZDDE_FMT_PUBLICDIR_STATE		"PUBLICDIR_STATE"
#define SZDDE_FMT_CONNECT_IND			"CONNECT_IND"
#define SZDDE_FMT_DISCONNECT_IND		"DISCONNECT_IND"
#define SZDDE_FMT_DIR_IND				"DIR_IND"
#define SZDDE_FMT_LOAD_IND				"LOAD_IND"
#define SZDDE_FMT_SAVE_IND				"SAVE_IND"
#define SZDDE_FMT_DELETE_IND			"DELETE_IND"
#define SZDDE_FMT_RENAME_IND			"RENAME_IND"


/* strings and indices of logbook */

#define C_IND_LOG_START_SERVER 	0
#define C_IND_LOG_END_SERVER 	1
#define C_IND_LOG_INCOMING_CALL 2
#define C_IND_LOG_START_CALLING 3
#define C_IND_LOG_END_CALLING   4

#define C_IND_LOG_RCV_DIR		5
#define C_IND_LOG_SEND_DIR		6
#define C_IND_LOG_RCV_FILE		7
#define C_IND_LOG_SEND_FILE		8
#define C_IND_LOG_GET_FILE		9

#define C_IND_LOG_ANSWER_FILE	10
#define C_IND_LOG_RENAME_FILE	11
#define C_IND_LOG_DELETE_FILE	12
#define C_IND_LOG_ABORT_COM		13
#define C_IND_LOG_RCV_ABORT_COM	14

#define C_IND_LOG_ABORT_TRANS	15
#define C_IND_LOG_RCV_ABORT_TRANS 16
#define C_IND_LOG_RCV_MSG		17
#define C_IND_LOG_SEND_MSG		18
#define C_IND_LOG_DIALOG_SESSION 19


/* constants of the defined dde messages */

#define ACCESS_READ         1
#define ACCESS_WRITE        2
#define ACCESS_TRANSPOSE    4

#define SERVER_STATE_IDLE         0
#define SERVER_STATE_ACCESS       8
#define SERVER_STATE_IND_DIR_SEND   12
#define SERVER_STATE_DIR_SEND       13
#define SERVER_STATE_REQ_DIR_RCV    14
#define SERVER_STATE_DIR_RCV        15
#define SERVER_STATE_REQ_FILE_SEND   16
#define SERVER_STATE_FILE_SEND       17
#define SERVER_STATE_IND_FILE_RCV    18
#define SERVER_STATE_FILE_RCV        19
#define SERVER_STATE_REQ_FILE_GET    20
#define SERVER_STATE_FILE_GET        21
#define SERVER_STATE_IND_FILE_ANSWER 22
#define SERVER_STATE_FILE_ANSWER     23
#define SERVER_STATE_REMOTE_DEL     25
#define SERVER_STATE_REMOTE_REN     27
#define SERVER_STATE_REQ_CHPASSWD   28
#define SERVER_STATE_CHPASSWD       29
#define SERVER_STATE_REQ_TREE_GET   32
#define SERVER_STATE_TREE_GET       33
#define SERVER_STATE_REQ_SBASE      34
#define SERVER_STATE_SBASE          35
#define SERVER_STATE_RES_SBASE		37
#define SERVER_STATE_REQ_SELECT     38
#define SERVER_STATE_SELECT         39
#define SERVER_STATE_REQ_SLIST      40
#define SERVER_STATE_SLIST          41
#define SERVER_STATE_RES_SLIST		43
#define SERVER_STATE_REQ_LIST       44
#define SERVER_STATE_LIST           45
#define SERVER_STATE_REQ_MKDIR		48
#define SERVER_STATE_MKDIR			49
#define SERVER_STATE_REQ_RMDIR		52
#define SERVER_STATE_RMDIR			53
#define SERVER_STATE_NOMEM          70

#define CONNECT_STATE_OK            0
#define CONNECT_STATE_REFUSE        1
#define CONNECT_STATE_NOMEM         2
#define CONNECT_STATE_SERVER_BUSY	6
#define CONNECT_STATE_NET_FAILURE 	0x30
#define CONNECT_STATE_ILL_REF		0x31
#define CONNECT_STATE_NO_SERVICE	0x32
#define CONNECT_STATE_WRONG_CID		0x33
#define CONNECT_STATE_USED_CID		0x34
#define CONNECT_STATE_NO_FREE_CHAN	0x35
#define CONNECT_STATE_UNKNOWN_FAC	0x36
#define CONNECT_STATE_FAC_REJECT	0x37
#define CONNECT_STATE_CALL_BARRED	0x38
#define CONNECT_STATE_ALL_CHAN_BUSY	0x39
#define CONNECT_STATE_NEG_GBG		0x3a
#define CONNECT_STATE_CHECK_FAILED	0x3b
#define CONNECT_STATE_NO_REV_CHARGE 0x3c
#define CONNECT_STATE_RES1			0x3d
#define CONNECT_STATE_RES2			0x3e
#define CONNECT_STATE_WRONG_ADR		0x3f
#define CONNECT_STATE_CHANGED_NUMBER 0x40
#define CONNECT_STATE_OUT_OF_ORDER 	0x41
#define CONNECT_STATE_NO_ANSWER		0x42
#define CONNECT_STATE_USER_BUSY		0x43
#define CONNECT_STATE_BARRED		0x44
#define CONNECT_STATE_CALL_REJ 		0x45 
#define CONNECT_STATE_NO_CAPACITY	0x46
#define CONNECT_STATE_NET_REJ		0x47
#define CONNECT_STATE_LOKAL_ERR		0x48
#define CONNECT_STATE_REMOTE_ERR	0x49
#define CONNECT_STATE_REMOTE_SUSP	0x4a
#define CONNECT_STATE_REMOTE_NOT_SUSP 0x4b
#define CONNECT_STATE_DISC_USER_INFO 0x4c
#define CONNECT_STATE_ERR_SERIAL	0x50
#define CONNECT_STATE_ERR_APPL		0x51
#define CONNECT_STATE_TIMEOUT		0x71
#define CONNECT_STATE_SYNTAX_ERROR  0x73
#define CONNECT_STATE_UNKNOWN_ERR	0x74

#define DISCONNECT_STATE_OK         0
#define DISCONNECT_STATE_ABORT      1
#define DISCONNECT_STATE_NOMEM      2
#define DISCONNECT_STATE_SERVER_BUSY 6

#define SAVE_STATE_OK               0
#define SAVE_STATE_ABORT			1
#define SAVE_STATE_REMOTE_ABORT     3
#define SAVE_STATE_IN_PROGRESS      4
#define SAVE_STATE_NOMEM            5
#define SAVE_STATE_SERVER_BUSY		6
#define SAVE_STATE_DISK_FULL		0x22
#define SAVE_STATE_ACCESS_VIOLATION 0x23
#define SAVE_STATE_DIR_FULL			0x32
#define SAVE_STATE_ILL_FILENAME   	0x47
#define SAVE_STATE_FILE_NOT_FOUND	0x49
#define SAVE_STATE_FILE_EXISTS		0x4a

#define LOAD_STATE_OK               0
#define LOAD_STATE_CANT_CREATE_FILE 1
#define LOAD_STATE_REMOTE_ABORT     3
#define LOAD_STATE_IN_PROGRESS      4
#define LOAD_STATE_NOMEM            5
#define LOAD_STATE_SERVER_BUSY		6
#define LOAD_STATE_DISK_FULL		0x22
#define LOAD_STATE_ACCESS_VIOLATION 0x23
#define LOAD_STATE_FILE_NOT_FOUND   0x49

#define DIR_STATE_OK                0
#define DIR_STATE_ABORT				1
#define DIR_STATE_REMOTE_ABORT      3
#define DIR_STATE_NOMEM             5
#define DIR_STATE_SERVER_BUSY		6
#define DIR_STATE_ACCESS_VIOLATION  0x23
#define DIR_STATE_DIR_NOT_FOUND		0x49

#define RENAME_STATE_OK             0
#define RENAME_STATE_ABORT			1
#define RENAME_STATE_REMOTE_ABORT   3
#define RENAME_STATE_NOMEM          5
#define RENAME_STATE_SERVER_BUSY	6
#define RENAME_STATE_ACCESS_VIOLATION 0x23
#define RENAME_STATE_ILL_FILENAME	0x47
#define RENAME_STATE_FILE_NOT_FOUND 0x49
#define RENAME_STATE_FILE_EXISTS	0x4d

#define DELETE_STATE_OK             0
#define DELETE_STATE_ABORT			1
#define DELETE_STATE_REMOTE_ABORT   3
#define DELETE_STATE_NOMEM          5
#define DELETE_STATE_SERVER_BUSY	6
#define DELETE_STATE_ACCESS_VIOLATION 0x23
#define DELETE_STATE_ILL_FILENAME	0x47
#define DELETE_STATE_FILE_NOT_FOUND 0x49

#define DIR_PROTECT_RESP_OK         0
#define DIR_PROTECT_RESP_INV_DIR    2
#define DIR_PROTECT_NOMEM           5
#define DIR_PROTECT_RESP_NOMEM      6

#define CHPASSWD_STATE_OK           0
#define CHPASSWD_STATE_NOMEM        5
#define CHPASSWD_STATE_SERVER_BUSY  6
#define CHPASSWD_STATE_WRONG_ID 	0x21
#define CHPASSWD_STATE_WRONG_PASSWD 0x31
#define CHPASSWD_STATE_FAILURE      0x32

#define REMOTE_TREE_STATE_OK        0
#define REMOTE_TREE_STATE_FAILURE   1
#define REMOTE_TREE_STATE_NOMEM     5
#define REMOTE_TREE_STATE_SERVER_BUSY 6

#define MKDIR_STATE_OK				0
#define MKDIR_STATE_NOMEM			5
#define MKDIR_STATE_SERVER_BUSY		6
#define MKDIR_STATE_ACCESS_VIOLATION 0x23
#define MKDIR_STATE_ILL_NAME		0x47
#define MKDIR_STATE_NOT_FOUND		0x49
#define MKDIR_STATE_FILE_EXISTS		0x4d

#define RMDIR_STATE_OK				0
#define RMDIR_STATE_NOMEM			5
#define RMDIR_STATE_SERVER_BUSY		6
#define RMDIR_STATE_ACCESS_VIOLATION 0x23
#define RMDIR_STATE_NOT_EMPTY		0x34
#define RMDIR_STATE_ILL_NAME		0x47
#define RMDIR_STATE_NOT_FOUND		0x49

#define PUBLICDIR_STATE_OK				0
#define PUBLICDIR_STATE_NOMEM			5
#define PUBLICDIR_STATE_SERVER_BUSY		6

#define M_ABORT_TRANSFER            2
#define M_ABORT_CUR_FILE            4

#define M_LISTEN_CHECK_NUMBER       1

#define M_LOCAL_COMPRESSION			1

#define M_CONNECT_FLAG_IS_ACOAPPL	 1
#define M_CONNECT_FLAG_IS_KNOWN_USER 2


typedef struct {            /* struct to represent RegisterClipboardFormat */
  ATOM atom;                /* atom represents new clipboard format */
  PSTR sz;                  /* name of the clipboard format */
} FORMATINFO;


/* structs of topic CONNECTION */
                            
typedef struct server_state_t { /* item SERVER_STATE; Advise: Server -> Client */
  BYTE ubState;             /* state of server/connection */
  DWORD dwCharge;           /* charging info so far for the connection */
} server_state_t;


typedef struct {            /* item LOCAL_LOGBOOK; Poke: Client -> Server */
  DWORD dwLogCount;         /* number of log entries; 0=logbook off */
} local_logbook_t;

typedef struct {            /* item LOCAL_GET_LOGNAME; Request: Server -> Client */
  BYTE szLogbookName[255];  /* name of logbook for this user */
} local_get_logname_t;
                            
typedef struct {            /* item LOCAL_CHANNEL_MODE; Poke: Client -> Server */
  BYTE ubMinChannel;        /* count of permanent connected channels */
  BYTE ubMaxChannel;        /* count of connected channels while transfer */
  BYTE ubCompression;		/* M_LOCAL_COMPRESSION for sending files compressed */
} local_channel_mode_t;

                            
typedef struct {            /* item DIR_PROTECT_REQ; Poke: Client -> Server */
  BYTE szDirName[255];      /* complete pathname of dir to get access rights for */
} dir_protect_req_t;
 
typedef struct dir_protect_resp_t { /* item DIR_PROTECT_RESP; Advise: Server -> Client */
  WORD  wState;             /* signal success or failure on request */
  DWORD dwDirLineLen;       /* length of the following data */
  BYTE szDirLine[1];        /* data block with directory line */
                            /* format is: 
                               DirName={UserId:AccessRights;}[,MaxDirLen]
                               UserId can be in the range of 0 until -2L, or
                                 '*' for all Users
                               AccessRights can be OR'ed:
                                 bit0 set: read this dir and its files
                                 bit1 set: write files to this dir, 
                                 bit2 set: same rights on subdirectories 
                               MaxDirLen can be in the range of 0 until -2L, or
                                 '*' for every length
                            */
} dir_protect_resp_t;

typedef struct {            /* item DIR_PROTECT_UPDATE; Poke: Client -> Server */
  DWORD dwDirLineLen;       /* length of the following data */
  BYTE szDirLine[1];        /* data block with directory line */
                            /* same format as above */
} dir_protect_update_t;


typedef struct {            /* item SYS_PROTECT_GET; Request: Server -> Client */
  DWORD dwUserListLen;      /* length of the following data */
  BYTE szUserList[1];       /* data block with list of known remote user */
                            /* format is:
                               {UserName=UserId;}
                            */
} sys_protect_get_t;

typedef struct {            /* item SYS_PROTECT_DELETE; Poke: Client -> Server */
  DWORD dwUserId;           /* id of a known remote user */
} sys_protect_delete_t;

typedef struct {            /* item SYS_PROTECT_ADD; Poke: Client -> Server */
  BYTE szUsername[13];      /* name of new user */
  BYTE szPassword[13];      /* password (gecryptet) */
} sys_protect_add_t;


typedef struct {            /* item CONNECT_REQ; Poke: Client -> Server */
  BYTE szCallingNo[64];     /* number of caller */
  BYTE szCalledNo1[64];     /* number of called party */
  BYTE szCalledNo2[64];     /* number of called party */
  BYTE szUserName[13];      /* own user name */
  BYTE szPassword[13];      /* own password */
  BYTE szApplName[17];      /* name of remote application */
  BYTE ubTimeout;           /* time for response of remote party */
  BYTE ubWinSize;           /* window size of ets 300075 data blks; (1-8) */
                            /* should be 8 */
  DWORD dwBlkSize;          /* size of ets 300075 data blks; (2^9 - 2^16) */
} connect_req_t;
                            
typedef struct connect_state_t { /* item CONNECT_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: NOERR; else errcode (ffs.) */
  DWORD dwCharge;           /* cost of whole connection so far */
  WORD wFlags;				/* flags for application */
} connect_state_t;


typedef struct {            /* item DISCONNECT_REQ; Poke: Client -> Server */
  BYTE ubDummy;             /* not in use */
} disconnect_req_t;

typedef struct disconnect_state_t { /* item DISCONNECT_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: NOERR; else errcode (ffs.) */
  DWORD dwCharge;           /* cost of whole connection */
} disconnect_state_t;


typedef struct {                /* item SAVE_REQ; Poke: Client -> Server */
  DWORD dwFileLen;              /* length of the file to send */
  BYTE szLocalFileName[255];    /* name of the file to be sent to remote party */
  BYTE szRemotePathName[255];   /* name of the destination path */
} save_req_t;

typedef struct save_state_t {   /* item SAVE_STATE; Advise: Server -> Client */
  WORD wState;                  /* 0: ready; else: in progress / error / abort */
  WORD uwSpeed;					/* in kBit per second since file transfer start */
  DWORD dwCharge;               /* charging info */
  DWORD dwTransferredLen;       /* size of file already sent */
  BYTE szLocalFileName[255];    /* local name of the file which is or is not sent */
  BYTE szRemotePathName[255];   /* remote name of the file which is or is not sent */
} save_state_t; 


typedef struct {                /* item LOAD_REQ; Poke: Client -> Server */
  DWORD dwFileLen;              /* length of the file to get */
  BYTE szLocalPathName[255];    /* name of the local destination path */
  BYTE szRemoteFileName[255];   /* name of the file name to get from the remote party */
} load_req_t;

typedef struct load_state_t { /* item LOAD_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: ready; else: in progress / error / abort */
  WORD uwSpeed;				/* in kBit per second since file transfer start */
  DWORD dwCharge;           /* charging info */
  
  DWORD dwTransferredLen;   /* size of file already received */
  BYTE szLocalPathName[255];/* name of the local destination path */
  BYTE szRemoteFileName[255];/* remote name of the file which has been loaded */
} load_state_t;


typedef struct {            /* item DIR_REQ; Poke: Client -> Server */
  BYTE szPathName[255];     /* complete pathname of dir to be received */
  BYTE szSearchMask[82];	/* optional mask with wildcard */
} dir_req_t;

typedef struct dir_state_t {/* item DIR_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: ready; else: in progress / error / abort */
  DWORD dwDirBufferLen;     /* length of the following Buffer */
  BYTE szDirBuffer[1];      /* contents of directory */
} dir_state_t;


typedef struct {            /* item RENAME_REQ; Poke: Client -> Server */
  BYTE szOldRemoteFileName[255];  /* old name of the file to be renenamed */
  BYTE szNewRemoteFileName[255];  /* new name of the file to be renamed */
} rename_req_t;

typedef struct rename_state_t { /* item RENAME_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: ready; else: in progress / error / abort */
  BYTE szOldFileName[255];  /* old name of the file to be renamed */
  BYTE szNewFileName[255];  /* new name of the file to be renamed */
} rename_state_t;


typedef struct {            /* item DELETE_REQ; Poke: Client -> Server */
  BYTE szRemoteFileName[255];     /* name of the file to be received from remote party */
} delete_req_t;

typedef struct delete_state_t { /* item DELETE_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: ready; else: in progress / error / abort */
  BYTE szRemoteFileName[255];   /* name of the file that has been or hasnt been deleted */
} delete_state_t;


typedef struct {            /* item CHPASSWD_REQ; Poke: Client -> Server */
  BYTE szUserName[13];      /* name of user who wants to change his own passwd */
  BYTE szOldPassword[13];   /* old password (crypted) */
  BYTE szNewPassword[13];   /* new password (crypted) */
} chpasswd_req_t;
                            
typedef struct chpasswd_state_t {/* item CHPASSWD_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: NOERR; else: error (ffs.) */
} chpasswd_state_t;


typedef struct {            /* item VERSION_GET; Request: Client -> Server */
  BYTE szVersion[256];      /* released version */
} version_get_t;


typedef struct {            /* item ABORT_REQ; Poke: Client -> Server */
  DWORD dwFlags;            /* abort whole transfer or just current file */
} abort_req_t;


typedef struct {            /* item LISTEN_REQ; Poke: Client -> Server */
  WORD wFlag;               /* flag M_LISTEN_DO allows checking for calling numbers */
  BYTE szTelNumberFileName[255]; /* name of file, that contains checkable numbers */
} listen_req_t;


typedef struct {            /* item REMOTE_TREE_REQ; Poke: Client -> Server */
  BYTE szRemoteTree[255];   /* name of the remote tree to get */
} remote_tree_req_t;

typedef struct {			/* item REMOTE_TREE_STATE; Advise: Server -> Client */
  WORD wState;              /* 0: NOERR, else ERROR */
  BYTE szLocalName[255];    /* local name of the file containing the remote tree */
} remote_tree_state_t;

typedef struct {			/* item TYPED_DATA_REQ; Poke; Synchron; Client -> Server */
  BYTE szTypedData[255];	/* message for remote side */
} typed_data_req_t;	

typedef struct {			/* item TYPED_DATA_IND; Advise: Server -> Client */
  BYTE szTypedData[255];	/* message from remote side */
} typed_data_ind_t;	

typedef struct {			/* item INFO_REQ; Request; Synchron; Server->Client */
  DWORD dwCharge;			/* current charges */
  WORD uwChanCnt;			/* current number of opened channels */
} info_req_t;	

typedef struct {			/* item INFO_IND; Advise; Server->Client */
  DWORD dwCharge;			/* current charges */
  WORD uwChanCnt;			/* current number of opened channels */
} info_ind_t;	

typedef struct {			/* item MKDIR_REQ; Poke; Client -> Server */
  BYTE szDirName[255];      /* name of directory to make */
} mkdir_req_t;

typedef struct {			/* item MKDIR_STATE; Advise; Server -> Client */
  WORD wState;				/* error state */
  BYTE szDirName[255];		/* name of directory probably maked */
} mkdir_state_t;

typedef struct {			/* item RMDIR_REQ; Poke; Client -> Server */
  BYTE szDirName[255];		/* name of directory to delete */
} rmdir_req_t;		

typedef struct {			/* item RMDIR_STATE; Advise; Server -> Client */
  WORD wState;				/* error state */
  BYTE szDirName[255];		/* name of directory probably deleted */
} rmdir_state_t;

typedef struct {			/* item PUBLICDIR_REQ; Poke: Client -> Server */
  WORD wState;				/* */
} publicdir_req_t;			/* empty */

typedef struct {			/* item PUBLICDIR_STATE; Advise; Server -> Client */
  WORD wState;				/*  */
  BYTE szDirName[255];
} publicdir_state_t;	

typedef struct {			/* item CONNECT_IND; Advise; Server -> Client */
  WORD wFlags;				/* 
  BYTE szUserData[64];		/* user reserved info from caller */
  BYTE szCallingNo[64];		/* ISDN number of caller */
  BYTE szUserName[13];		/* name of remote user */
} connect_ind_t;

typedef struct {			/* item DISCONNECT_IND; Advise; Server -> Client */
  BYTE szCallingNo[64];		/* ISDN number of caller */
  BYTE szUserName[13];		/* name of remote user */
} disconnect_ind_t;

typedef struct {			/* item DIR_IND; Advise; Server -> Client */
  BYTE szDirName[255];		/* name of dir to get */
} dir_ind_t;

typedef struct {			/* item SAVE_IND; Advise; Server -> Client */
  BYTE szFileName[255];		/* name of file to save */
} save_ind_t;

typedef struct {			/* item LOAD_IND; Advise; Server -> Client */
  BYTE szFileName[255];		/* name of file to load */
} load_ind_t;

typedef struct {			/* item DELETE_IND; Advise; Server -> Client */
  BYTE szFileName[255];		/* name of file to delete */
} delete_ind_t;

typedef struct {			/* item RENAME_IND; Advise; Server -> Client */
  BYTE szOldFileName[255];	/* old name of file to rename */
  BYTE szNewFileName[255];	/* new name of file to rename */	
} rename_ind_t;	
